/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.sql.util;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandlerBase;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;

public class SQLTransactionExecuteHandler
extends SQLExecuteHandlerBase {
    public SQLTransactionExecuteHandler(SDSCategory logCategory) {
        super(logCategory);
    }

    public Object executeRetry(SQLExecute sqlExecute) throws TaskPersistLayerException {
        try {
            TaskPersistLayer.startTransaction();
        }
        catch (TaskPersistLayerException e) {
            this.debugLog("Error starting a transaction!");
            this.debugLog(e);
            throw e;
        }
        Object result = null;
        try {
            result = sqlExecute.execute();
            TaskPersistLayer.commitTransaction();
        }
        catch (Exception e) {
            this.debugLog("Error executing a transaction!");
            this.debugLog(e);
            TaskPersistLayer.rollbackTransaction();
            if (e instanceof TaskPersistLayerException) {
                throw (TaskPersistLayerException)e;
            }
            throw new TaskPersistLayerException(e);
        }
        finally {
            TaskPersistLayer.closeTransactionConnection();
        }
        return result;
    }
}

