/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tasks;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AgentTaskDefinition;
import com.cognos.developer.schemas.bibus._3.AgentTaskState;
import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseRSSTask;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Shortcut;
import com.cognos.developer.schemas.bibus._3.ShortcutRSSTask;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.URL;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tasks.AgentTaskOutputState;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.OptionUtils;

public class AgentTaskOutputStateService {
    private static final OMBuilder m_state_builder = new OMBuilder();

    public static AgentTaskOutputState getAgentTaskOutputState(BaseClass agent_child, JobBiBusHeaders headers) throws Exception {
        return m_state_builder.getState(agent_child, headers);
    }

    public static void updateAgentTaskOutputState(AgentTaskOutputState state, BaseClass agent_child, JobBiBusHeaders headers) throws Exception {
        m_state_builder.updateState(state, agent_child, headers);
    }

    public static void clearAgentTaskOutputState(AgentTaskOutputState state, BaseClass agent_child, JobBiBusHeaders headers) throws Exception {
        state.clear();
        AgentTaskOutputStateService.updateAgentTaskOutputState(state, agent_child, headers);
    }

    public static void updateAgentTaskOutputState(BaseClass[] created, AgentTaskOutputState state, BaseClass agent_child, JobBiBusHeaders headers) throws Exception {
        state.clear();
        for (int i = 0; created != null && i < created.length; ++i) {
            state.addObjectPath(created[i].getSearchPath().getValue());
        }
        AgentTaskOutputStateService.updateAgentTaskOutputState(state, agent_child, headers);
    }

    public static boolean newsItemExists(BaseClass agent_child, JobBiBusHeaders headers) throws Exception {
        AgentTaskOutputState state = AgentTaskOutputStateService.getAgentTaskOutputState(agent_child, headers);
        if (state == null) {
            return false;
        }
        String path = state.getObjectPaths() != null && state.getObjectPaths().length > 0 ? state.getObjectPaths()[0] : null;
        BaseClass[] newsItem = null;
        if (path != null && !"".equals(path)) {
            PropEnum[] props = new PropEnum[]{PropEnum.searchPath};
            newsItem = m_state_builder.getObject(path, props, headers);
        }
        return newsItem != null && newsItem.length > 0;
    }

    private static class OMBuilder
    extends StateBuilder {
        private OMBuilder() {
        }

        public AgentTaskOutputState getState(BaseClass task_target, JobBiBusHeaders headers) throws Exception {
            AsynchOptionStringArray aosa;
            String[] ids;
            Option o;
            BaseRSSTask rssTask;
            OptionArrayProp prop;
            AgentTaskOutputState state = new AgentTaskOutputState();
            String agent_sp = this.getAgentAncestorPath(task_target, headers);
            if (agent_sp == null) {
                return null;
            }
            String agent_child_task_sp = agent_sp + "/agentTaskDefinition[containsReferences(@taskObject, " + task_target.getSearchPath().getValue() + ")]";
            BaseClass[] agent_child_task = this.getObject(agent_child_task_sp, new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName}, headers);
            for (int i = 0; i < agent_child_task.length && i < 1; ++i) {
                if (!(agent_child_task[i] instanceof AgentTaskDefinition)) continue;
                AgentTaskDefinition ats = (AgentTaskDefinition)agent_child_task[i];
                agent_child_task_sp = ats.getSearchPath().getValue();
                state.setDefinition(ats);
            }
            String parent = agent_sp;
            if (task_target instanceof BaseRSSTask && (prop = (rssTask = (BaseRSSTask)task_target).getOptions()) != null && prop.getValue() != null && (o = OptionUtils.findFirstOptionWithNameEnum(prop.getValue(), AsynchOptionEnum.runContext)) != null && o instanceof AsynchOptionStringArray && (ids = (aosa = (AsynchOptionStringArray)o).getValue()) != null && ids.length > 1) {
                parent = ids[ids.length - 2];
                TaskRecord task = TaskPersistLayer.getTaskFromEventId(ids[ids.length - 2]);
                parent = "storeID(\"" + task.getTaskStoreId() + "\")";
            }
            state.setLocator("/transientStateFolder/agentState[containsReferences(@definition, " + parent + ")]");
            String task_state_sp = state.getLocator() + "/agentTaskState[containsReferences(@definition, " + agent_child_task_sp + ")]";
            BaseClass[] objects = this.getObject(task_state_sp, new PropEnum[]{PropEnum.searchPath, PropEnum.definition, PropEnum.related, PropEnum.defaultName}, headers);
            for (int i = 0; i < objects.length && i < 1; ++i) {
                if (!(objects[i] instanceof AgentTaskState)) continue;
                AgentTaskState ats = (AgentTaskState)objects[i];
                BaseClass[] bca = ats.getRelated().getValue();
                for (int j = 0; bca != null && j < bca.length; ++j) {
                    state.addObjectPath(bca[j].getSearchPath().getValue());
                }
                state.setOmState(ats);
            }
            return state;
        }

        private String getAgentAncestorPath(BaseClass base, JobBiBusHeaders headers) {
            if (base.getAncestors() == null) {
                PropEnum[] ancestor_props = new PropEnum[]{PropEnum.ancestors, PropEnum.searchPath};
                try {
                    BaseClass[] bases = m_state_builder.getObject(base.getSearchPath().getValue(), ancestor_props, headers);
                    if (bases != null && bases.length > 0) {
                        base.setAncestors(bases[0].getAncestors());
                        base.setSearchPath(bases[0].getSearchPath());
                    }
                }
                catch (Throwable bases) {
                    // empty catch block
                }
                if (base.getAncestors() == null) {
                    return null;
                }
            }
            AncestorInfo[] elders = base.getAncestors().getValue();
            String agent_sp = "";
            agent_sp = elders[elders.length - 1].getSearchPath();
            return agent_sp;
        }

        public void updateState(AgentTaskOutputState state, BaseClass agent_child, JobBiBusHeaders headers) throws Exception {
            String search = state.getLocator();
            String[] paths = state.getObjectPaths();
            BaseClass[] bcPaths = new BaseClass[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                Object bc = null;
                bc = agent_child instanceof ShortcutRSSTask ? new Shortcut() : new URL();
                StringProp path = new StringProp();
                path.setValue(paths[i]);
                bc.setSearchPath(path);
                bcPaths[i] = bc;
            }
            BaseClassArrayProp bcap = new BaseClassArrayProp();
            bcap.setValue(bcPaths);
            AgentTaskState ats = state.getOmState() instanceof AgentTaskState ? (AgentTaskState)state.getOmState() : new AgentTaskState();
            ats.setRelated(bcap);
            ats.setSearchPath(null);
            BaseClassArrayProp def = new BaseClassArrayProp();
            def.setValue(new BaseClass[]{state.getDefinition()});
            ats.setDefinition(def);
            this.saveObject(search, (BaseClass)ats, headers);
        }
    }

    private static abstract class StateBuilder {
        private StateBuilder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveObject(String path, BaseClass to_save, JobBiBusHeaders headers) throws Exception {
            BiBusHeader header = BiBusUtilities.getDeepCopy(headers.getBiBusHeader());
            String tenantID = AuthenticatorFactory.getInstance().getTenantID(header);
            StringProp tenantProp = new StringProp();
            tenantProp.setValue(tenantID);
            to_save.setTenantID(tenantProp);
            header.setCAM(null);
            ContentManagerServiceClientPort cmsp = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
            cmsp.signNextRequest("ASV");
            AddOptions aop = new AddOptions();
            aop.setUpdateAction(UpdateActionEnum.replace);
            try {
                BaseClass[] the_created = cmsp.add(new SearchPathSingleObject(path), new BaseClass[]{to_save}, aop);
                if (the_created.length != 1) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.AGENT_RUN_ERROR, new Object[0]);
                }
            }
            finally {
                cmsp.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final BaseClass[] getObject(String path, PropEnum[] props, JobBiBusHeaders headers) throws Exception {
            BiBusHeader header = BiBusUtilities.getDeepCopy(headers.getBiBusHeader());
            header.setCAM(null);
            ContentManagerServiceClientPort cmsp = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
            cmsp.signNextRequest("ASV");
            QueryOptions qop = new QueryOptions();
            Sort[] sort = new Sort[]{};
            BaseClass[] the_retrieved = null;
            try {
                the_retrieved = cmsp.query(new SearchPathMultipleObject(path), props, sort, qop);
            }
            finally {
                cmsp.close();
            }
            return the_retrieved;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeObject(BaseClass to_remove, JobBiBusHeaders headers) throws Exception {
            BiBusHeader header = BiBusUtilities.getDeepCopy(headers.getBiBusHeader());
            header.setCAM(null);
            ContentManagerServiceClientPort cmsp = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
            cmsp.signNextRequest("ASV");
            BaseClass[] searchPaths = new BaseClass[]{to_remove};
            DeleteOptions dop = new DeleteOptions();
            dop.setForce(true);
            dop.setRecursive(true);
            try {
                cmsp.delete(searchPaths, dop);
            }
            finally {
                cmsp.close();
            }
        }
    }
}

