/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMException;
import com.cognos.developer.schemas.bibus._3.MonitorOptionEnum;
import com.cognos.developer.schemas.bibus._3.MonitorOptionGUID;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.QueryServiceTask;
import com.cognos.developer.schemas.bibus._3.RoutingInfo;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.serverinst.InstanceUtil;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.IClientBase;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.BiBusSpec;
import com.cognos.jsmcommon.tse.LoadFaultBean;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.tse.run.commands.LogJobCmdSpec;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.UserAccountUtil;
import com.cognos.jsmcommon.util.Validate;

public final class BiBusRunSpec
extends BiBusSpec {
    public static final String QSAT_PATH_SUBSTRING = "/queryServiceTask[";
    public Option[] options;
    public ParameterValue[] parameters;
    public String[] ancestorStoreIDs;
    public String searchPath;
    public String ownerPath;
    public String scheduleType;
    public String scheduleTrigger;
    public String objectClass;
    public String taskStoreID;
    public String tenantID;

    public BiBusRunSpec(BiBusHeader hdr) {
        this.header = hdr;
        this.priority = (byte)3;
    }

    private static void authenticateHeader(BiBusRunSpec spec) throws SDKClientException, EMFSecurityException {
        JobBiBusHeaders jobHdr = new JobBiBusHeaders(spec.header);
        CAM cam = spec.header.getCAM();
        if (cam != null && cam.getAction() != null && cam.getAction().equals("logonAs")) {
            AuthenticatorFactory.getInstance().logon(jobHdr);
            spec.logOff = true;
        } else {
            AuthenticatorFactory.getInstance().authenticate(jobHdr);
        }
        spec.authenticated = true;
        spec.header = jobHdr.getBiBusHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialiseHeaders(TaskID parentID, SequenceSpec[] spec) throws TaskPersistLayerException {
        int queryCount;
        if (spec == null || spec.length == 0) {
            return;
        }
        BiBusRunSpec firstTask = (BiBusRunSpec)spec[0].getTask();
        Account account = null;
        if (firstTask.getAccountPath() == null && account == null) {
            account = new UserAccountUtil(new JobBiBusHeaders(firstTask.header)).getUserAccount();
            Validate.notNull(account);
            Validate.notNull(account.getSearchPath());
        }
        BiBusHeader header = null;
        if (firstTask.header != null) {
            header = firstTask.header;
        } else {
            firstTask.header = header = new BiBusHeader();
        }
        PropEnum[] propsNoOptions = new PropEnum[]{PropEnum.searchPath, PropEnum.routingServerGroup, PropEnum.routingHints, PropEnum.objectClass, PropEnum.storeID, PropEnum.ancestors, PropEnum.owner, PropEnum.tenantID};
        PropEnum[] propsWithOptions = new PropEnum[]{PropEnum.searchPath, PropEnum.routingServerGroup, PropEnum.routingHints, PropEnum.objectClass, PropEnum.options, PropEnum.storeID, PropEnum.ancestors, PropEnum.owner, PropEnum.tenantID};
        boolean propsContainOptions = true;
        IClientBase cmPort = null;
        for (int specPos = 0; specPos != spec.length; specPos += queryCount) {
            queryCount = spec.length - specPos > 400 ? 400 : spec.length - specPos;
            QueryRequest[] requests = new QueryRequest[queryCount];
            for (int j = 0; j != queryCount; ++j) {
                String searchPathSubString;
                BiBusRunSpec task = (BiBusRunSpec)spec[specPos + j].getTask();
                if (task.getAccountPath() == null) {
                    task.setAccountPath(account.getSearchPath().getValue());
                }
                PropEnum[] props = propsWithOptions;
                if (task.searchPath != null && task.searchPath.lastIndexOf("/") > 0 && !(searchPathSubString = task.searchPath.substring(task.searchPath.lastIndexOf("/"))).startsWith(QSAT_PATH_SUBSTRING)) {
                    props = propsNoOptions;
                    propsContainOptions = false;
                }
                requests[j] = new QueryRequest();
                requests[j].setProperties(props);
                if (task.taskStoreID != null) {
                    requests[j].setSearch("storeID(\"" + task.taskStoreID + "\")");
                    continue;
                }
                requests[j].setSearch(task.searchPath);
            }
            QueryReply[] reply = null;
            Exception exception = null;
            try {
                if (!firstTask.authenticated) {
                    BiBusRunSpec.authenticateHeader(firstTask);
                }
                JobBiBusHeaders jobheader = new JobBiBusHeaders(firstTask.header);
                cmPort = Client.instance().getContentManagerServiceClient(jobheader);
                cmPort.signNextRequest("JSM");
                reply = cmPort.queryMultiple(requests);
            }
            catch (SDKClientException e) {
                if (parentID != null) {
                    TaskPersistLayer.throwException(exception);
                }
                exception = e;
            }
            catch (EMFSecurityException e) {
                if (parentID != null) {
                    TaskPersistLayer.throwException(exception);
                }
                exception = e;
            }
            finally {
                if (cmPort != null) {
                    cmPort.close();
                }
            }
            LoadFaultBean faultBean = null;
            if (exception != null) {
                CAMException camException = header.getCAM().getException();
                header.setCAM(null);
                try {
                    JobBiBusHeaders jobheader = new JobBiBusHeaders(header);
                    cmPort = Client.instance().getContentManagerServiceClient(jobheader);
                    cmPort.signNextRequest("JSM");
                    reply = cmPort.queryMultiple(requests);
                    faultBean = camException != null ? BiBusRunSpec.createLoadFaultBean(camException) : BiBusRunSpec.createLoadFaultBean(exception);
                }
                catch (SDKClientException e) {
                    TaskPersistLayer.throwException(exception);
                }
                catch (EMFSecurityException e) {
                    TaskPersistLayer.throwException(exception);
                }
                finally {
                    cmPort.close();
                }
            }
            if (reply.length != queryCount) {
                throw new TaskPersistLayerException(I18NCode.OTH_CM_ERROR);
            }
            for (int j = 0; j != reply.length; ++j) {
                BaseClassArrayProp baseClassArrayProp;
                BaseClass[] baseClassArray;
                BaseClass[] classes = reply[j].getQueryResult();
                if (classes == null || classes.length < 1 || classes[0].getSearchPath().getValue() == null) {
                    throw new TaskPersistLayerException(I18NCode.OTH_CM_ERROR);
                }
                BaseClass baseClass = classes[0];
                BiBusRunSpec task = (BiBusRunSpec)spec[specPos + j].getTask();
                task.objectClass = baseClass.getObjectClass().getValue().getValue();
                task.searchPath = baseClass.getSearchPath().getValue();
                task.taskStoreID = baseClass.getStoreID().getValue().get_value();
                try {
                    BiBusUtilities.setRoutingServerGroup(baseClass, task.header);
                }
                catch (SDSServiceException e) {
                    TaskPersistLayer.throwException(e);
                }
                if (baseClass instanceof QueryServiceTask) {
                    Option dispatcherIdOption;
                    QueryServiceTask qst;
                    Option[] qstOptions = null;
                    qstOptions = propsContainOptions ? ((qst = (QueryServiceTask)baseClass).getOptions() != null ? qst.getOptions().getValue() : null) : BiBusRunSpec.getQueryServiceTaskOptions(baseClass.getSearchPath().getValue(), firstTask.header);
                    if (qstOptions != null && (dispatcherIdOption = OptionUtils.findFirstOptionWithNameEnum(qstOptions, MonitorOptionEnum.dispatcherID)) != null) {
                        task.options = OptionUtils.mergeOptions(new Option[]{dispatcherIdOption}, task.options);
                    }
                }
                task.serviceName = Client.instance().getServiceName(baseClass);
                if (task.serviceName != null) {
                    JobBiBusHeaders jobheader;
                    Option taskOption = OptionUtils.findFirstOptionWithNameEnum(task.options, MonitorOptionEnum.dispatcherID);
                    String targetDispatcherID = null;
                    int isServiceAvailable = 0;
                    if (taskOption != null && taskOption instanceof MonitorOptionGUID && "dispatcherID".equals(((MonitorOptionGUID)taskOption).getName().getValue()) && (targetDispatcherID = ((MonitorOptionGUID)taskOption).getValue().get_value()) != null && !"".equals(targetDispatcherID.trim()) && (isServiceAvailable = InstanceUtil.isServiceRunningOnDispatcher(jobheader = new JobBiBusHeaders(header), targetDispatcherID, task.serviceName)) != 0) {
                        String msg;
                        task.serviceName = "taskLoadFailed";
                        String baseClassName = null;
                        if (baseClass != null && baseClass.getObjectClass() != null) {
                            baseClassName = baseClass.getObjectClass().getValue().getValue();
                        }
                        if (isServiceAvailable == 1) {
                            task.loadFault = BiBusRunSpec.createLoadFaultBean(I18NCode.MSG_TARGET_DISPATCHER_UNAVAILABLE, new Object[]{targetDispatcherID});
                            msg = "The target dispatcher with id: " + targetDispatcherID + " was not available for task step with id " + task.eventID;
                            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(task, msg);
                        } else {
                            task.loadFault = BiBusRunSpec.createLoadFaultBean(I18NCode.MSG_SERVICE_UNAVAILABLE_ON_TARGET_DISPATCHER, new Object[]{baseClassName, targetDispatcherID});
                            msg = "Task step id " + task.eventID + " - The service associated with object type: " + baseClassName + " is not available / running on the target dispatcher with id: " + targetDispatcherID;
                            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(task, msg);
                        }
                        task.options = OptionUtils.removeOptionsWithNameEnum(task.options, MonitorOptionEnum.dispatcherID);
                    }
                }
                if (faultBean != null) {
                    task.loadFault = faultBean;
                    task.serviceName = "taskLoadFailed";
                    task.options = OptionUtils.removeOptionsWithNameEnum(task.options, MonitorOptionEnum.dispatcherID);
                } else if (task.serviceName == null) {
                    task.serviceName = "taskLoadFailed";
                    String baseClassName = null;
                    if (baseClass != null && baseClass.getObjectClass() != null) {
                        baseClassName = baseClass.getObjectClass().getValue().getValue();
                    }
                    task.loadFault = BiBusRunSpec.createLoadFaultBean(I18NCode.MSG_SERVICE_MAPPING_ERROR, new Object[]{baseClassName});
                    String msg = "The task step with id " + task.eventID + " does not have a valid service name. It may have been removed.";
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(task, msg);
                    task.options = OptionUtils.removeOptionsWithNameEnum(task.options, MonitorOptionEnum.dispatcherID);
                } else if (task.serviceName.equals("jobService")) {
                    task.runCommands = new CmdSpec[]{new LogJobCmdSpec()};
                }
                RoutingInfo ri = task.header.getRouting();
                if (ri != null && ri.getRoutingServerGroup() != null) {
                    task.serverGroup = ri.getRoutingServerGroup();
                }
                AncestorInfo[] ancestorInfo = baseClass.getAncestors().getValue();
                task.ancestorStoreIDs = new String[ancestorInfo.length];
                for (int i = 0; i < ancestorInfo.length; ++i) {
                    task.ancestorStoreIDs[i] = ancestorInfo[i].getStoreID().get_value();
                }
                if (baseClass.getOwner() != null && (baseClassArray = (baseClassArrayProp = baseClass.getOwner()).getValue()) != null && baseClassArray.length > 0) {
                    task.ownerPath = baseClassArray[0].getStoreID().getValue().get_value();
                }
                if (baseClass.getTenantID() == null) continue;
                task.tenantID = baseClass.getTenantID().getValue();
                if (task.tenantID != null && !task.tenantID.equals("") || account == null || account.getTenantID() == null) continue;
                task.tenantID = account.getTenantID().getValue();
            }
        }
    }

    static LoadFaultBean createLoadFaultBean(I18NCode code, Object[] params) {
        LoadFaultBean faultBean = new LoadFaultBean();
        faultBean.setFaultyLoadErrorCode(code);
        faultBean.setFaultyLoadErrorParams(params);
        return faultBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Option[] getQueryServiceTaskOptions(String searchPath, BiBusHeader header) throws TaskPersistLayerException {
        IClientBase cmPort = null;
        try {
            QueryServiceTask qst;
            JobBiBusHeaders jobheader = new JobBiBusHeaders(header);
            cmPort = Client.instance().getContentManagerServiceClient(jobheader);
            cmPort.signNextRequest("JSM");
            BaseClass[] classes = cmPort.query(new SearchPathMultipleObject(searchPath), new PropEnum[]{PropEnum.options}, new Sort[0], new QueryOptions());
            if (classes != null && classes.length > 0 && (qst = (QueryServiceTask)classes[0]).getOptions() != null) {
                Option[] optionArray = qst.getOptions().getValue();
                return optionArray;
            }
        }
        catch (SDKClientException e) {
            TaskPersistLayer.throwException(e);
        }
        catch (EMFSecurityException e) {
            TaskPersistLayer.throwException(e);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return null;
    }
}

