/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAMException;
import com.cognos.developer.schemas.bibus._3.Message;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.soap.client.Attachment;
import com.cognos.jsmcommon.tse.BiBusRequestSpec;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.LoadFaultBean;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import java.util.ArrayList;
import java.util.List;

public class BiBusSpec
extends TaskRunSpec {
    public BiBusHeader header;
    public boolean authenticated;
    private String credentialPath;
    private String accountPath;
    public boolean logOff;
    public byte priority;
    public Attachment[] attachments;
    private boolean isDefaultSchedulePriorityEnforced = false;
    private static final String CREDENTIAL = "/credential";

    public boolean isDefaultSchedulePriorityEnforced() {
        return this.isDefaultSchedulePriorityEnforced;
    }

    public void setDefaultSchedulePriorityEnforced(boolean isDefaultSchedulePriorityEnforced) {
        this.isDefaultSchedulePriorityEnforced = isDefaultSchedulePriorityEnforced;
    }

    public static void initialiseHeaders(SequenceSpec[] spec) throws TaskPersistLayerException {
        BiBusSpec.initialiseHeaders(null, spec);
    }

    public static void initialiseHeaders(TaskID parentID, SequenceSpec[] spec) throws TaskPersistLayerException {
        if (spec == null || spec.length == 0) {
            return;
        }
        ArrayList<SequenceSpec> specsWithChildren = new ArrayList<SequenceSpec>();
        BiBusSpec.addSequenceSpecs(spec, specsWithChildren);
        spec = specsWithChildren.toArray(new SequenceSpec[specsWithChildren.size()]);
        ArrayList<SequenceSpec> biBusRunSpecs = new ArrayList<SequenceSpec>();
        ArrayList<SequenceSpec> biBusRequestSpecs = new ArrayList<SequenceSpec>();
        for (int i = 0; i < spec.length; ++i) {
            if (spec[i].getTask() instanceof BiBusRunSpec) {
                biBusRunSpecs.add(spec[i]);
                continue;
            }
            if (!(spec[i].getTask() instanceof BiBusRequestSpec)) continue;
            biBusRequestSpecs.add(spec[i]);
        }
        BiBusRequestSpec.initialiseHeaders(parentID, biBusRequestSpecs.toArray(new SequenceSpec[0]));
        BiBusRunSpec.initialiseHeaders(parentID, biBusRunSpecs.toArray(new SequenceSpec[0]));
    }

    protected static LoadFaultBean createLoadFaultBean(CAMException camException) {
        StringBuffer errorMsg = new StringBuffer();
        Message[] messages = camException.getMessages();
        if (messages != null && messages.length > 0) {
            for (int i = 0; i < messages.length; ++i) {
                errorMsg.append(messages[i].getMessageString());
                if (i >= messages.length - 1) continue;
                errorMsg.append(" ");
            }
        } else {
            errorMsg.append(camException.getErrorCode());
            errorMsg.append(" ");
            errorMsg.append(camException.getErrorCodeString());
        }
        LoadFaultBean faultBean = new LoadFaultBean();
        faultBean.setFaultyLoadErrorCode(I18NCode.GEN_3RD_PARTY_FAULT);
        faultBean.setFaultyLoadErrorParams(new Object[]{errorMsg.toString()});
        return faultBean;
    }

    protected static LoadFaultBean createLoadFaultBean(Exception exception) {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(exception.getLocalizedMessage());
        Throwable ex = exception;
        while (ex.getCause() != null) {
            ex = ex.getCause();
            errorMsg.append(" ");
            errorMsg.append(ex.getLocalizedMessage());
        }
        LoadFaultBean faultBean = new LoadFaultBean();
        faultBean.setFaultyLoadErrorCode(I18NCode.GEN_3RD_PARTY_FAULT);
        faultBean.setFaultyLoadErrorParams(new Object[]{errorMsg.toString()});
        return faultBean;
    }

    private static void addSequenceSpecs(SequenceSpec[] specs, List<SequenceSpec> allSpecs) {
        for (int i = 0; i < specs.length; ++i) {
            if (!(specs[i].getTask() instanceof BiBusSpec)) continue;
            allSpecs.add(specs[i]);
            List<SequenceSpec> children = specs[i].getChildren();
            if (children == null || children.size() <= 0) continue;
            BiBusSpec.addSequenceSpecs(children.toArray(new SequenceSpec[children.size()]), allSpecs);
        }
    }

    public void setAccountPath(String accountPath) {
        if (accountPath != null) {
            if (accountPath.indexOf(CREDENTIAL) != -1) {
                this.setCredentialPath(accountPath);
            } else {
                this.accountPath = accountPath;
                this.credentialPath = accountPath + CREDENTIAL;
            }
        }
    }

    public void setCredentialPath(String credentialPath) {
        if (credentialPath != null) {
            int credentialIndex = credentialPath.indexOf(CREDENTIAL);
            if (credentialIndex != -1) {
                this.accountPath = credentialPath.substring(0, credentialIndex);
                this.credentialPath = credentialPath;
            } else {
                this.setAccountPath(credentialPath);
            }
        }
    }

    public String getAccountPath() {
        return this.accountPath;
    }

    public String getCredentialPath() {
        return this.credentialPath;
    }
}

