/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.tse.NCTSEStateMapTable;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class BulkTaskRecords {
    protected HashMap<TaskID, TaskPersistLayer.TaskRecords> m_pending = new HashMap();
    protected ArrayList<TaskPersistLayer.TaskRecords> m_written = new ArrayList();

    public void add(TaskPersistLayer.TaskRecords trs) {
        assert (null != trs.taskRecord);
        assert (null != trs.taskStateRecord);
        assert (trs.taskRecord.getTaskId().equals(trs.taskStateRecord.taskID));
        assert (!this.m_pending.containsKey(trs.taskRecord.getTaskId()));
        assert (!this.m_written.contains(trs));
        this.m_pending.put(trs.taskRecord.getTaskId(), trs);
    }

    public void flush() throws TaskPersistLayerException {
        ArrayList<TaskRecord> taskQueueRecords = new ArrayList<TaskRecord>(this.m_pending.size());
        ArrayList<TaskStateRecord> taskStateRecords = new ArrayList<TaskStateRecord>(this.m_pending.size());
        for (TaskPersistLayer.TaskRecords r : this.m_pending.values()) {
            taskQueueRecords.add(r.taskRecord);
            taskStateRecords.add(r.taskStateRecord);
            this.m_written.add(r);
        }
        this.insertInNCTaskQueueTable(taskQueueRecords);
        this.insertInNCTSEStateMapTable(taskStateRecords);
        this.m_pending.clear();
    }

    public boolean isPending(TaskID taskId) {
        assert (null != taskId);
        return this.m_pending.containsKey(taskId);
    }

    public TaskPersistLayer.TaskRecords[] getWritten() {
        return this.m_written.toArray(new TaskPersistLayer.TaskRecords[this.m_written.size()]);
    }

    protected void insertInNCTaskQueueTable(Collection<TaskRecord> taskQueueRecords) throws TaskPersistLayerException {
        NCTaskQueueTable.getInstance().insertRecords(taskQueueRecords, true);
    }

    protected void insertInNCTSEStateMapTable(Collection<TaskStateRecord> taskStateRecords) throws TaskPersistLayerException {
        NCTSEStateMapTable.getInstance().insertRecords(taskStateRecords, true);
    }
}

