/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.LocaleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class HistoryTopicsEnum {
    private static ArrayList m_enums = new ArrayList();
    private static final String ESCAPED_TOPIC_START = "\\[";
    private static final String ESCAPED_TOPIC_END = "\\]";
    private static final String TOPIC_START = "[";
    private static final String TOPIC_END = "]";
    public static final HistoryTopicsEnum REQUEST_TIME = new HistoryTopicsEnum("HISTORY_TOPIC_REQUEST_TIME", "xs:dateTime");
    public static final HistoryTopicsEnum START_TIME = new HistoryTopicsEnum("HISTORY_TOPIC_START_TIME", "xs:dateTime");
    public static final HistoryTopicsEnum RAN_BY = new HistoryTopicsEnum("HISTORY_TOPIC_RAN_BY", "xs:string");
    public static final HistoryTopicsEnum STATUS = new HistoryTopicsEnum("HISTORY_TOPIC_STATUS", "xs:string");
    public static final HistoryTopicsEnum DISPATCHER = new HistoryTopicsEnum("HISTORY_TOPIC_DISPATCHER", "xs:string");
    public static final HistoryTopicsEnum MESSAGES = new HistoryTopicsEnum("HISTORY_TOPIC_MESSAGES", "xs:string");
    private String m_topicId;
    private String m_type;
    private Map m_localisedMap = new HashMap();

    private HistoryTopicsEnum(String topic, String type) {
        this.m_topicId = topic;
        this.m_type = type;
        m_enums.add(this);
    }

    public String getType() {
        return this.m_type;
    }

    public String getTopic(Locale locale) {
        return TOPIC_START + this.getTranslatedTopic(locale) + TOPIC_END;
    }

    public String getTopicName(Locale locale) {
        return this.getTranslatedTopic(locale);
    }

    public void setTranslatedTopic(Locale locale, String topic) {
        this.m_localisedMap.put(locale, topic);
    }

    public String getTopicId() {
        return this.m_topicId;
    }

    public String toString() {
        return this.m_topicId;
    }

    public String getEscapedTopic(Locale locale) {
        return ESCAPED_TOPIC_START + this.getTranslatedTopic(locale) + ESCAPED_TOPIC_END;
    }

    public boolean isEqualTo(HistoryTopicsEnum historyType) {
        return this.m_type.equals(historyType.m_type) && this.m_topicId.equals(historyType.m_topicId);
    }

    public static List getTopics() {
        return m_enums;
    }

    public static HistoryTopicsEnum getTypeEnum(String topic_string, Locale locale) {
        HistoryTopicsEnum ret_value = null;
        for (int i = 0; i < m_enums.size() && ret_value == null; ++i) {
            HistoryTopicsEnum xenum = (HistoryTopicsEnum)m_enums.get(i);
            if (!xenum.getTopic(locale).equals(topic_string) && !xenum.getTopicName(locale).equals(topic_string)) continue;
            ret_value = xenum;
        }
        return ret_value;
    }

    public static String translateTopic(HistoryTopicsEnum topic, Locale locale) {
        String result = topic.getTranslatedTopic(locale);
        return result;
    }

    public String getTranslatedTopic(Locale locale) {
        String result = "";
        if (this.m_localisedMap.containsKey(locale)) {
            result = (String)this.m_localisedMap.get(locale);
        } else {
            Locale newLocale = LocaleUtil.createContentLocale(locale.toString());
            ResourceBundle sys_bundle = I18NUtil.getResourceBundle("ncmsg", newLocale);
            result = sys_bundle.getString(this.getTopicId());
            this.setTranslatedTopic(locale, result);
        }
        return result;
    }

    public boolean equals(Object historyType) {
        boolean ret_value = false;
        if (historyType instanceof HistoryTopicsEnum) {
            ret_value = this.isEqualTo((HistoryTopicsEnum)historyType);
        }
        return ret_value;
    }

    public int hashCode() {
        return this.m_topicId.hashCode();
    }
}

