/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.sql.util.BatchPreparedStatement;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandler;
import com.cognos.jsmcommon.tse.NCTSEStateMapTable;
import com.cognos.jsmcommon.tse.SQLObject;
import com.cognos.jsmcommon.tse.SqlUpdateVerb;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStateTable;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.tse.TaskTable;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class NCTSEStateMapTableInDatabase
extends NCTSEStateMapTable {
    public static final String SQL_FIELD_LIST = "SEQ,PARENT_ID,STATUS,STEP_COUNT,CUR_SEQ,COUNT_SEQ,STOP_ON_ERROR,TASK_ID,FAIL_STATUS,RUN_VIA_MS,STEP_FAILED,SEQ_ON_END,WRITE_ALL_HISTORIES,EXECUTING";
    public static final String SQL_SET_FIELD = "UPDATE NC_TSE_STATE_MAP SET $$=? WHERE TASK_ID=?";
    public static final String SQL_INC_FIELD = "UPDATE NC_TSE_STATE_MAP SET $$=$$+? WHERE TASK_ID=?";
    public static final String SQL_INC_COUNT_SEQ = "UPDATE NC_TSE_STATE_MAP SET COUNT_SEQ=COUNT_SEQ+? WHERE TASK_ID=?";
    public static final String SQL_DEC_FIELD = "UPDATE NC_TSE_STATE_MAP SET $$=$$-? WHERE TASK_ID=?";
    public static final String SQL_DEC_COUNT = "UPDATE NC_TSE_STATE_MAP SET STEP_COUNT=STEP_COUNT-1 WHERE TASK_ID=? AND STEP_COUNT>1";
    public static final String SQL_SET_COUNT_ZERO = "UPDATE NC_TSE_STATE_MAP SET STEP_COUNT=0 WHERE TASK_ID=? AND STEP_COUNT=1";
    public static final String SQL_FIND_TASK = "SELECT SEQ,PARENT_ID,STATUS,STEP_COUNT,CUR_SEQ,COUNT_SEQ,STOP_ON_ERROR,TASK_ID,FAIL_STATUS,RUN_VIA_MS,STEP_FAILED,SEQ_ON_END,WRITE_ALL_HISTORIES,EXECUTING,MODCOUNT FROM NC_TSE_STATE_MAP WHERE TASK_ID=?";
    public static final String SQL_CREATE = "INSERT INTO NC_TSE_STATE_MAP (SEQ,PARENT_ID,STATUS,STEP_COUNT,CUR_SEQ,COUNT_SEQ,STOP_ON_ERROR,TASK_ID,FAIL_STATUS,RUN_VIA_MS,STEP_FAILED,SEQ_ON_END,WRITE_ALL_HISTORIES,EXECUTING) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    public static final String SQL_GET_NEXT_STEPS = "SELECT TASK_ID FROM NC_TSE_STATE_MAP WHERE PARENT_ID=? AND SEQ=? AND STATUS=?";
    public static final String SQL_GET_ALL_NEXT_STEPS = "SELECT TASK_ID FROM NC_TSE_STATE_MAP WHERE PARENT_ID=? AND SEQ>=? AND STATUS <=?";
    public static final String SQL_NEXT_STEP = "UPDATE NC_TSE_STATE_MAP SET CUR_SEQ=?, STEP_COUNT=STEP_COUNT+? WHERE TASK_ID=?";
    public static final String SQL_RUN_VIA_MS = "UPDATE NC_TSE_STATE_MAP SET CUR_SEQ=1,COUNT_SEQ=1,STEP_COUNT=STEP_COUNT+1 WHERE TASK_ID=?";
    public static final String SQL_CHILD_SEQ_STATUS = "UPDATE NC_TSE_STATE_MAP SET STATUS=? WHERE PARENT_ID=? AND SEQ=? AND STATUS in (?,?)";
    public static final String SQL_UPDATE_FIELD = "UPDATE NC_TSE_STATE_MAP SET $$=? WHERE TASK_ID=? AND $$=?";
    public static final String SQL_UPDATE_FIELD_CHECK_MODCOUNT = "UPDATE NC_TSE_STATE_MAP SET $$=?, MODCOUNT=MODCOUNT+1 WHERE TASK_ID=? AND $$=? AND MODCOUNT=?";
    public static final String SQL_UPDATE_STEP_FAILED = "UPDATE NC_TSE_STATE_MAP SET $$=? WHERE TASK_ID=? AND $$<?";
    public static final String SQL_COUNT_SIBLINGS_BY_STATUS = "SELECT COUNT(*) FROM NC_TSE_STATE_MAP WHERE PARENT_ID=? AND STATUS=?";
    public static final String SQL_RESTART_RESET = "UPDATE NC_TSE_STATE_MAP SET STATUS=?, STEP_COUNT=?, COUNT_SEQ = ?, CUR_SEQ=?, STEP_FAILED=0, FAIL_STATUS=0, RUN_VIA_MS=0, EXECUTING=0 WHERE TASK_ID=?";
    static final String SQL_GET_FIELD = "SELECT $$ FROM NC_TSE_STATE_MAP WHERE TASK_ID=?";
    static final String SQL_SELECT_TASKIDS = "SELECT TASK_ID FROM NC_TSE_STATE_MAP";
    static final String STEP_INFO_FIELDS = "TASK_ID, STEP_COUNT, CUR_SEQ, COUNT_SEQ, SEQ, STATUS, RUN_VIA_MS";
    static final String SQL_GET_CHILDREN = "SELECT TASK_ID, STEP_COUNT, CUR_SEQ, COUNT_SEQ, SEQ, STATUS, RUN_VIA_MS FROM NC_TSE_STATE_MAP WHERE PARENT_ID=?";
    static final String SQL_GET_CHILD_TASK_IDS = "SELECT TASK_ID FROM NC_TSE_STATE_MAP WHERE PARENT_ID=?";
    static final String SQL_GET_COMPLETED_TASKS = "SELECT TASK_ID, STEP_COUNT, CUR_SEQ, COUNT_SEQ, SEQ, STATUS, RUN_VIA_MS FROM NC_TSE_STATE_MAP WHERE PARENT_ID=? AND " + TaskStatus.getSqlFilterForPurgable();
    static final String SQL_GET_STATUS_CHILDREN = "SELECT TASK_ID, STEP_COUNT, CUR_SEQ, COUNT_SEQ, SEQ, STATUS, RUN_VIA_MS FROM NC_TSE_STATE_MAP WHERE PARENT_ID=? AND STATUS <= ?";
    static final String SQL_GET_STATUS_SEQ_CHILDREN = "SELECT TASK_ID, STEP_COUNT, CUR_SEQ, COUNT_SEQ, SEQ, STATUS, RUN_VIA_MS FROM NC_TSE_STATE_MAP WHERE PARENT_ID=? AND STATUS <= ? AND SEQ = ?";
    static final String SQL_GET_COMPLETED_TASKS_NULL = "SELECT TASK_ID, STEP_COUNT, CUR_SEQ, COUNT_SEQ, SEQ, STATUS, RUN_VIA_MS FROM NC_TSE_STATE_MAP WHERE PARENT_ID IS NULL AND " + TaskStatus.getSqlFilterForPurgable();
    static final String SQL_CLEAR_PARENT_ID = "UPDATE NC_TSE_STATE_MAP SET PARENT_ID=null, STATUS=? WHERE PARENT_ID=?";
    static final String SQL_CLEAR_PARENT_ID_COMPLETED = "UPDATE NC_TSE_STATE_MAP SET PARENT_ID=null, STATUS=? WHERE PARENT_ID=? AND " + TaskStatus.getSqlFilterForPurgable();
    static final String SQL_DELETE_TASK = "DELETE FROM NC_TSE_STATE_MAP WHERE TASK_ID=?";
    private static final String SQL_COUNT_CHILDREN_BY_STATE = "SELECT COUNT(*) FROM NC_TSE_STATE_MAP WHERE STATUS=? AND PARENT_ID=?";
    private static final String SQL_COUNT_CHILDREN_BY_2_STATES = "SELECT COUNT(*) FROM NC_TSE_STATE_MAP WHERE (STATUS=? OR STATUS=?) AND PARENT_ID=?";
    private static final String SQL_COUNT_CHILDREN = "SELECT COUNT(TASK_ID) FROM NC_TSE_STATE_MAP WHERE PARENT_ID=?";
    static final String SQL_GET_RUNNING_TASKS = "SELECT NC_TSE_STATE_MAP.TASK_ID, STEP_COUNT, CUR_SEQ, COUNT_SEQ, SEQ, NC_TSE_STATE_MAP.STATUS, RUN_VIA_MS, NC_TSE_STATE_MAP.PARENT_ID  FROM NC_TSE_STATE_MAP, NC_TASK_QUEUE WHERE NC_TASK_QUEUE.SDS_INSTANCE_ID = ? AND NC_TASK_QUEUE.TASK_ID = NC_TSE_STATE_MAP.TASK_ID";
    static final String SQL_GET_TASK_TREE = "SELECT NC_TSE_STATE_MAP.TASK_ID, STEP_COUNT, CUR_SEQ, COUNT_SEQ, SEQ, NC_TSE_STATE_MAP.STATUS, RUN_VIA_MS, NC_TSE_STATE_MAP.PARENT_ID  FROM NC_TSE_STATE_MAP WHERE NC_TSE_STATE_MAP.ROOT_TASK_ID = ?";
    static final String SQL_GET_INACTIVE_TASKS = "SELECT NC_TSE_STATE_MAP.TASK_ID, STEP_COUNT, CUR_SEQ, COUNT_SEQ, SEQ, NC_TSE_STATE_MAP.STATUS, RUN_VIA_MS, NC_TSE_STATE_MAP.PARENT_ID  FROM NC_TSE_STATE_MAP, NC_TASK_QUEUE WHERE NC_TASK_QUEUE.SDS_INSTANCE_ID = ? AND NC_TASK_QUEUE.TASK_ID = NC_TSE_STATE_MAP.TASK_ID AND NC_TSE_STATE_MAP.STATUS=15 AND NC_TSE_STATE_MAP.PARENT_ID IS NULL";
    private static final String SDS_SELECT_COMPLETE_STORE_INFO = "SELECT NC_TASK_QUEUE.TASK_ID, HISTORY_STORE_ID, RESTART_ID, NC_TASK_QUEUE.ACTUAL_EXECUTION_TIME FROM NC_TASK_QUEUE, NC_TSE_STATE_MAP WHERE NC_TSE_STATE_MAP.PARENT_ID = ? AND NC_TASK_QUEUE.TASK_ID = NC_TSE_STATE_MAP.TASK_ID AND NC_TSE_STATE_MAP.STATUS>=22 AND NC_TSE_STATE_MAP.STATUS<=29";
    private static final String SDS_SELECT_COMPLETE_STORE_INFO_NULL = "SELECT NC_TASK_QUEUE.TASK_ID, HISTORY_STORE_ID, RESTART_ID, NC_TASK_QUEUE.ACTUAL_EXECUTION_TIME FROM NC_TASK_QUEUE, NC_TSE_STATE_MAP WHERE NC_TSE_STATE_MAP.PARENT_ID IS NULL AND NC_TASK_QUEUE.TASK_ID = NC_TSE_STATE_MAP.TASK_ID AND NC_TSE_STATE_MAP.STATUS>=22 AND NC_TSE_STATE_MAP.STATUS<=29";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(TaskID taskId, TaskStatus status) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.setStatus");
        try {
            SQLObject[] values = new SQLObject[]{status.getSqlValue(), taskId.getSqlValue()};
            TaskPersistLayer.getInstance().execute(SQL_SET_FIELD, "STATUS", values);
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStepFailedAbort(TaskID taskID) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.setStepFailedAbort");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject((byte)1, 4), taskID.getSqlValue()};
            TaskPersistLayer.getInstance().execute(SQL_SET_FIELD, "STEP_FAILED", values);
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setCancel(TaskID taskID) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.setCancel");
        try {
            SQLObject[] values = new SQLObject[]{TaskStatus.CANCELLED.getSqlValue(), taskID.getSqlValue()};
            String sql = SQL_SET_FIELD;
            sql = sql + " AND (STATUS=";
            sql = sql + TaskStatus.PENDING.getId();
            sql = sql + " OR STATUS=";
            sql = sql + TaskStatus.READY.getId();
            sql = sql + ")";
            int n = TaskPersistLayer.getInstance().execute(sql, "STATUS", values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeqOnEnd(TaskID taskID, boolean hasSeq) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.setSeqOnEnd");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject(hasSeq), taskID.getSqlValue()};
            TaskPersistLayer.getInstance().execute(SQL_SET_FIELD, "SEQ_ON_END", values);
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateExecutingCount(int value, TaskID parentID) throws TaskPersistLayerException {
        PreparedStatement ps = null;
        int result = 0;
        if (parentID != null) {
            ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.updateExecutingCount");
            try {
                String updateStatement = "";
                switch (value) {
                    case 0: {
                        updateStatement = SQL_SET_FIELD;
                        break;
                    }
                    case 1: {
                        updateStatement = SQL_INC_FIELD;
                        break;
                    }
                    case -1: {
                        updateStatement = SQL_DEC_FIELD;
                        value = 1;
                    }
                }
                SQLObject value1 = new SQLObject(value, 4);
                SQLObject value2 = parentID.getSqlValue();
                SQLObject[] items = new SQLObject[]{value1, value2};
                if (updateStatement.length() > 0) {
                    result = TaskPersistLayer.getInstance().execute(updateStatement, "EXECUTING", items);
                }
            }
            finally {
                TaskPersistLayer.closeStatement(ps);
                zipiTimer.stop();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incCountSeq(TaskID taskID, int n) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.incCountSeq");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject(n), taskID.getSqlValue()};
            TaskPersistLayer.getInstance().execute(SQL_INC_FIELD, "COUNT_SEQ", values);
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incStepCount(TaskID taskID, int n) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.incStepCount");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject(n), taskID.getSqlValue()};
            TaskPersistLayer.getInstance().execute(SQL_INC_FIELD, "STEP_COUNT", values);
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean decStepCount(TaskID taskID) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.decStepCount");
        try {
            SQLObject[] values = new SQLObject[]{taskID.getSqlValue()};
            if (TaskPersistLayer.getInstance().execute(SQL_DEC_COUNT, null, values) != 0) {
                boolean bl = false;
                return bl;
            }
            if (TaskPersistLayer.getInstance().execute(SQL_SET_COUNT_ZERO, null, values) != 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean find(final TaskStateRecord record, final TaskID taskID) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                Boolean bl;
                ResultSet rs;
                PreparedStatement ps;
                block5: {
                    ps = null;
                    rs = null;
                    ps = TaskPersistLayer.prepareStatement(NCTSEStateMapTableInDatabase.SQL_FIND_TASK);
                    ps.setString(1, taskID.toString());
                    rs = ps.executeQuery();
                    if (!rs.next()) break block5;
                    NCTSEStateMapTableInDatabase.this.readRow(record, rs);
                    Boolean bl2 = true;
                    TaskPersistLayer.closeStatement(ps, rs);
                    return bl2;
                }
                try {
                    bl = false;
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return bl;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.find");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            boolean bl = (Boolean)handler.execute(sqlExecute);
            return bl;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public TaskStateRecord find(TaskID taskId) throws TaskPersistLayerException {
        TaskStateRecord tsr = new TaskStateRecord();
        boolean found = this.find(tsr, taskId);
        if (!found) {
            return null;
        }
        return tsr;
    }

    void readRow(TaskStateRecord record, ResultSet rs) throws TaskPersistLayerException {
        try {
            record.seq = rs.getShort(1);
            record.parentID = rs.getString(2) == null ? null : new TaskID(rs.getString(2));
            record.status = TaskStatus.fromId(rs.getByte(3));
            record.count = rs.getShort(4);
            record.curSeq = rs.getShort(5);
            record.countSeq = rs.getShort(6);
            record.stopOnError = rs.getBoolean(7);
            record.taskID = new TaskID(rs.getString(8));
            record.failStatus = TaskStatus.fromId(rs.getByte(9));
            record.runViaMS = rs.getBoolean(10);
            record.stepFailed = rs.getByte(11);
            record.seqOnEnd = rs.getBoolean(12);
            record.writeAllHistories = rs.getBoolean(13);
            record.executing = rs.getShort(14);
            record.modCount = rs.getInt(15);
        }
        catch (SQLException e) {
            throw new TaskPersistLayerException(e);
        }
    }

    @Override
    public void insert(TaskStateRecord record) throws TaskPersistLayerException {
        ArrayList<TaskStateRecord> recs = new ArrayList<TaskStateRecord>();
        recs.add(record);
        this.insertRecords(recs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRecords(final Collection<TaskStateRecord> records, final boolean batch) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                int batchCount = 0;
                int batchMax = 250;
                try {
                    ps = TaskPersistLayer.prepareStatement(NCTSEStateMapTableInDatabase.SQL_CREATE);
                    for (TaskStateRecord record : records) {
                        NCTSEStateMapTableInDatabase.this.create(record, ps, batch);
                        if (!batch || ++batchCount != batchMax) continue;
                        ps.executeBatch();
                        batchCount = 0;
                    }
                    if (batch && batchCount > 0) {
                        ps.executeBatch();
                    }
                }
                catch (SQLException e) {
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps);
                }
                return null;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.insertRecords");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
            handler.execute(sqlExecute);
        }
        finally {
            zipiTimer.stop();
        }
    }

    protected void create(TaskStateRecord record, PreparedStatement ps, boolean batch) throws SQLException {
        if (record.taskID == null) {
            record.taskID = TaskID.create();
        }
        ps.setShort(1, record.seq);
        ps.setString(2, record.parentID == null ? null : record.parentID.toString());
        ps.setByte(3, record.status.getId());
        ps.setShort(4, record.count);
        ps.setShort(5, record.curSeq);
        ps.setShort(6, record.countSeq);
        ps.setBoolean(7, record.stopOnError);
        ps.setString(8, record.taskID.toString());
        ps.setByte(9, record.failStatus.getId());
        ps.setBoolean(10, record.runViaMS);
        ps.setByte(11, record.stepFailed);
        ps.setBoolean(12, record.seqOnEnd);
        ps.setBoolean(13, record.writeAllHistories);
        ps.setShort(14, record.executing);
        if (batch) {
            ps.addBatch();
        } else {
            ps.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskID[] getSeqSteps(final TaskID taskID, final int seq, final TaskStatus status) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<TaskID> ids = new ArrayList<TaskID>();
                try {
                    ps = TaskPersistLayer.prepareStatement(NCTSEStateMapTableInDatabase.SQL_GET_NEXT_STEPS);
                    ps.setString(1, taskID.toString());
                    ps.setInt(2, seq);
                    ps.setInt(3, status.getId());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ids.add(new TaskID(rs.getString(1)));
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return ids.toArray(new TaskID[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getSeqSteps");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskID[] taskIDArray = (TaskID[])handler.execute(sqlExecute);
            return taskIDArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskID[] getAllSeqSteps(final TaskID taskID, final int startSeq, final TaskStatus maxStatus) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<TaskID> ids = new ArrayList<TaskID>();
                try {
                    ps = TaskPersistLayer.prepareStatement(NCTSEStateMapTableInDatabase.SQL_GET_ALL_NEXT_STEPS);
                    ps.setString(1, taskID.toString());
                    ps.setInt(2, startSeq);
                    ps.setInt(3, maxStatus.getId());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ids.add(new TaskID(rs.getString(1)));
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return ids.toArray(new TaskID[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getAllSeqSteps");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskID[] taskIDArray = (TaskID[])handler.execute(sqlExecute);
            return taskIDArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextStep(TaskID taskID, int seq, int stepCount) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.nextStep");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject(seq), new SQLObject(stepCount), taskID.getSqlValue()};
            int n = TaskPersistLayer.getInstance().execute(SQL_NEXT_STEP, null, values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public void runViaMS(TaskID taskID) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.runViaMS");
        try {
            TaskPersistLayer.getInstance().execute(SQL_RUN_VIA_MS, null, new SQLObject[]{taskID.getSqlValue()});
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setStepsAsReady(TaskID taskID, int seq, TaskStatus newStatus) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.setStepsAsReady");
        try {
            SQLObject[] values = new SQLObject[]{newStatus.getSqlValue(), taskID.getSqlValue(), new SQLObject(seq), TaskStatus.PENDING.getSqlValue(), TaskStatus.READY.getSqlValue()};
            int n = TaskPersistLayer.getInstance().execute(SQL_CHILD_SEQ_STATUS, null, values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateFailStatus(TaskID taskID, TaskStatus newStatus, TaskStatus oldStatus) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.updateFailStatus");
        try {
            SQLObject[] values = new SQLObject[]{newStatus.getSqlValue(), taskID.getSqlValue(), oldStatus.getSqlValue()};
            int n = TaskPersistLayer.getInstance().execute(SQL_UPDATE_FIELD, "FAIL_STATUS", values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateStatus(TaskID taskID, TaskStatus newStatus, TaskStatus oldStatus) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.updateStatus");
        try {
            SQLObject[] values = new SQLObject[]{newStatus.getSqlValue(), taskID.getSqlValue(), oldStatus.getSqlValue()};
            int n = TaskPersistLayer.getInstance().execute(SQL_UPDATE_FIELD, "STATUS", values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateStatus(TaskID taskID, TaskStatus newStatus, TaskStatus oldStatus, int modCount) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.updateStatus(..., modCount)");
        try {
            SQLObject[] values = new SQLObject[]{newStatus.getSqlValue(), taskID.getSqlValue(), oldStatus.getSqlValue(), new SQLObject(modCount, 4)};
            int n = TaskPersistLayer.getInstance().execute(SQL_UPDATE_FIELD_CHECK_MODCOUNT, "STATUS", values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateStepFailed(TaskID taskID, byte value) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.updateStepFailed");
        try {
            SQLObject[] values = new SQLObject[3];
            values[0] = new SQLObject(value, 4);
            values[1] = taskID.getSqlValue();
            String sql = SQL_UPDATE_STEP_FAILED;
            if (value == 1) {
                sql = sql + " WHERE STEP_FAILED <> 1";
            } else if (value == 2) {
                sql = sql + " WHERE STEP_FAILED==0";
            }
            values[2] = new SQLObject(new Byte(value), 4);
            int n = TaskPersistLayer.getInstance().execute(SQL_UPDATE_STEP_FAILED, "STEP_FAILED", values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countInactiveSiblings(final TaskID parentID) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                int count = 0;
                try {
                    ps = TaskPersistLayer.prepareStatement(NCTSEStateMapTableInDatabase.SQL_COUNT_SIBLINGS_BY_STATUS);
                    ps.setString(1, parentID.toString());
                    ps.setInt(2, TaskStatus.INACTIVE.getId());
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return count;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.countInactiveSiblings");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            int n = (Integer)handler.execute(sqlExecute);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetForRestart(TaskStateRecord record, short restartSequence, short countSeq, short stepCount, TaskStatus status, boolean run) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.resetForRestart");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject(status.getId(), 4), new SQLObject(stepCount, 4), new SQLObject(countSeq, 4), new SQLObject(restartSequence, 4), record.taskID.getSqlValue()};
            TaskPersistLayer.getInstance().execute(SQL_RESTART_RESET, null, values);
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSeqCount(final TaskID taskID) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                SqlUpdateVerb update = new SqlUpdateVerb();
                Object result = update.query(NCTSEStateMapTableInDatabase.SQL_GET_FIELD, "COUNT_SEQ", new SQLObject[]{taskID.getSqlValue()}, new SqlUpdateVerb.ProcessResultSet(){

                    @Override
                    public Object process(ResultSet rs) throws SQLException {
                        return rs.next() ? Integer.valueOf(rs.getInt(1)) : null;
                    }
                });
                return result == null ? 0 : (Integer)result;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getSeqCount");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            int n = (Integer)handler.execute(sqlExecute);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskID[] getTaskIDs() throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<TaskID> tasks = new ArrayList<TaskID>();
                try {
                    ps = TaskPersistLayer.prepareStatement(NCTSEStateMapTableInDatabase.SQL_SELECT_TASKIDS);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        tasks.add(new TaskID(rs.getString(1)));
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return tasks.toArray(new TaskID[tasks.size()]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getTaskIDs");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskID[] taskIDArray = (TaskID[])handler.execute(sqlExecute);
            return taskIDArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStateTable.StepInfo[] getChildren(final TaskID taskID, final TaskStatus status) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<TaskStateTable.StepInfo> tasks = new ArrayList<TaskStateTable.StepInfo>();
                try {
                    String sql = NCTSEStateMapTableInDatabase.SQL_GET_CHILDREN;
                    if (status != null) {
                        sql = sql + " AND STATUS=?";
                    }
                    ps = TaskPersistLayer.prepareStatement(sql);
                    ps.setString(1, taskID.toString());
                    if (status != null) {
                        ps.setByte(2, status.getId());
                    }
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        TaskStateTable.StepInfo obj = new TaskStateTable.StepInfo(new TaskID(rs.getString(1)), rs.getShort(2), rs.getShort(3), rs.getShort(4), rs.getShort(5), rs.getByte(6), rs.getBoolean(7), null);
                        tasks.add(obj);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return tasks.toArray(new TaskStateTable.StepInfo[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getChildren");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskStateTable.StepInfo[] stepInfoArray = (TaskStateTable.StepInfo[])handler.execute(sqlExecute);
            return stepInfoArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskID[] getChildTaskIds(final TaskID taskID, final TaskStatus status) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<TaskID> tasks = new ArrayList<TaskID>();
                try {
                    String sql = NCTSEStateMapTableInDatabase.SQL_GET_CHILD_TASK_IDS;
                    if (status != null) {
                        sql = sql + " AND STATUS=?";
                    }
                    ps = TaskPersistLayer.prepareStatement(sql);
                    ps.setString(1, taskID.toString());
                    if (status != null) {
                        ps.setByte(2, status.getId());
                    }
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        TaskID obj = new TaskID(rs.getString(1));
                        tasks.add(obj);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return tasks.toArray(new TaskID[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getChildTaskIds");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskID[] taskIDArray = (TaskID[])handler.execute(sqlExecute);
            return taskIDArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStateTable.StepInfo[] getTasksForPurge(final TaskID taskID, final int limit) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<TaskStateTable.StepInfo> tasks = new ArrayList<TaskStateTable.StepInfo>();
                try {
                    String sql = taskID == null ? SQL_GET_COMPLETED_TASKS_NULL : SQL_GET_COMPLETED_TASKS;
                    ps = TaskPersistLayer.prepareStatement(sql);
                    if (taskID != null) {
                        ps.setString(1, taskID.getID());
                    }
                    ps.setMaxRows(limit);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        TaskStateTable.StepInfo obj = new TaskStateTable.StepInfo(new TaskID(rs.getString(1)), rs.getShort(2), rs.getShort(3), rs.getShort(4), rs.getShort(5), rs.getByte(6), rs.getBoolean(7), null);
                        tasks.add(obj);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return tasks.toArray(new TaskStateTable.StepInfo[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getTasksForPurge");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskStateTable.StepInfo[] stepInfoArray = (TaskStateTable.StepInfo[])handler.execute(sqlExecute);
            return stepInfoArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStateTable.StepInfo[] getStatusChildren(final TaskID taskID, final TaskStatus status) throws TaskPersistLayerException {
        if (taskID == null) {
            return new TaskStateTable.StepInfo[0];
        }
        SQLExecute sqlExecute = new SQLExecute(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<TaskStateTable.StepInfo> tasks = new ArrayList<TaskStateTable.StepInfo>();
                try {
                    String sql = NCTSEStateMapTableInDatabase.SQL_GET_STATUS_CHILDREN;
                    ps = TaskPersistLayer.prepareStatement(sql);
                    ps.setString(1, taskID.getID());
                    status.getSqlValue().setValue(ps, 2);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        TaskStateTable.StepInfo obj = new TaskStateTable.StepInfo(new TaskID(rs.getString(1)), rs.getShort(2), rs.getShort(3), rs.getShort(4), rs.getShort(5), rs.getByte(6), rs.getBoolean(7), null);
                        tasks.add(obj);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                        catch (IOException e2) {
                            throw new TaskPersistLayerException(e2);
                        }
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return tasks.toArray(new TaskStateTable.StepInfo[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getStatusChildren");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskStateTable.StepInfo[] stepInfoArray = (TaskStateTable.StepInfo[])handler.execute(sqlExecute);
            return stepInfoArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStateTable.StepInfo[] getStatusSeqChildren(final TaskID taskID, final short seq, final TaskStatus status) throws TaskPersistLayerException {
        if (taskID == null) {
            return new TaskStateTable.StepInfo[0];
        }
        SQLExecute sqlExecute = new SQLExecute(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<TaskStateTable.StepInfo> tasks = new ArrayList<TaskStateTable.StepInfo>();
                try {
                    String sql = NCTSEStateMapTableInDatabase.SQL_GET_STATUS_SEQ_CHILDREN;
                    ps = TaskPersistLayer.prepareStatement(sql);
                    ps.setString(1, taskID.getID());
                    status.getSqlValue().setValue(ps, 2);
                    ps.setShort(3, seq);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        TaskStateTable.StepInfo obj = new TaskStateTable.StepInfo(new TaskID(rs.getString(1)), rs.getShort(2), rs.getShort(3), rs.getShort(4), rs.getShort(5), rs.getByte(6), rs.getBoolean(7), null);
                        tasks.add(obj);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                        catch (IOException e2) {
                            throw new TaskPersistLayerException(e2);
                        }
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return tasks.toArray(new TaskStateTable.StepInfo[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getStatusSeqChildren");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskStateTable.StepInfo[] stepInfoArray = (TaskStateTable.StepInfo[])handler.execute(sqlExecute);
            return stepInfoArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setParentToNullOnChildren(TaskID taskID, TaskStatus setStatus) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.setParentToNullOnChildren");
        try {
            setStatus = setStatus == null ? (setStatus = TaskStatus.TERMINATED) : setStatus;
            SQLObject[] values = new SQLObject[]{new SQLObject(setStatus.getId(), 4), taskID.getSqlValue()};
            int n = TaskPersistLayer.getInstance().execute(SQL_CLEAR_PARENT_ID, null, values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    public Connection getConnection() throws TaskPersistLayerException {
        return TaskPersistLayer.getConnection();
    }

    @Override
    public int setParentToNullOnChildren(TaskID[] taskIds, TaskStatus setStatus) throws TaskPersistLayerException {
        BatchPreparedStatement bps = null;
        TaskStatus newStatus = setStatus;
        int[] result = null;
        int orphanCount = 0;
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.setParentToNullOnChildren");
        try {
            int idx;
            if (null == newStatus) {
                newStatus = TaskStatus.TERMINATED;
            }
            bps = new BatchPreparedStatement(this.getConnection(), SQL_CLEAR_PARENT_ID);
            for (idx = 0; idx < taskIds.length; ++idx) {
                bps.setInt(1, newStatus.getId());
                bps.setString(2, taskIds[idx].getID());
                bps.addBatch();
            }
            result = bps.executeBatch();
            orphanCount = 0;
            for (idx = 0; idx < result.length; ++idx) {
                orphanCount += result[idx];
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new TaskPersistLayerException(e);
        }
        finally {
            try {
                if (null != bps) {
                    bps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new TaskPersistLayerException(e);
            }
            zipiTimer.stop();
        }
        return orphanCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setParentToNullOnCompletedChildren(TaskID taskID, TaskStatus setStatus) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.setParentToNullOnCompletedChildren");
        try {
            setStatus = setStatus == null ? (setStatus = TaskStatus.TERMINATED) : setStatus;
            SQLObject[] values = new SQLObject[]{new SQLObject(setStatus.getId(), 4), taskID.getSqlValue()};
            int n = TaskPersistLayer.getInstance().execute(SQL_CLEAR_PARENT_ID_COMPLETED, null, values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteTask(TaskID taskID) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.deleteTask");
        try {
            int n = TaskPersistLayer.getInstance().execute(SQL_DELETE_TASK, null, new SQLObject[]{new SQLObject(taskID.getID(), 1)});
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCountChildren(final TaskStatus status1, final TaskStatus status2, final TaskID parent) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                int count = 0;
                try {
                    int psIndex = 1;
                    if (status2 != null) {
                        ps = TaskPersistLayer.prepareStatement(NCTSEStateMapTableInDatabase.SQL_COUNT_CHILDREN_BY_2_STATES);
                        ps.setInt(psIndex++, status1.getId());
                        ps.setInt(psIndex++, status2.getId());
                    } else {
                        ps = TaskPersistLayer.prepareStatement(NCTSEStateMapTableInDatabase.SQL_COUNT_CHILDREN_BY_STATE);
                        ps.setInt(psIndex++, status1.getId());
                    }
                    if (parent == null) {
                        ps.setNull(psIndex++, 12);
                    } else {
                        ps.setString(psIndex++, parent.getID());
                    }
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return count;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getCountChildren");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            int n = (Integer)handler.execute(sqlExecute);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildTasks(final TaskID taskId) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                boolean hasChildren;
                ResultSet rs;
                PreparedStatement ps;
                block6: {
                    ps = null;
                    rs = null;
                    int count = 0;
                    hasChildren = false;
                    try {
                        if (taskId == null) break block6;
                        ps = TaskPersistLayer.prepareStatement(NCTSEStateMapTableInDatabase.SQL_COUNT_CHILDREN);
                        ps.setString(1, taskId.getID());
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            count = rs.getInt(1);
                        }
                        if (count > 0) {
                            hasChildren = true;
                        }
                    }
                    catch (SQLException e) {
                        try {
                            throw new TaskPersistLayerException(e);
                        }
                        catch (Throwable throwable) {
                            TaskPersistLayer.closeStatement(ps, rs);
                            throw throwable;
                        }
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return hasChildren;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.hasChildTasks");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            boolean bl = (Boolean)handler.execute(sqlExecute);
            return bl;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskTable.StoreInfo[] getCompletedStoreInfo(final TaskID taskID, final int limit) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<TaskTable.StoreInfo> info = new ArrayList<TaskTable.StoreInfo>();
                try {
                    String sql = taskID == null ? NCTSEStateMapTableInDatabase.SDS_SELECT_COMPLETE_STORE_INFO_NULL : NCTSEStateMapTableInDatabase.SDS_SELECT_COMPLETE_STORE_INFO;
                    ps = TaskPersistLayer.prepareStatement(sql);
                    ps.setMaxRows(limit);
                    if (taskID != null) {
                        ps.setString(1, taskID.getID());
                    }
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        TaskID restart = rs.getString(3) != null ? new TaskID(rs.getString(3)) : null;
                        String storeID = rs.getString(2) != null ? rs.getString(2).trim() : null;
                        Date executionTime = new Date(rs.getLong(4));
                        info.add(new TaskTable.StoreInfo(new TaskID(rs.getString(1)), storeID, restart, executionTime));
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return info.toArray(new TaskTable.StoreInfo[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getCompletedStoreInfo");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskTable.StoreInfo[] storeInfoArray = (TaskTable.StoreInfo[])handler.execute(sqlExecute);
            return storeInfoArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStateTable.StepInfo[] getTaskTree(final String rootId) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ArrayList<TaskStateTable.StepInfo> tasks = new ArrayList<TaskStateTable.StepInfo>();
                try {
                    ps = TaskPersistLayer.prepareStatement(NCTSEStateMapTableInDatabase.SQL_GET_TASK_TREE);
                    ps.setString(1, rootId);
                    NCTSEStateMapTableInDatabase.this.fireTasksQuery(ps, tasks);
                }
                catch (SQLException e) {
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps, null);
                }
                return tasks.toArray(new TaskStateTable.StepInfo[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getTaskTree");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskStateTable.StepInfo[] stepInfoArray = (TaskStateTable.StepInfo[])handler.execute(sqlExecute);
            return stepInfoArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTasksQuery(PreparedStatement ps, List<TaskStateTable.StepInfo> tasks) throws SQLException {
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            while (rs.next()) {
                String parentId = rs.getString(8);
                TaskID parent = parentId == null || "".equals(parentId) ? null : new TaskID(parentId);
                TaskStateTable.StepInfo obj = new TaskStateTable.StepInfo(new TaskID(rs.getString(1)), rs.getShort(2), rs.getShort(3), rs.getShort(4), rs.getShort(5), rs.getByte(6), rs.getBoolean(7), parent);
                tasks.add(obj);
            }
        }
        finally {
            TaskPersistLayer.closeStatement(null, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStateTable.StepInfo[] getInactiveTasks(final String sdsInstanceId) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                List<TaskStateTable.StepInfo> tasks = NCTSEStateMapTableInDatabase.this.getInactiveTasksFromDB(sdsInstanceId);
                return tasks.toArray(new TaskStateTable.StepInfo[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getInactiveTasks");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskStateTable.StepInfo[] stepInfoArray = (TaskStateTable.StepInfo[])handler.execute(sqlExecute);
            return stepInfoArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStateTable.StepInfo[] getRunningTasks(final String sdsInstanceId) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ArrayList<TaskStateTable.StepInfo> tasks = new ArrayList<TaskStateTable.StepInfo>();
                try {
                    ps = TaskPersistLayer.prepareStatement(NCTSEStateMapTableInDatabase.SQL_GET_RUNNING_TASKS);
                    ps.setString(1, sdsInstanceId);
                    NCTSEStateMapTableInDatabase.this.fireTasksQuery(ps, tasks);
                }
                catch (SQLException e) {
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps, null);
                }
                return tasks.toArray(new TaskStateTable.StepInfo[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.getRunningTasks");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskStateTable.StepInfo[] stepInfoArray = (TaskStateTable.StepInfo[])handler.execute(sqlExecute);
            return stepInfoArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    protected List<TaskStateTable.StepInfo> getInactiveTasksFromDB(String sdsInstanceId) throws TaskPersistLayerException {
        ArrayList<TaskStateTable.StepInfo> tasks = new ArrayList<TaskStateTable.StepInfo>();
        PreparedStatement ps = null;
        String statement = SQL_GET_INACTIVE_TASKS;
        try {
            ps = TaskPersistLayer.prepareStatement(statement);
            ps.setString(1, sdsInstanceId);
            this.fireTasksQuery(ps, tasks);
        }
        catch (SQLException e) {
            throw new TaskPersistLayerException(e);
        }
        finally {
            TaskPersistLayer.closeStatement(ps, null);
        }
        return tasks;
    }
}

