/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class NCTaskHistorySubIndexTable {
    private static final String SQL_GET_LAST = "SELECT LAST_SUB_INDEX FROM NC_TASK_HISTORY_SUB_INDEX WHERE TASK_ID=?";
    private static final String SQL_INS_LAST = "INSERT INTO NC_TASK_HISTORY_SUB_INDEX (TASK_ID, LAST_SUB_INDEX) VALUES (?, ?)";
    private static final String SQL_UPD_LAST = "UPDATE NC_TASK_HISTORY_SUB_INDEX SET LAST_SUB_INDEX=? WHERE TASK_ID=?";
    protected static final String SQL_DELETE = "DELETE FROM NC_TASK_HISTORY_SUB_INDEX WHERE TASK_ID=?";
    protected static final String SQL_GET_MAX_SUB_INDEX = "SELECT MAX(SUB_INDEX) FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID=?";

    public Connection getConnection() throws TaskPersistLayerException {
        return TaskPersistLayer.getConnection();
    }

    private void closePreparedStatement(PreparedStatement ps) {
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("SQL Error closing PreparedStatement:" + e.getMessage());
            }
        }
    }

    private void closeResultSet(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("SQL Error closing ResultSet:" + e.getMessage());
            }
        }
    }

    protected int insertNewRow(Connection con, TaskID taskId) {
        return this.insertNewRow(con, taskId, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insertNewRow(Connection con, TaskID taskId, int lastSubIndexValue) {
        assert (null != taskId);
        PreparedStatement psInsert = null;
        int rowsUpdated = 0;
        try {
            psInsert = con.prepareStatement(SQL_INS_LAST);
            psInsert.setString(1, taskId.getID());
            psInsert.setInt(2, lastSubIndexValue);
            rowsUpdated = psInsert.executeUpdate();
        }
        catch (SQLException e) {
            int n = 0;
            return n;
        }
        finally {
            this.closePreparedStatement(psInsert);
        }
        return rowsUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextSubIndex(TaskID taskId) throws TaskPersistLayerException, SQLException {
        assert (null != taskId);
        Connection con = null;
        PreparedStatement psGet = null;
        PreparedStatement psGetFromIndexTable = null;
        PreparedStatement psUpdate = null;
        ResultSet rsGet = null;
        ResultSet rsGetFromIndexTable = null;
        int last = 0;
        int next = -1;
        int lastFromIndextable = 0;
        long timestamp = 0L;
        try {
            int rowsUpdated = 0;
            con = this.getConnection();
            timestamp = System.currentTimeMillis();
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 1 : lastFromIndextable = " + lastFromIndextable);
            while (0 == rowsUpdated) {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 2 : at start of while loop rowsUpdated = " + rowsUpdated);
                psGet = con.prepareStatement(SQL_GET_MAX_SUB_INDEX);
                psGet.setString(1, taskId.getID());
                rsGet = psGet.executeQuery();
                if (rsGet.next()) {
                    last = rsGet.getInt(1);
                }
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 3 : in while : last = " + last);
                psGetFromIndexTable = con.prepareStatement(SQL_GET_LAST);
                psGetFromIndexTable.setString(1, taskId.getID());
                rsGetFromIndexTable = psGetFromIndexTable.executeQuery();
                if (rsGetFromIndexTable.next()) {
                    lastFromIndextable = rsGetFromIndexTable.getInt(1);
                }
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 4 : in while : lastFromIndextable = " + lastFromIndextable);
                if (null == psUpdate) {
                    psUpdate = con.prepareStatement(SQL_UPD_LAST);
                }
                if (last == 0 && lastFromIndextable == 0) {
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 5 : last == 0 && lastFromIndextable == 0 : inserting new row ");
                    rowsUpdated = this.insertNewRow(con, taskId);
                    last = 0;
                    next = 1;
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 6 : rowsUpdated = " + rowsUpdated + " : last = " + last + " : next = " + next);
                    continue;
                }
                if (last > 0 && lastFromIndextable > 0 && last == lastFromIndextable) {
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 7 : last > 0 && lastFromIndextable > 0 && last == lastFromIndextable ");
                    next = last + 1;
                    psUpdate.setInt(1, next);
                    psUpdate.setString(2, taskId.getID());
                    rowsUpdated = psUpdate.executeUpdate();
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 8 : rowsUpdated = " + rowsUpdated + " : last = " + last + " : next = " + next);
                    continue;
                }
                if (last == lastFromIndextable) continue;
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 9 : last != lastFromIndextable : last = " + last + " : lastFromIndextable = " + lastFromIndextable);
                if (lastFromIndextable > last) {
                    next = lastFromIndextable + 1;
                    psUpdate.setInt(1, next);
                    psUpdate.setString(2, taskId.getID());
                    rowsUpdated = psUpdate.executeUpdate();
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 10 : rowsUpdated = " + rowsUpdated + " : last = " + last + " : next = " + next);
                    continue;
                }
                if (last <= lastFromIndextable) continue;
                next = last + 1;
                if (lastFromIndextable > 0) {
                    psUpdate.setInt(1, next);
                    psUpdate.setString(2, taskId.getID());
                    rowsUpdated = psUpdate.executeUpdate();
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 11 : rowsUpdated = " + rowsUpdated + " : last = " + last + " : next = " + next);
                    continue;
                }
                rowsUpdated = this.insertNewRow(con, taskId, next);
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 12 : rowsUpdated = " + rowsUpdated + " : last = " + last + " : next = " + next);
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 13 : Exception = " + ex);
        }
        finally {
            this.closePreparedStatement(psGet);
            this.closePreparedStatement(psUpdate);
            this.closeResultSet(rsGet);
            this.closePreparedStatement(psGetFromIndexTable);
            this.closeResultSet(rsGetFromIndexTable);
        }
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(timestamp + " : NCTaskHistorySubIndexTable : 14 : next = " + next);
        return next;
    }
}

