/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.jdbc.util.JDBCBlobUtil;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.serverinst.InstanceUtil;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandler;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.SQLObject;
import com.cognos.jsmcommon.tse.SqlUpdateVerb;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskPriorityQueue;
import com.cognos.jsmcommon.tse.TaskQueueMetrics;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskRecordScheduleTypePersistMapper;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.SQLParserUtils;
import com.cognos.jsmcommon.util.ZipUtils;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class NCTaskQueueTable {
    static final String ALL_COLUMNS_NO_BLOBS = "TASK_ID,DATE_ENTERED,SERVER_GROUP,SERVICE_NAME,STATUS,PRIORITY,HISTORY_STORE_ID,SDS_INSTANCE_ID,RESTART_ID,ACTUAL_EXECUTION_TIME,DISPATCHER_ID,SCHEDULE_TRIGGER_NAME,SCHEDULE_TYPE,ACCOUNT_PATH, STOREID, OBJECT_CLASS, ACTUAL_COMPLETION_TIME, OWNER_STOREID, PROCESS_ID, TARGET_DISPATCHER_ID, TENANT_ID";
    static final String ALL_COLUMNS = "TASK_ID,DATE_ENTERED,SERVER_GROUP,SERVICE_NAME,STATUS,PRIORITY,HISTORY_STORE_ID,SDS_INSTANCE_ID,RESTART_ID,ACTUAL_EXECUTION_TIME,DISPATCHER_ID,SCHEDULE_TRIGGER_NAME,SCHEDULE_TYPE,ACCOUNT_PATH, STOREID, OBJECT_CLASS, ACTUAL_COMPLETION_TIME, OWNER_STOREID, PROCESS_ID, TARGET_DISPATCHER_ID, TENANT_ID,TASK";
    static final String SQL_FIND_TASK = "SELECT TASK_ID,DATE_ENTERED,SERVER_GROUP,SERVICE_NAME,STATUS,PRIORITY,HISTORY_STORE_ID,SDS_INSTANCE_ID,RESTART_ID,ACTUAL_EXECUTION_TIME,DISPATCHER_ID,SCHEDULE_TRIGGER_NAME,SCHEDULE_TYPE,ACCOUNT_PATH, STOREID, OBJECT_CLASS, ACTUAL_COMPLETION_TIME, OWNER_STOREID, PROCESS_ID, TARGET_DISPATCHER_ID, TENANT_ID,TASK FROM NC_TASK_QUEUE WHERE TASK_ID=?";
    static final String SQL_FIND_TASK_NO_BLOBS = "SELECT TASK_ID,DATE_ENTERED,SERVER_GROUP,SERVICE_NAME,STATUS,PRIORITY,HISTORY_STORE_ID,SDS_INSTANCE_ID,RESTART_ID,ACTUAL_EXECUTION_TIME,DISPATCHER_ID,SCHEDULE_TRIGGER_NAME,SCHEDULE_TYPE,ACCOUNT_PATH, STOREID, OBJECT_CLASS, ACTUAL_COMPLETION_TIME, OWNER_STOREID, PROCESS_ID, TARGET_DISPATCHER_ID, TENANT_ID FROM NC_TASK_QUEUE WHERE TASK_ID=?";
    static final String SQL_FIRST_TASK = "SELECT TASK_ID,DATE_ENTERED,PRIORITY FROM NC_TASK_QUEUE WHERE STATUS=?";
    static final String SQL_FIND_TASKS_PARTIAL_COLUMNS = "SELECT TASK_ID,DATE_ENTERED,SERVER_GROUP,SERVICE_NAME,STATUS,PRIORITY,TARGET_DISPATCHER_ID FROM NC_TASK_QUEUE WHERE TASK_ID ";
    static final String TASK_BLOB_GET = "SELECT TASK FROM NC_TASK_QUEUE WHERE TASK_ID=? FOR UPDATE";
    static final String SQL_CREATE = "INSERT INTO NC_TASK_QUEUE (TASK_ID,DATE_ENTERED,SERVER_GROUP,SERVICE_NAME,STATUS,PRIORITY,HISTORY_STORE_ID,SDS_INSTANCE_ID,RESTART_ID,ACTUAL_EXECUTION_TIME,DISPATCHER_ID,SCHEDULE_TRIGGER_NAME,SCHEDULE_TYPE,ACCOUNT_PATH, STOREID, OBJECT_CLASS, ACTUAL_COMPLETION_TIME, OWNER_STOREID, PROCESS_ID, TARGET_DISPATCHER_ID, TENANT_ID,TASK) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    static final String SQL_CREATE_ANCESTORS = "INSERT INTO NC_TASK_ANCESTOR_STOREIDS (TASK_ID, ANCESTOR_STORE_ID) values (?,?)";
    static final String SQL_STAMP_SDS_INSTANCE_ID = "UPDATE NC_TASK_QUEUE SET SDS_INSTANCE_ID=?, STATUS=? WHERE TASK_ID=? AND STATUS=? AND SDS_INSTANCE_ID IS NULL";
    static final String SQL_UPDATE = "UPDATE NC_TASK_QUEUE $$ WHERE TASK_ID=?";
    static final String SQL_UPDATE_MULTIPLE = "UPDATE NC_TASK_QUEUE $$ WHERE TASK_ID ";
    static final String SQL_RESET_INSTANCE_ID = "UPDATE NC_TASK_QUEUE SET SDS_INSTANCE_ID=NULL WHERE TASK_ID=? AND SDS_INSTANCE_ID=?";
    static final String SQL_RESET_RESTART = "UPDATE NC_TASK_QUEUE SET HISTORY_STORE_ID=NULL, RESTART_ID=?, STATUS=?,SDS_INSTANCE_ID=NULL WHERE TASK_ID=?";
    static final String SQL_SET_INSTANCE_ID = "UPDATE NC_TASK_QUEUE SET SDS_INSTANCE_ID=? WHERE TASK_ID=?";
    static final String SQL_GET_FIELD = "SELECT $$ FROM NC_TASK_QUEUE WHERE TASK_ID=?";
    static final String SQL_GET_FIELD_RESTART_ID = "SELECT $$ FROM NC_TASK_QUEUE WHERE RESTART_ID=?";
    static final String SQL_GET_SDS_INSTANCE_ID = "SELECT DISTINCT SDS_INSTANCE_ID FROM NC_TASK_QUEUE";
    public static final String SQL_UPDATE_FIELD = "UPDATE NC_TASK_QUEUE SET $$=? WHERE TASK_ID=? AND $$=?";
    public static final String SQL_SET_READY = "UPDATE NC_TASK_QUEUE SET STATUS=?, PRIORITY=?, SDS_INSTANCE_ID=NULL WHERE TASK_ID=?";
    private static final String STATE_QUEUE_SIZE_SQL = "SELECT COUNT(*) FROM NC_TASK_QUEUE WHERE STATUS=?";
    private static final String SQL_GET_SERVICE_NAME = "SELECT DISTINCT SERVICE_NAME FROM NC_TASK_QUEUE WHERE STATUS=?";
    protected ConcurrentHashMap<String, TaskPriorityQueue> m_idQueues = new ConcurrentHashMap();
    private static NCTaskQueueTable m_instance = new NCTaskQueueTable();

    public static NCTaskQueueTable getInstance() {
        return m_instance;
    }

    protected static void mock_setInstance(NCTaskQueueTable instance) {
        m_instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskRecord find(final TaskID taskID, final boolean getBlobs) throws TaskPersistLayerException {
        if (taskID == null) {
            return null;
        }
        SQLExecute sqlExecute = new SQLExecute(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object execute() throws TaskPersistLayerException {
                Object record222222;
                ResultSet rs;
                PreparedStatement ps;
                block7: {
                    ps = null;
                    rs = null;
                    ps = TaskPersistLayer.prepareStatement(getBlobs ? NCTaskQueueTable.SQL_FIND_TASK : NCTaskQueueTable.SQL_FIND_TASK_NO_BLOBS);
                    ps.setString(1, taskID.toString());
                    rs = ps.executeQuery();
                    if (!rs.next()) break block7;
                    TaskRecord record222222 = new TaskRecord();
                    NCTaskQueueTable.this.readRow(rs, getBlobs, record222222);
                    TaskRecord taskRecord = record222222;
                    TaskPersistLayer.closeStatement(ps, rs);
                    return taskRecord;
                }
                try {
                    record222222 = null;
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                        catch (IOException e2) {
                            throw new TaskPersistLayerException(e2);
                        }
                        catch (ClassNotFoundException e3) {
                            throw new TaskPersistLayerException(e3);
                        }
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return record222222;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.find");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskRecord taskRecord = (TaskRecord)handler.execute(sqlExecute);
            return taskRecord;
        }
        finally {
            zipiTimer.stop();
        }
    }

    void readRow(ResultSet rs, boolean getBlobs, TaskRecord record) throws SQLException, IOException, ClassNotFoundException {
        record.setTaskId(new TaskID(rs.getString(1)));
        record.setTimeStamp(rs.getLong(2));
        record.setServerGroup(this.trim(rs.getString(3)));
        record.setServiceName(this.trim(rs.getString(4)));
        record.setStatus(TaskQueueStatus.fromId(rs.getByte(5)));
        record.setPriority(rs.getByte(6));
        record.setHistoryStoreId(this.trim(rs.getString(7)));
        record.setSdsInstanceId(rs.getString(8));
        record.setRestartId(rs.getString(9) == null ? null : new TaskID(rs.getString(9)));
        record.setActualExecutionTime(rs.getLong(10));
        record.setDispatcherId(this.trim(rs.getString(11)));
        record.setScheduleTriggerName(rs.getString(12));
        record.setScheduleType(TaskRecordScheduleTypePersistMapper.mapFromPersistedValue(this.trim(rs.getString(13))));
        record.setAccountPath(rs.getString(14));
        record.setTaskStoreId(this.trim(rs.getString(15)));
        record.setObjectClass(this.trim(rs.getString(16)));
        record.setActualCompletionTime(rs.getLong(17));
        record.setOwnerStoreId(rs.getString(18));
        record.setProcessId(rs.getInt(19));
        record.setTargetDispatcherId(this.trim(rs.getString(20)));
        record.setTenantId(this.trim(rs.getString(21)));
        if (getBlobs) {
            record.setRunSpec(null);
            InputStream is = rs.getBinaryStream("TASK");
            if (is != null) {
                record.setRunSpec((TaskRunSpec)ZipUtils.gunzip(is));
            }
        }
    }

    void readPartialRow(ResultSet rs, TaskRecord record) throws SQLException {
        record.setTaskId(new TaskID(rs.getString(1)));
        record.setTimeStamp(rs.getLong(2));
        record.setServerGroup(this.trim(rs.getString(3)));
        record.setServiceName(this.trim(rs.getString(4)));
        record.setStatus(TaskQueueStatus.fromId(rs.getByte(5)));
        record.setPriority(rs.getByte(6));
        record.setTargetDispatcherId(this.trim(rs.getString(7)));
    }

    private String trim(String value) {
        return value == null ? null : value.trim();
    }

    public void insertRecord(TaskRecord record) throws TaskPersistLayerException {
        ArrayList<TaskRecord> records = new ArrayList<TaskRecord>();
        records.add(record);
        this.insertRecords(records, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRecords(final Collection<TaskRecord> records, final boolean batchRequested) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object execute() throws TaskPersistLayerException {
                Iterator iterator;
                Statement ps2;
                block16: {
                    PreparedStatement ps1 = null;
                    ps2 = null;
                    int batchCount = 0;
                    int batchMax = 100;
                    boolean batch = batchRequested;
                    try {
                        if (JDBCBlobUtil.getInstance("SDS").mustUpdateBlob()) {
                            batch = false;
                        }
                        ps1 = TaskPersistLayer.prepareStatement(NCTaskQueueTable.SQL_CREATE);
                        for (TaskRecord record : records) {
                            NCTaskQueueTable.this.create(record, ps1, batch, NCTaskQueueTable.TASK_BLOB_GET);
                            ++batchCount;
                            if (record.getAncestorStoreIds() != null && record.getAncestorStoreIds().length > 0) {
                                if (ps2 == null) {
                                    ps2 = TaskPersistLayer.prepareStatement(NCTaskQueueTable.SQL_CREATE_ANCESTORS);
                                }
                                NCTaskQueueTable.this.createAncestors(record, (PreparedStatement)ps2, batch);
                                ++batchCount;
                            }
                            if (!batch || batchCount != batchMax) continue;
                            ps1.executeBatch();
                            if (ps2 != null) {
                                ps2.executeBatch();
                            }
                            batchCount = 0;
                        }
                        if (batch && batchCount > 0) {
                            ps1.executeBatch();
                        }
                        TaskPersistLayer.closeStatement(ps1);
                        ps1 = null;
                        if (ps2 != null) {
                            if (batch && batchCount > 0) {
                                ps2.executeBatch();
                            }
                            TaskPersistLayer.closeStatement(ps2);
                            ps2 = null;
                        }
                        iterator = null;
                        if (ps1 == null) break block16;
                    }
                    catch (SQLException e) {
                        try {
                            throw new TaskPersistLayerException(e);
                            catch (IOException e2) {
                                throw new TaskPersistLayerException(e2);
                            }
                        }
                        catch (Throwable throwable) {
                            if (ps1 != null) {
                                TaskPersistLayer.closeStatement(ps1);
                            }
                            if (ps2 != null) {
                                TaskPersistLayer.closeStatement(ps2);
                            }
                            throw throwable;
                        }
                    }
                    TaskPersistLayer.closeStatement(ps1);
                }
                if (ps2 != null) {
                    TaskPersistLayer.closeStatement((PreparedStatement)ps2);
                }
                return iterator;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.insertRecords");
        try {
            SQLTransactionExecuteHandler handler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
            handler.execute(sqlExecute);
        }
        finally {
            zipiTimer.stop();
        }
    }

    void create(TaskRecord record, PreparedStatement ps, boolean batch, String blobSql) throws SQLException, IOException, TaskPersistLayerException {
        PreparedStatement blobPs = null;
        byte[] bytes = ZipUtils.gzip(record.getRunSpec());
        try {
            ps.setString(1, record.getTaskId().toString());
            ps.setLong(2, record.getTimeStamp());
            ps.setString(3, record.getServerGroup());
            ps.setString(4, record.getServiceName());
            ps.setByte(5, record.getStatus().getId());
            ps.setByte(6, record.getPriority());
            ps.setString(7, record.getHistoryStoreId());
            ps.setString(8, record.getSdsInstanceId());
            if (record.getRestartId() == null) {
                ps.setNull(9, 12);
            } else {
                ps.setString(9, record.getRestartId().toString());
            }
            ps.setLong(10, record.getActualExecutionTime());
            ps.setString(11, record.getDispatcherId());
            ps.setString(12, record.getScheduleTriggerName());
            ps.setString(13, TaskRecordScheduleTypePersistMapper.mapToPersistedValue(record.getScheduleType()));
            ps.setString(14, record.getAccountPath());
            ps.setString(15, record.getTaskStoreId());
            ps.setString(16, record.getObjectClass());
            ps.setLong(17, record.getActualCompletionTime());
            if (record.getOwnerStoreId() == null) {
                ps.setNull(18, 12);
            } else {
                ps.setString(18, record.getOwnerStoreId());
            }
            ps.setInt(19, record.getProcessId());
            ps.setString(20, record.getTargetDispatcherId());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:getNextTaskIdFromQueue: create: TargetDispatcherId:'" + record.getTargetDispatcherId() + "'");
            ps.setString(21, record.getTenantId());
            boolean shouldUpdateBlob = true;
            shouldUpdateBlob = JDBCBlobUtil.getInstance("SDS").setBlob(ps, 22, bytes);
            int insertedRows = 0;
            if (batch) {
                ps.addBatch();
            } else {
                insertedRows = ps.executeUpdate();
            }
            if (insertedRows > 0 && shouldUpdateBlob) {
                blobPs = TaskPersistLayer.prepareStatement(blobSql);
                blobPs.setString(1, record.getTaskId().toString());
                JDBCBlobUtil.getInstance("SDS").updateBlob(blobPs, bytes);
            }
        }
        catch (SQLException sqlex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(sqlex.getMessage());
            throw sqlex;
        }
        finally {
            TaskPersistLayer.closeStatement(blobPs);
            blobPs = null;
        }
    }

    void createAncestors(TaskRecord record, PreparedStatement ps, boolean batch) throws SQLException, TaskPersistLayerException {
        int insertedRows = 0;
        try {
            for (int i = 0; i < record.getAncestorStoreIds().length; ++i) {
                ps.setString(1, record.getTaskId().toString());
                ps.setString(2, record.getAncestorStoreIds()[i]);
                if (batch) {
                    ps.addBatch();
                    continue;
                }
                insertedRows += ps.executeUpdate();
            }
        }
        catch (SQLException sqlex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(sqlex.getMessage());
            throw sqlex;
        }
    }

    protected TaskRecord.IDDateStruct getNextTaskIdFromQueue(final TaskPriorityQueue idQueue, final String serviceName, final String serverGroup) throws TaskPersistLayerException {
        SQLExecute<TaskRecord.IDDateStruct> sqlExecute = new SQLExecute<TaskRecord.IDDateStruct>(){

            @Override
            public TaskRecord.IDDateStruct execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                TaskRecord.IDDateStruct idDate = null;
                try {
                    String sql = NCTaskQueueTable.SQL_FIRST_TASK;
                    if (serviceName != null) {
                        sql = sql + " AND SERVICE_NAME=?";
                    }
                    if (serverGroup != null && !"taskLoadFailed".equals(serviceName)) {
                        sql = sql + " AND ((TARGET_DISPATCHER_ID=?) OR (TARGET_DISPATCHER_ID IS NULL";
                        sql = sql + " AND (SERVER_GROUP=? OR SERVER_GROUP IS NULL)))";
                    } else {
                        sql = sql + " AND (TARGET_DISPATCHER_ID=? OR TARGET_DISPATCHER_ID IS NULL)";
                    }
                    sql = sql + " AND SDS_INSTANCE_ID IS NULL ORDER BY PRIORITY DESC, DATE_ENTERED DESC";
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:getNextTaskIdFromQueue: SQL: " + sql);
                    String currentDispatcherID = InstanceUtil.getLocalDispatcherNodeIDGuid();
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:getNextTaskIdFromQueue: currentDispatcherID: '" + currentDispatcherID + "'");
                    if (currentDispatcherID != null && !currentDispatcherID.trim().equals("")) {
                        int parameterIndex = 1;
                        ps = TaskPersistLayer.prepareStatement(sql);
                        ps.setLong(parameterIndex++, TaskQueueStatus.READY.getId());
                        if (serviceName != null) {
                            ps.setString(parameterIndex++, serviceName);
                        }
                        ps.setString(parameterIndex++, currentDispatcherID.trim());
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:getNextTaskIdFromQueue: setting in sql : currentDispatcherID: '" + currentDispatcherID.trim() + "'");
                        if (serverGroup != null && !"taskLoadFailed".equals(serviceName)) {
                            ps.setString(parameterIndex, serverGroup);
                        }
                        if (!(rs = ps.executeQuery()).next()) {
                            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:getNextTaskIdFromQueue: result set is empty !");
                        } else {
                            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:getNextTaskIdFromQueue: result set is Not empty. ");
                            do {
                                String taskid = rs.getString(1);
                                idDate = new TaskRecord.IDDateStruct(new TaskID(taskid), rs.getLong(2), rs.getInt(3));
                                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:getNextTaskIdFromQueue: (in loop) taskid: " + taskid);
                                idQueue.add(idDate);
                            } while (rs.next());
                        }
                    } else {
                        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:Unexpected behaviour while getting the next task from the Task Queue, the dispatcher id is null.");
                    }
                }
                catch (SQLException e) {
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:TaskPersistLayer.getNextTaskFromQueue: " + e.getLocalizedMessage());
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps, rs);
                }
                return idDate;
            }
        };
        boolean taskQueueCacheDisabled = CRNProperties.getProperty("event.taskqueue.cache.disabled", false);
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("taskQueueCacheDisabled " + taskQueueCacheDisabled);
        if (taskQueueCacheDisabled || idQueue.isEmpty()) {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            handler.execute(sqlExecute);
        }
        return idQueue.pollFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskID getNextTaskFromQueue(String serviceName, String serverGroup) throws TaskPersistLayerException {
        TaskRecord.IDDateStruct idDate;
        block8: {
            idDate = null;
            ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.getNextTaskFromQueue");
            try {
                TaskPriorityQueue queue = this.getQueue(serviceName, serverGroup, true);
                do {
                    if ((idDate = this.getNextTaskIdFromQueue(queue, serviceName, serverGroup)) == null) {
                        break block8;
                    }
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("next item " + idDate.id.getID() + "  priority:" + idDate.priority);
                } while (!this.stampSdsInstance(idDate.id, TaskQueueStatus.ALLOCATED, TaskQueueStatus.READY));
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:removed " + idDate + " from the task queue");
                if (TaskQueueMetrics.getInstance().tideMetricsActive()) {
                    int count = TaskPersistLayer.getInstance().getCountReadyTasks();
                    TaskQueueMetrics.getInstance().updateQueueLengthLowWaterMark(count);
                    long timeInQueue = new Date().getTime() - idDate.dateEntered;
                    TaskQueueMetrics.getInstance().updateTimeInQueueLowWaterMark(timeInQueue);
                    TaskQueueMetrics.getInstance().updateTimeInQueueHighWaterMark(timeInQueue);
                    TaskQueueMetrics.getInstance().incrementTimeInQueue(timeInQueue);
                    TaskQueueMetrics.getInstance().incrementNumberOfRequests(1L);
                }
            }
            catch (Exception e) {
                TaskPersistLayer.throwException(e);
            }
            finally {
                zipiTimer.stop();
            }
        }
        return idDate != null ? idDate.id : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskRecord[] findTasks(final String[] taskIDs) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<TaskRecord> taskRecords = new ArrayList<TaskRecord>();
                try {
                    if (taskIDs.length > 0) {
                        String[] inClauses = SQLParserUtils.createInClauses(taskIDs, true);
                        for (int i = 0; i < inClauses.length; ++i) {
                            ps = TaskPersistLayer.prepareStatement(NCTaskQueueTable.SQL_FIND_TASKS_PARTIAL_COLUMNS + inClauses[i]);
                            rs = ps.executeQuery();
                            while (rs.next()) {
                                TaskRecord taskRecord = new TaskRecord();
                                NCTaskQueueTable.this.readPartialRow(rs, taskRecord);
                                taskRecords.add(taskRecord);
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.findTasks: " + e.getLocalizedMessage());
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps, rs);
                }
                return taskRecords.toArray(new TaskRecord[taskRecords.size()]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.findTasks");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskRecord[] taskRecordArray = (TaskRecord[])handler.execute(sqlExecute);
            return taskRecordArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTasks(final String[] taskIDs, final String field, final SQLObject value) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                int totalUpdated = 0;
                if (taskIDs != null && taskIDs.length > 0) {
                    SqlUpdateVerb update = new SqlUpdateVerb();
                    SQLObject[] values = new SQLObject[]{value};
                    String[] inClauses = SQLParserUtils.createInClauses(taskIDs, true);
                    for (int i = 0; i < inClauses.length; ++i) {
                        String sql = NCTaskQueueTable.SQL_UPDATE_MULTIPLE + inClauses[i];
                        totalUpdated += update.execute(sql, new String[]{field}, values);
                    }
                }
                return totalUpdated;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.updateTasks");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
            int n = (Integer)handler.execute(sqlExecute);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    protected TaskPriorityQueue getQueue(String serviceName, String serverGroup, boolean allowQueueCreation) {
        serverGroup = serverGroup == null ? "" : serverGroup;
        String key = serviceName + serverGroup;
        TaskPriorityQueue queue = this.m_idQueues.get(key);
        if (null == queue && allowQueueCreation) {
            queue = new TaskPriorityQueue();
            this.m_idQueues.putIfAbsent(key, queue);
            queue = this.m_idQueues.get(key);
        }
        return queue;
    }

    private TaskPriorityQueue getExistingQueueFromAnyServerGroup(String serviceName) {
        TaskPriorityQueue queue = null;
        for (String key : this.m_idQueues.keySet()) {
            if (!key.startsWith(serviceName)) continue;
            queue = this.m_idQueues.get(key);
            break;
        }
        return queue;
    }

    public void addTaskToQueue(TaskRecord taskRecord) {
        boolean taskQueueCacheDisabled = CRNProperties.getProperty("event.taskqueue.cache.disabled", false);
        if (!taskQueueCacheDisabled && taskRecord.getStatus() == TaskQueueStatus.READY) {
            String serviceName = taskRecord.getServiceName();
            String serverGroup = taskRecord.getServerGroup();
            TaskPriorityQueue queue = null;
            queue = serverGroup == null || serverGroup == "" ? this.getExistingQueueFromAnyServerGroup(serviceName) : this.getQueue(serviceName, serverGroup, false);
            if (queue != null) {
                String currentDispatcherID = InstanceUtil.getLocalDispatcherNodeIDGuid();
                String targetDispatcherID = taskRecord.getTargetDispatcherId();
                if (targetDispatcherID == null || currentDispatcherID.equalsIgnoreCase(targetDispatcherID)) {
                    TaskRecord.IDDateStruct newStruct = new TaskRecord.IDDateStruct(taskRecord.getTaskId(), taskRecord.getTimeStamp(), taskRecord.getPriority());
                    queue.add(newStruct);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stampSdsInstance(TaskID taskID, TaskQueueStatus newStatus, TaskQueueStatus curStatus) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.stampSdsInstance");
        try {
            SQLObject[] values = new SQLObject[4];
            values[0] = new SQLObject(TaskPersistLayer.getSdsInstance(), 1);
            Byte me = newStatus.getId();
            values[1] = new SQLObject(me, 4);
            values[2] = taskID.getSqlValue();
            values[3] = new SQLObject(new Byte(curStatus.getId()), 4);
            boolean bl = TaskPersistLayer.getInstance().execute(SQL_STAMP_SDS_INSTANCE_ID, null, values) != 0;
            return bl;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(TaskRecord record, String[] fields) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.update");
        try {
            int n = this.update(record, SQL_UPDATE, fields);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    int update(TaskRecord record, String sql, String[] fields) throws TaskPersistLayerException {
        ArrayList<SQLObject> valueList = new ArrayList<SQLObject>();
        SQLObject blobObject = null;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].equals("SERVER_GROUP")) {
                valueList.add(new SQLObject(record.getServerGroup(), 1));
                continue;
            }
            if (fields[i].equals("SERVICE_NAME")) {
                valueList.add(new SQLObject(record.getServiceName(), 12));
                continue;
            }
            if (fields[i].equals("HISTORY_STORE_ID")) {
                valueList.add(new SQLObject(record.getHistoryStoreId(), 1));
                continue;
            }
            if (fields[i].equals("STATUS")) {
                valueList.add(new SQLObject(record.getStatus().getId(), 4));
                continue;
            }
            if (fields[i].equals("SDS_INSTANCE_ID")) {
                valueList.add(new SQLObject(record.getSdsInstanceId(), 1));
                continue;
            }
            if (fields[i].equals("TASK")) {
                blobObject = new SQLObject(record.getRunSpec(), -2);
                valueList.add(blobObject);
                continue;
            }
            if (fields[i].equals("RESTART_ID")) {
                valueList.add(new SQLObject(record.getRestartId().getID(), 1));
                continue;
            }
            if (fields[i].equals("DISPATCHER_ID")) {
                valueList.add(new SQLObject(record.getDispatcherId(), 1));
                continue;
            }
            if (fields[i].equals("ACTUAL_EXECUTION_TIME")) {
                valueList.add(new SQLObject(new Long(record.getActualExecutionTime()), 4));
                continue;
            }
            if (fields[i].equals("ACTUAL_COMPLETION_TIME")) {
                valueList.add(new SQLObject(new Long(record.getActualCompletionTime()), 4));
                continue;
            }
            if (fields[i].equals("DATE_ENTERED")) {
                valueList.add(new SQLObject(new Long(record.getTimeStamp()), 4));
                continue;
            }
            if (fields[i].equals("PROCESS_ID")) {
                valueList.add(new SQLObject(record.getProcessId(), 4));
                continue;
            }
            if (fields[i].equals("TARGET_DISPATCHER_ID")) {
                valueList.add(new SQLObject(record.getTargetDispatcherId(), 1));
                continue;
            }
            if (!fields[i].equals("TENANT_ID")) continue;
            valueList.add(new SQLObject(record.getTenantId(), 12));
        }
        valueList.add(new SQLObject(record.getTaskId().getID()));
        SQLObject[] values = valueList.toArray(new SQLObject[0]);
        UpdateTaskRecordSQL sqlExecute = new UpdateTaskRecordSQL(record, sql, fields, values, blobObject);
        SQLTransactionExecuteHandler handler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
        return (Integer)handler.execute(sqlExecute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(String[] taskIDs, int priority) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.setPriority");
        try {
            if (taskIDs.length > 0) {
                SQLObject priorityValue = new SQLObject(priority, 4);
                int updated = this.updateTasks(taskIDs, "PRIORITY", priorityValue);
                if (updated > 0) {
                    this.updateQueue(taskIDs, priority);
                }
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:setPriority: taskID count : " + taskIDs.length + ", updated count : " + updated);
            }
        }
        finally {
            zipiTimer.stop();
        }
    }

    private void updateQueue(String[] taskIDs, int priority) throws TaskPersistLayerException {
        int updated = 0;
        TaskRecord[] taskRecords = this.findTasks(taskIDs);
        for (int i = 0; i < taskRecords.length; ++i) {
            TaskID taskId;
            TaskPriorityQueue queue = this.getQueue(taskRecords[i].getServiceName(), taskRecords[i].getServerGroup(), false);
            if (queue == null || !queue.updatePriority(taskId = new TaskID(taskIDs[i]), priority)) continue;
            ++updated;
        }
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("NCTaskQueueTable:updatePriorityQueue: taskID count : " + taskIDs.length + ", updated count : " + updated);
    }

    protected int setValue(final TaskID taskID, final String sql, final String field, final SQLObject val) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                SqlUpdateVerb update = new SqlUpdateVerb();
                SQLObject[] values = new SQLObject[]{val, taskID.getSqlValue()};
                return update.execute(sql, new String[]{field}, values);
            }
        };
        SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
        return (Integer)handler.execute(sqlExecute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(TaskID taskID, TaskQueueStatus status) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.setStatus");
        try {
            SQLObject value = new SQLObject(status.getId(), 4);
            this.setValue(taskID, SQL_UPDATE, "STATUS", value);
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setRestartId(TaskID taskID, TaskID restartHistoryID) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.setRestartId");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject(restartHistoryID == null ? null : restartHistoryID.getID(), 1), taskID.getSqlValue()};
            int n = TaskPersistLayer.getInstance().execute("UPDATE NC_TASK_QUEUE SET $$=? WHERE TASK_ID=?", "RESTART_ID", values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateStatus(TaskID taskID, TaskQueueStatus newStatus, TaskQueueStatus oldStatus) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.updateStatus");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject(newStatus.getId(), 4), taskID.getSqlValue(), new SQLObject(oldStatus.getId(), 4)};
            int n = TaskPersistLayer.getInstance().execute(SQL_UPDATE_FIELD, "STATUS", values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setReady(TaskID taskID, byte priority) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.setReady");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject(TaskQueueStatus.READY.getId(), 4), new SQLObject(priority, 4), taskID.getSqlValue()};
            int n = TaskPersistLayer.getInstance().execute(SQL_SET_READY, null, values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clearSdsInstance(TaskID taskID) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.clearSdsInstance");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject(null, 1), taskID.getSqlValue()};
            int n = TaskPersistLayer.getInstance().execute(SQL_SET_INSTANCE_ID, null, values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setSdsInstance(TaskID taskID) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.setSdsInstance(TaskID)");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject(TaskPersistLayer.getSdsInstance(), 1), taskID.getSqlValue()};
            int n = TaskPersistLayer.getInstance().execute(SQL_SET_INSTANCE_ID, null, values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setSdsInstance(TaskRecord record) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.setSdsInstance(TaskRecord)");
        try {
            SQLObject[] values = new SQLObject[]{new SQLObject(TaskPersistLayer.getSdsInstance(), 1), record.getTaskId().getSqlValue()};
            int n = TaskPersistLayer.getInstance().execute(SQL_SET_INSTANCE_ID, null, values);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSdsInstance(final TaskID taskID) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                SqlUpdateVerb update = new SqlUpdateVerb();
                Object result = update.query(NCTaskQueueTable.SQL_GET_FIELD, "SDS_INSTANCE_ID", new SQLObject[]{taskID.getSqlValue()}, new SqlUpdateVerb.ProcessResultSet(){

                    @Override
                    public Object process(ResultSet rs) throws SQLException {
                        return rs.next() ? rs.getString(1) : null;
                    }
                });
                if (result == null) {
                    update = new SqlUpdateVerb();
                    result = update.query(NCTaskQueueTable.SQL_GET_FIELD_RESTART_ID, "SDS_INSTANCE_ID", new SQLObject[]{new SQLObject(taskID.toEventId(), 1)}, new SqlUpdateVerb.ProcessResultSet(){

                        @Override
                        public Object process(ResultSet rs) throws SQLException {
                            return rs.next() ? rs.getString(1) : null;
                        }
                    });
                }
                return (String)result;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.getSdsInstance");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            String string = (String)handler.execute(sqlExecute);
            return string;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskID findTaskID(final TaskID possibleRestartId) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                TaskID validatedTaskID = null;
                SqlUpdateVerb check = new SqlUpdateVerb();
                validatedTaskID = (TaskID)check.query(NCTaskQueueTable.SQL_GET_FIELD_RESTART_ID, "TASK_ID", new SQLObject[]{new SQLObject(possibleRestartId.toString(), 1)}, new SqlUpdateVerb.ProcessResultSet(){

                    @Override
                    public Object process(ResultSet rs) throws SQLException {
                        String tid = null;
                        if (rs.next()) {
                            tid = rs.getString(1);
                        }
                        return tid == null ? null : new TaskID(tid);
                    }
                });
                return validatedTaskID == null ? possibleRestartId : validatedTaskID;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.findTaskID");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskID taskID = (TaskID)handler.execute(sqlExecute);
            return taskID;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskID findRestartID(final TaskID taskID) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                TaskID restartEventID = null;
                SqlUpdateVerb check = new SqlUpdateVerb();
                restartEventID = (TaskID)check.query(NCTaskQueueTable.SQL_GET_FIELD, "RESTART_ID", new SQLObject[]{taskID.getSqlValue()}, new SqlUpdateVerb.ProcessResultSet(){

                    @Override
                    public Object process(ResultSet rs) throws SQLException {
                        String eid = null;
                        if (rs.next()) {
                            eid = rs.getString(1);
                        }
                        return eid == null ? null : new TaskID(eid);
                    }
                });
                return restartEventID == null ? taskID : restartEventID;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.findRestartID");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            TaskID taskID2 = (TaskID)handler.execute(sqlExecute);
            return taskID2;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSdsInstanceGuids() throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<String> guidList = new ArrayList<String>();
                try {
                    ps = TaskPersistLayer.prepareStatement(NCTaskQueueTable.SQL_GET_SDS_INSTANCE_ID);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String guid = rs.getString(1) != null ? rs.getString(1).trim() : null;
                        if (guid == null) continue;
                        guidList.add(guid);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return guidList.toArray(new String[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.getSdsInstanceGuids");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            String[] stringArray = (String[])handler.execute(sqlExecute);
            return stringArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    public int getCountTasks(TaskQueueStatus status) throws TaskPersistLayerException {
        return this.getCountTasks(new TaskQueueStatus[]{status});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountTasks(final TaskQueueStatus[] statii) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                int i;
                PreparedStatement ps = null;
                ResultSet rs = null;
                int count = 0;
                StringBuffer sql = new StringBuffer(NCTaskQueueTable.STATE_QUEUE_SIZE_SQL);
                for (i = 1; i < statii.length; ++i) {
                    sql.append(" OR STATUS=?");
                }
                try {
                    ps = TaskPersistLayer.prepareStatement(sql.toString());
                    for (i = 0; i < statii.length; ++i) {
                        ps.setLong(i + 1, statii[i].getId());
                    }
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return count;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.getCountTasks");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            int n = (Integer)handler.execute(sqlExecute);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getServicesForReadyTasks() throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<String> servicesList = new ArrayList<String>();
                try {
                    ps = TaskPersistLayer.prepareStatement(NCTaskQueueTable.SQL_GET_SERVICE_NAME);
                    ps.setInt(1, TaskQueueStatus.READY.getId());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String service = rs.getString(1);
                        if (null == service) continue;
                        servicesList.add(service.trim());
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return servicesList.toArray(new String[servicesList.size()]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTaskQueueTable.getServicesForReadyTasks");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            String[] stringArray = (String[])handler.execute(sqlExecute);
            return stringArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    private static class UpdateTaskRecordSQL
    implements SQLExecute {
        private String sql;
        private String[] fields;
        private SQLObject[] values;
        private SQLObject blobObject;
        private TaskRecord record;

        public UpdateTaskRecordSQL(TaskRecord record, String sql, String[] fields, SQLObject[] values, SQLObject blobObject) {
            this.sql = sql;
            this.fields = fields;
            this.values = values;
            this.blobObject = blobObject;
            this.record = record;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute() throws TaskPersistLayerException {
            PreparedStatement blobPs = null;
            int cols = 0;
            try {
                SqlUpdateVerb update = new SqlUpdateVerb();
                cols = update.execute(this.sql, this.fields, this.values);
                if (this.blobObject != null && this.blobObject.shouldUpdateBlob()) {
                    blobPs = TaskPersistLayer.prepareStatement(NCTaskQueueTable.TASK_BLOB_GET);
                    blobPs.setString(1, this.record.getTaskId().toString());
                    JDBCBlobUtil.getInstance("SDS").updateBlob(blobPs, ZipUtils.gzip(this.record.getRunSpec()));
                }
            }
            catch (Exception e) {
                TaskPersistLayer.throwException(e);
            }
            finally {
                TaskPersistLayer.closeStatement(blobPs);
            }
            return cols;
        }
    }
}

