/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.jdbc.util.JDBCBlobUtil;
import com.cognos.jsmcommon.util.ZipUtils;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class SQLObject {
    private Object _obj;
    private int _type;
    private boolean shouldUpdateBlob = false;

    public SQLObject(Object obj, int type) {
        this._obj = obj;
        this._type = type;
    }

    public SQLObject(String obj) {
        this._obj = obj;
        this._type = 1;
    }

    public SQLObject(int obj) {
        this._obj = new Integer(obj);
        this._type = 4;
    }

    public SQLObject(byte val) {
        this._obj = new Byte(val);
        this._type = 4;
    }

    public SQLObject(boolean val) {
        this._obj = val;
        this._type = 16;
    }

    public boolean shouldUpdateBlob() {
        return this.shouldUpdateBlob;
    }

    public void setValue(PreparedStatement ps, int index) throws SQLException, IOException {
        switch (this._type) {
            case 1: {
                if (this._obj != null) {
                    ps.setString(index, (String)this._obj);
                    break;
                }
                ps.setNull(index, 1);
                break;
            }
            case 4: {
                if (this._obj == null) break;
                if (this._obj instanceof Integer) {
                    ps.setInt(index, (Integer)this._obj);
                    break;
                }
                if (this._obj instanceof Long) {
                    ps.setLong(index, (Long)this._obj);
                    break;
                }
                if (this._obj instanceof Byte) {
                    ps.setByte(index, (Byte)this._obj);
                    break;
                }
                ps.setNull(index, 4);
                break;
            }
            case 16: {
                if (this._obj != null) {
                    ps.setBoolean(index, (Boolean)this._obj);
                    break;
                }
                ps.setNull(index, 16);
                break;
            }
            case 12: {
                if (this._obj != null) {
                    ps.setString(index, (String)this._obj);
                    break;
                }
                ps.setNull(index, 12);
                break;
            }
            case -2: {
                if (this._obj != null) {
                    this.shouldUpdateBlob = JDBCBlobUtil.getInstance("SDS").setBlob(ps, index, ZipUtils.gzip(this._obj));
                    break;
                }
                ps.setNull(index, -2);
                break;
            }
            default: {
                throw new SQLException("Type with integer value [" + this._type + "] is not supported by the SQLObject.setValue() method.");
            }
        }
    }

    public boolean equals(Object arg) {
        if (!(arg instanceof SQLObject)) {
            return false;
        }
        SQLObject other = (SQLObject)arg;
        if (null == this._obj ? null != other._obj : !this._obj.equals(other._obj)) {
            return false;
        }
        return this._type == other._type;
    }

    public int hashCode() {
        long code = this._obj.hashCode();
        return (int)(code * (long)this._type % Integer.MAX_VALUE);
    }
}

