/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.tse.SQLObject;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SqlUpdateVerb {
    String set;
    JDBCConnection db = TaskPersistLayer.getConnection();
    public static Object binaryNull = new Object();

    SqlUpdateVerb() throws TaskPersistLayerException {
    }

    public PreparedStatement prepare(String sql, String field, SQLObject[] values) throws TaskPersistLayerException {
        PreparedStatement ps = null;
        try {
            String sqlToUse = field == null ? sql : SqlUpdateVerb.plugSql(sql, field);
            ps = this.db.prepareStatement(sqlToUse);
            for (int i = 0; i != values.length; ++i) {
                values[i].setValue(ps, i + 1);
            }
        }
        catch (SQLException e) {
            throw new TaskPersistLayerException(e);
        }
        catch (IOException e) {
            throw new TaskPersistLayerException(e);
        }
        return ps;
    }

    public int execute(String sql, String field, SQLObject[] values) throws TaskPersistLayerException {
        PreparedStatement ps = null;
        int count = 0;
        try {
            ps = this.prepare(sql, field, values);
            count = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new TaskPersistLayerException(e);
            }
            catch (Throwable throwable) {
                TaskPersistLayer.closeStatement(ps);
                throw throwable;
            }
        }
        TaskPersistLayer.closeStatement(ps);
        return count;
    }

    public Object query(String sql, String field, SQLObject[] values, ProcessResultSet cmd) throws TaskPersistLayerException {
        Object result;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.prepare(sql, field, values);
            rs = ps.executeQuery();
            result = cmd.process(rs);
        }
        catch (SQLException e) {
            try {
                throw new TaskPersistLayerException(e);
            }
            catch (Throwable throwable) {
                TaskPersistLayer.closeStatement(ps, rs);
                throw throwable;
            }
        }
        TaskPersistLayer.closeStatement(ps, rs);
        return result;
    }

    int execute(String sql, String[] fields, SQLObject[] values) throws TaskPersistLayerException {
        String prepareSql = sql;
        if (fields != null && fields.length != 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("SET ");
            for (int i = 0; i != fields.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(fields[i]);
                sb.append("=?");
            }
            sb.append(' ');
            String setString = sb.toString();
            sb = new StringBuffer(sql);
            int pos = sb.indexOf("$$");
            sb.replace(pos, pos + 2, setString);
            prepareSql = sb.toString();
        }
        return this.execute(prepareSql, (String)null, values);
    }

    public static String plugSql(String sql, String field) {
        int n;
        StringBuffer sb = new StringBuffer(sql);
        while ((n = sb.indexOf("$$")) != -1) {
            sb.replace(n, n + 2, field);
        }
        return sb.toString();
    }

    public static interface ProcessResultSet {
        public Object process(ResultSet var1) throws SQLException;
    }
}

