/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskPropertyRecord;
import com.cognos.jsmcommon.util.HashList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class TaskDependencies {
    HashList m_dependencies = new HashList();
    HashMap m_id_relationship = new HashMap();

    public void addDependency(String parent, String[] dependents) {
        if (parent == null || dependents == null || dependents.length == 0) {
            return;
        }
        this.m_dependencies.put(parent, Arrays.asList(dependents));
    }

    public void resolveId(String id, TaskID realId) {
        if (id == null || realId == null) {
            return;
        }
        this.m_id_relationship.put(id, realId);
    }

    public void storeDependencies() throws TaskPersistLayerException {
        for (String key : this.m_dependencies.keySet()) {
            List dependents;
            TaskID keyId;
            if (key == null || (keyId = (TaskID)this.m_id_relationship.get(key)) == null || (dependents = this.m_dependencies.get(key)) == null) continue;
            for (String dependent : dependents) {
                TaskID dependentId;
                if (dependent == null || (dependentId = (TaskID)this.m_id_relationship.get(dependent)) == null) continue;
                TaskPropertyRecord.addProperty(keyId, dependentId.getID(), null);
            }
        }
    }

    public static TaskID[] retrieveDependencies(TaskID id) throws TaskPersistLayerException {
        ParameterValue[] values = TaskPropertyRecord.getAllValues(id);
        ArrayList<TaskID> ids = new ArrayList<TaskID>();
        for (int i = 0; i < values.length; ++i) {
            if (!TaskID.isTSEID(values[i].getName())) continue;
            ids.add(new TaskID(values[i].getName()));
        }
        return ids.toArray(new TaskID[ids.size()]);
    }
}

