/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnumProp;
import com.cognos.jsmcommon.jdbc.util.JDBCBlobUtil;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandler;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.NCTaskHistorySubIndexTable;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.SQLParserUtils;
import com.cognos.jsmcommon.util.ZipUtils;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

public class TaskHistoryDetailRecord {
    private TaskID _id;
    private static final String INSERT_DETAIL_SQL = "INSERT INTO NC_TASK_HISTORY_DETAIL(TASK_ID, SUB_INDEX, SEVERITY, CLASSTYPE, TASK, STATUS) VALUES (?,?,?,?,?,?)";
    private static final String TASK_BLOB_GET = "SELECT TASK FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID=? AND SUB_INDEX=? FOR UPDATE";
    private static final String SELECT_ALL = "SELECT TASK FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID=?";
    private static final String SELECT_ALL_BY_CLASS = "SELECT TASK FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID=? AND CLASSTYPE = ?";
    private static final String SELECT_ALL_BY_SEVERITY = "SELECT TASK FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID=? AND SEVERITY = ?";
    private static final String SELECT_ALL_BY_SEVERITY_BY_CLASS = "SELECT TASK FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID=? AND SEVERITY = ? AND CLASSTYPE = ?";
    private static final String COUNT_ALL_BY_STATUS = "SELECT COUNT(*) FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID=? AND STATUS = ?";
    protected static final String DELETE_SQL = "DELETE FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID=?";
    private static final String DELETE_RECORD = "DELETE FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID=? AND SUB_INDEX=?";
    private static final String DELETE_IN_SQL = "DELETE FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID ";
    private static final String COUNT_SQL = "SELECT COUNT(*) FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID = ?";
    static final String UPDATE_SQL = "UPDATE NC_TASK_HISTORY_DETAIL SET STATUS=? WHERE TASK_ID=? AND SUB_INDEX=?";
    private static final int DEBUG = 1;
    private static final int INFO = 2;
    private static final int WARN = 3;
    private static final int ERROR = 4;
    private static final int FATAL = 5;
    private Comparator<BaseHistoryDetail> m_detailComparator;

    public TaskHistoryDetailRecord(TaskID id) {
        this._id = id;
    }

    public TaskHistoryDetailRecord(TaskID id, Comparator<BaseHistoryDetail> detailComparator) {
        this._id = id;
        this.m_detailComparator = detailComparator;
    }

    public static SeverityEnum getSeverityEnum(int value) {
        switch (value) {
            case 1: {
                return SeverityEnum.debug;
            }
            case 2: {
                return SeverityEnum.info;
            }
            case 3: {
                return SeverityEnum.warn;
            }
            case 4: {
                return SeverityEnum.error;
            }
            case 5: {
                return SeverityEnum.fatal;
            }
        }
        return null;
    }

    private int getSeverityInt(SeverityEnumProp enumProp) {
        int val = -1;
        if (enumProp == null) {
            return val;
        }
        SeverityEnum enumVal = enumProp.getValue();
        if (enumVal != null) {
            if (SeverityEnum.debug.equals((Object)enumVal)) {
                val = 1;
            } else if (SeverityEnum.info.equals((Object)enumVal)) {
                val = 2;
            } else if (SeverityEnum.warn.equals((Object)enumVal)) {
                val = 3;
            } else if (SeverityEnum.error.equals((Object)enumVal)) {
                val = 4;
            } else if (SeverityEnum.fatal.equals((Object)enumVal)) {
                val = 5;
            }
        }
        return val;
    }

    public Integer[] store(BaseHistoryDetail[] detail) throws TaskPersistLayerException {
        byte a = 0;
        return this.store(detail, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer[] store(BaseHistoryDetail[] detail, byte status) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskHistoryDetailRecord.store");
        try {
            StoreSQLExecute storeSQLExecute = new StoreSQLExecute(detail, status);
            SQLTransactionExecuteHandler handler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
            handler.execute(storeSQLExecute);
            Integer[] integerArray = storeSQLExecute.getIndexes();
            return integerArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseHistoryDetail[] readAll(final SeverityEnumProp enumProp, final Class<? extends BaseHistoryDetail> objectClass) throws TaskPersistLayerException {
        if (objectClass == null && enumProp == null) {
            return this.readAll();
        }
        if (objectClass == null) {
            return this.readAll(enumProp);
        }
        if (enumProp == null) {
            return this.readAll(objectClass);
        }
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                BaseHistoryDetail[] details = new BaseHistoryDetail[]{};
                PreparedStatement ps = null;
                ResultSet detailRS = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.SELECT_ALL_BY_SEVERITY_BY_CLASS);
                    ps.setString(1, TaskHistoryDetailRecord.this._id.toString());
                    ps.setInt(2, TaskHistoryDetailRecord.this.getSeverityInt(enumProp));
                    ps.setString(3, objectClass.getName());
                    detailRS = ps.executeQuery();
                    details = TaskHistoryDetailRecord.this.readRS(detailRS);
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, detailRS);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, detailRS);
                return details;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskHistoryDetailRecord.readAll(enumProp,objectClass)");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            BaseHistoryDetail[] baseHistoryDetailArray = (BaseHistoryDetail[])handler.execute(sqlExecute);
            return baseHistoryDetailArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseHistoryDetail[] readAll(final SeverityEnumProp enumProp) throws TaskPersistLayerException {
        if (enumProp == null) {
            return this.readAll();
        }
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                BaseHistoryDetail[] details = new BaseHistoryDetail[]{};
                PreparedStatement ps = null;
                ResultSet detailRS = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.SELECT_ALL_BY_SEVERITY);
                    ps.setString(1, TaskHistoryDetailRecord.this._id.toString());
                    ps.setInt(2, TaskHistoryDetailRecord.this.getSeverityInt(enumProp));
                    detailRS = ps.executeQuery();
                    details = TaskHistoryDetailRecord.this.readRS(detailRS);
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, detailRS);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, detailRS);
                return details;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskHistoryDetailRecord.readAll(enumProp)");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            BaseHistoryDetail[] baseHistoryDetailArray = (BaseHistoryDetail[])handler.execute(sqlExecute);
            return baseHistoryDetailArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseHistoryDetail[] readAll(final Class<? extends BaseHistoryDetail> objectClass) throws TaskPersistLayerException {
        if (objectClass == null) {
            return this.readAll();
        }
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                BaseHistoryDetail[] details = new BaseHistoryDetail[]{};
                PreparedStatement ps = null;
                ResultSet detailRS = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.SELECT_ALL_BY_CLASS);
                    ps.setString(1, TaskHistoryDetailRecord.this._id.toString());
                    ps.setString(2, objectClass.getName());
                    detailRS = ps.executeQuery();
                    details = TaskHistoryDetailRecord.this.readRS(detailRS);
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, detailRS);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, detailRS);
                return details;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskHistoryDetailRecord.readAll(objectClass)");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            BaseHistoryDetail[] baseHistoryDetailArray = (BaseHistoryDetail[])handler.execute(sqlExecute);
            return baseHistoryDetailArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseHistoryDetail[] readAll() throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                BaseHistoryDetail[] details = new BaseHistoryDetail[]{};
                PreparedStatement ps = null;
                ResultSet detailRS = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.SELECT_ALL);
                    ps.setString(1, TaskHistoryDetailRecord.this._id.toString());
                    detailRS = ps.executeQuery();
                    details = TaskHistoryDetailRecord.this.readRS(detailRS);
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, detailRS);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, detailRS);
                return details;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskHistoryDetailRecord.readAll");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            BaseHistoryDetail[] baseHistoryDetailArray = (BaseHistoryDetail[])handler.execute(sqlExecute);
            return baseHistoryDetailArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet dracula = null;
                int count = 0;
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.COUNT_SQL);
                    ps.setString(1, TaskHistoryDetailRecord.this._id.toString());
                    dracula = ps.executeQuery();
                    if (dracula.next()) {
                        count = dracula.getInt(1);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, dracula);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, dracula);
                return count;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskHistoryDetailRecord.count");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            int n = (Integer)handler.execute(sqlExecute);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countByStatus(final byte status) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet dracula = null;
                int count = 0;
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.COUNT_ALL_BY_STATUS);
                    ps.setString(1, TaskHistoryDetailRecord.this._id.toString());
                    ps.setInt(2, status);
                    dracula = ps.executeQuery();
                    if (dracula.next()) {
                        count = dracula.getInt(1);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, dracula);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, dracula);
                return count;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskHistoryDetailRecord.countByStatus");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            int n = (Integer)handler.execute(sqlExecute);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    private BaseHistoryDetail[] readRS(ResultSet detailRS) throws TaskPersistLayerException {
        ArrayList<BaseHistoryDetail> detailList = new ArrayList<BaseHistoryDetail>();
        try {
            while (detailRS != null && detailRS.next()) {
                InputStream is = detailRS.getBinaryStream(1);
                if (is == null) continue;
                BaseHistoryDetail detail = (BaseHistoryDetail)ZipUtils.gunzip(is);
                detailList.add(detail);
                is.close();
            }
        }
        catch (SQLException ex) {
            throw new TaskPersistLayerException(ex);
        }
        catch (IOException ex) {
            throw new TaskPersistLayerException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new TaskPersistLayerException(ex);
        }
        BaseHistoryDetail[] details = detailList.toArray(new BaseHistoryDetail[detailList.size()]);
        if (this.m_detailComparator != null) {
            Arrays.sort(details, this.m_detailComparator);
        }
        return details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.DELETE_SQL);
                    ps.setString(1, TaskHistoryDetailRecord.this._id.toString());
                    ps.executeUpdate();
                    Object var2_2 = null;
                    return var2_2;
                }
                catch (SQLException e) {
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps);
                }
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskHistoryDetailRecord.delete");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
            handler.execute(sqlExecute);
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(final int subIndex) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.DELETE_RECORD);
                    ps.setString(1, TaskHistoryDetailRecord.this._id.toString());
                    ps.setInt(2, subIndex);
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps);
                }
                return null;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskHistoryDetailRecord.deleteRecord");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
            handler.execute(sqlExecute);
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAll(final String[] tasks) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                if (tasks == null || tasks.length == 0) {
                    return null;
                }
                PreparedStatement ps = null;
                try {
                    String[] inClauses = SQLParserUtils.createInClauses(tasks, true);
                    for (int i = 0; i < inClauses.length; ++i) {
                        ps = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.DELETE_IN_SQL + inClauses[i]);
                        ps.executeUpdate();
                    }
                }
                catch (SQLException e) {
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps);
                }
                return null;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskHistoryDetailRecord.deleteAll");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
            handler.execute(sqlExecute);
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(final int index, final byte status) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.UPDATE_SQL);
                    ps.setInt(1, status);
                    ps.setString(2, TaskHistoryDetailRecord.this._id.toString());
                    ps.setInt(3, index);
                    ps.executeUpdate();
                    Object var2_2 = null;
                    return var2_2;
                }
                catch (SQLException e) {
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps);
                }
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskHistoryDetailRecord.setStatus");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
            handler.execute(sqlExecute);
        }
        finally {
            zipiTimer.stop();
        }
    }

    private class StoreSQLExecute
    implements SQLExecute {
        private BaseHistoryDetail[] detail;
        private byte status;
        private Integer[] theIndexes;

        public StoreSQLExecute(BaseHistoryDetail[] detail, byte status) {
            this.detail = detail;
            this.status = status;
            this.theIndexes = new Integer[detail.length];
        }

        public Integer[] getIndexes() {
            return this.theIndexes;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object execute() throws TaskPersistLayerException {
            PreparedStatement ps = null;
            int index = 0;
            int counter = 0;
            if (this.detail == null) {
                return null;
            }
            PreparedStatement blobPs = null;
            try {
                NCTaskHistorySubIndexTable thsiTable = new NCTaskHistorySubIndexTable();
                index = thsiTable.getNextSubIndex(TaskHistoryDetailRecord.this._id);
                ps = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.INSERT_DETAIL_SQL);
                blobPs = TaskPersistLayer.prepareStatement(TaskHistoryDetailRecord.TASK_BLOB_GET);
                for (int i = 0; i < this.detail.length; ++index, ++counter, ++i) {
                    ps.setString(1, TaskHistoryDetailRecord.this._id.toString());
                    ps.setInt(2, index);
                    ps.setInt(3, TaskHistoryDetailRecord.this.getSeverityInt(this.detail[i].getSeverity()));
                    Class<?> clazz = this.detail[i].getClass();
                    String fullClass = clazz.getName();
                    ps.setString(4, fullClass);
                    ps.setInt(6, this.status);
                    byte[] bytes = ZipUtils.gzip(this.detail[i]);
                    boolean shouldUpdateBlob = true;
                    shouldUpdateBlob = JDBCBlobUtil.getInstance("SDS").setBlob(ps, 5, bytes);
                    int insertedRows = ps.executeUpdate();
                    if (insertedRows > 0 && shouldUpdateBlob) {
                        blobPs.setString(1, TaskHistoryDetailRecord.this._id.toString());
                        blobPs.setInt(2, index);
                        JDBCBlobUtil.getInstance("SDS").updateBlob(blobPs, bytes);
                    }
                    this.theIndexes[counter] = new Integer(index);
                }
            }
            catch (SQLException e) {
                try {
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("SQL Error storing history detail:" + e.getMessage());
                    throw new TaskPersistLayerException(e);
                    catch (IOException e2) {
                        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("IO Error storing history detail:" + e2.getMessage());
                        throw new TaskPersistLayerException(e2);
                    }
                }
                catch (Throwable throwable) {
                    TaskPersistLayer.closeStatement(ps);
                    TaskPersistLayer.closeStatement(blobPs);
                    blobPs = null;
                    throw throwable;
                }
            }
            TaskPersistLayer.closeStatement(ps);
            TaskPersistLayer.closeStatement(blobPs);
            return null;
        }
    }

    public static class DetailTimeSorter
    implements Comparator<BaseHistoryDetail> {
        private boolean m_ascending = true;

        public DetailTimeSorter(boolean isAscending) {
            this.m_ascending = isAscending;
        }

        @Override
        public int compare(BaseHistoryDetail bhd0, BaseHistoryDetail bhd1) {
            if (!this.m_ascending) {
                BaseHistoryDetail tmp = bhd0;
                bhd0 = bhd1;
                bhd1 = tmp;
            }
            Date bhd0detailTime = null;
            Date bhd1detailTime = null;
            if (bhd0.getDetailTime() != null && bhd0.getDetailTime().getValue() != null) {
                bhd0detailTime = bhd0.getDetailTime().getValue().getTime();
            }
            if (bhd1.getDetailTime() != null && bhd1.getDetailTime().getValue() != null) {
                bhd1detailTime = bhd1.getDetailTime().getValue().getTime();
            }
            int result = 0;
            if (bhd0detailTime != null && bhd1detailTime != null) {
                result = bhd0detailTime.compareTo(bhd1detailTime);
            } else if (bhd0detailTime != null && bhd1detailTime == null) {
                result = 1;
            } else if (bhd0detailTime == null && bhd1detailTime != null) {
                result = -1;
            }
            return result;
        }
    }
}

