/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.objectid.GuidIdGenerator;
import com.cognos.jsmcommon.tse.SQLObject;
import com.cognos.jsmcommon.util.HexFormatter;
import com.cognos.jsmcommon.util.Validate;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

public final class TaskID
implements Serializable {
    private static final long serialVersionUID = 70009003L;
    String uuid;

    public static synchronized TaskID create(String guid) throws IllegalArgumentException {
        if (guid == null) {
            throw new IllegalArgumentException();
        }
        TaskID taskID = new TaskID(guid);
        return taskID;
    }

    public static synchronized TaskID create() {
        String stub = GuidIdGenerator.createNew().toString();
        String guid = TaskID.makeEventIdString(stub, new Date());
        return TaskID.create(guid);
    }

    public static String makeEventIdString(String guid, Date date) {
        String ret_value = guid + (date != null ? HexFormatter.toHex(date.getTime(), 13) : HexFormatter.toHex(new Date().getTime(), 13));
        if (ret_value == null || !TaskID.isTSEID(ret_value)) {
            throw new RuntimeException(I18NUtil.getMessage(I18NCode.EVENT_ID_INVALID, Locale.getDefault()));
        }
        return ret_value;
    }

    public TaskID(String id) {
        Validate.isTrue(TaskID.isTSEID(id));
        this.uuid = id;
    }

    public String getID() {
        return this.uuid;
    }

    public SQLObject getSqlValue() {
        return new SQLObject(this.uuid, 1);
    }

    public String toString() {
        return this.uuid;
    }

    public static TaskID fromEventId(String eventId) throws IllegalArgumentException {
        if (eventId == null) {
            throw new IllegalArgumentException();
        }
        Validate.isTrue(TaskID.isTSEID(eventId));
        return new TaskID(eventId);
    }

    public static boolean isTSEID(String eventId) {
        boolean isValid = eventId.length() == 45;
        return isValid && GuidIdGenerator.validOidString(eventId.substring(0, 32));
    }

    public String toEventId() {
        return this.uuid;
    }

    public boolean equals(Object obj) {
        boolean isEqual = obj instanceof TaskID;
        if (isEqual) {
            TaskID otherId = (TaskID)obj;
            isEqual = otherId != null && otherId.uuid != null && otherId.uuid.equals(this.uuid);
        }
        return isEqual;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

