/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.developer.schemas.bibus._3.AsynchOption;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.JDBCUtils;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.sql.util.BatchPreparedStatement;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandler;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.BiBusSpec;
import com.cognos.jsmcommon.tse.BulkTaskRecords;
import com.cognos.jsmcommon.tse.NCTSEStateMapTable;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.SQLObject;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.SqlUpdateVerb;
import com.cognos.jsmcommon.tse.TaskAncestorsTable;
import com.cognos.jsmcommon.tse.TaskDependencies;
import com.cognos.jsmcommon.tse.TaskHistoryDetailRecord;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskPropertyRecord;
import com.cognos.jsmcommon.tse.TaskQueueMetrics;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStateTable;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.tse.TaskTable;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.Validate;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class TaskPersistLayer {
    static ThreadLocal<JDBCConnection> dbcon = new ThreadLocal();
    static ThreadLocal<JDBCConnection> trancon = new ThreadLocal();
    static TaskPersistLayer instance = new TaskPersistLayer();
    static String serverInst;

    public static TaskPersistLayer getInstance() {
        return instance;
    }

    TaskPersistLayer() {
        serverInst = SDSInstanceManager.getInstance().getThisInstance().getGuid();
    }

    public TaskRecords addTasks(TaskID parentID, SequenceSpec[] spec) throws TaskPersistLayerException {
        TaskRecords taskRecord = this.addTasks(parentID, spec, true);
        return taskRecord;
    }

    public TaskRecords[] addTasksAndReturnAll(TaskID parentID, SequenceSpec[] spec, boolean background, boolean makeHeirachyId) throws TaskPersistLayerException {
        TaskRecords[] newTasks;
        try {
            BiBusSpec.initialiseHeaders(parentID, spec);
            boolean seqOnEnd = false;
            int seqCount = 1;
            int nextSeqId = 1;
            TaskID heirachyId = null;
            if (makeHeirachyId && spec.length > 1) {
                heirachyId = TaskID.create();
            }
            for (int i = 0; i < spec.length; ++i) {
                if (spec[i].getSeqType() == SequenceSpec.SEQ_NEW && i > 0) {
                    Validate.isTrue(++seqCount != 30000);
                    continue;
                }
                if (spec[i].getSeqType() != SequenceSpec.SEQ_ON_FAILED && spec[i].getSeqType() != SequenceSpec.SEQ_ON_FINISHED && spec[i].getSeqType() != SequenceSpec.SEQ_ON_SUCCEEDED) continue;
                seqOnEnd = true;
            }
            if (parentID != null) {
                parentID = TaskPersistLayer.resolveRestartId(parentID);
                nextSeqId = TaskStateRecord.getSeqCount(parentID) + 1;
            }
            if (!background) {
                Validate.isTrue(spec.length == 1);
            }
            AddSQLExecute sqlExec = new AddSQLExecute(parentID, background, seqOnEnd, seqCount, spec, nextSeqId, makeHeirachyId, heirachyId);
            SQLTransactionExecuteHandler handler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
            handler.execute(sqlExec);
            newTasks = sqlExec.getTaskRecords();
            if (TaskQueueMetrics.getInstance().tideMetricsActive()) {
                int count = TaskPersistLayer.getInstance().getCountQueuedAndReadyTasks();
                TaskQueueMetrics.getInstance().updateQueueLengthHighWaterMark(count);
            }
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.addTasksAndReturnAll: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
        return newTasks;
    }

    public TaskRecords addTasks(TaskID parentID, SequenceSpec[] spec, boolean background) throws TaskPersistLayerException {
        TaskRecords[] newTasks = this.addTasksAndReturnAll(parentID, spec, background, false);
        return newTasks[0];
    }

    public Integer[] addInactiveTaskDetails(TaskID taskID, BaseHistoryDetail[] details) throws TaskPersistLayerException {
        try {
            TaskHistoryDetailRecord record = new TaskHistoryDetailRecord(taskID);
            return record.store(details, TaskStatus.INACTIVE.getId());
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.addInactiveTaskDetails: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    public Integer[] addTaskDetails(TaskID taskID, BaseHistoryDetail[] details) throws TaskPersistLayerException {
        try {
            TaskHistoryDetailRecord record = new TaskHistoryDetailRecord(taskID);
            return record.store(details);
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.addTaskDetails: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    public static TaskID resolveRestartId(TaskID taskId) throws TaskPersistLayerException {
        try {
            if (taskId == null) {
                return null;
            }
            return NCTaskQueueTable.getInstance().findTaskID(taskId);
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.resolveRestartId: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    public TaskID resolveTaskId(TaskID potentialRestartId) throws TaskPersistLayerException {
        try {
            return NCTaskQueueTable.getInstance().findRestartID(potentialRestartId);
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.resolveTaskId: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    public boolean deleteRecords(TaskID id) throws TaskPersistLayerException {
        try {
            DeleteRecordsSQL deleteRecords = new DeleteRecordsSQL(id);
            if (TaskPersistLayer.inTransaction()) {
                deleteRecords.execute();
            } else {
                SQLTransactionExecuteHandler transHandler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
                transHandler.execute(deleteRecords);
            }
            return deleteRecords.getDeleted();
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.deleteRecords: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRecords(TaskID[] ids) throws SQLException, TaskPersistLayerException {
        boolean allOK;
        block21: {
            int i;
            if (null == ids || 0 == ids.length) {
                return true;
            }
            JDBCConnection conn = null;
            allOK = true;
            boolean newTransaction = false;
            BatchPreparedStatement[] bps = null;
            String[] stmts = new String[]{"DELETE FROM NC_TSE_STATE_MAP WHERE TASK_ID=?", "DELETE FROM NC_TASK_QUEUE WHERE TASK_ID=?", "DELETE FROM NC_TASK_ANCESTOR_STOREIDS WHERE TASK_ID=?", "DELETE FROM NC_TASK_PROPERTY WHERE TASK_ID=?", "DELETE FROM NC_TASK_HISTORY_DETAIL WHERE TASK_ID=?", "DELETE FROM NC_TASK_HISTORY_SUB_INDEX WHERE TASK_ID=?"};
            ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskPersistLayer.deleteRecords(TaskID[])");
            try {
                if (!TaskPersistLayer.inTransaction()) {
                    newTransaction = true;
                    TaskPersistLayer.startTransaction();
                }
                conn = TaskPersistLayer.getTransactionConnection();
                bps = new BatchPreparedStatement[stmts.length];
                for (i = 0; i < stmts.length; ++i) {
                    bps[i] = new BatchPreparedStatement(conn, stmts[i]);
                }
                for (TaskID taskId : ids) {
                    String strId = taskId.getID();
                    for (i = 0; i < bps.length; ++i) {
                        bps[i].setString(1, strId);
                        bps[i].addBatch();
                    }
                }
                block14: for (i = 0; i < bps.length; ++i) {
                    int[] updated = bps[i].executeBatch();
                    for (int j = 0; j < updated.length; ++j) {
                        if (1 == updated[j] || -2 == updated[j]) continue;
                        allOK = false;
                        continue block14;
                    }
                }
                if (!newTransaction) break block21;
                try {
                    TaskPersistLayer.commitTransaction();
                    newTransaction = false;
                }
                finally {
                    TaskPersistLayer.closeTransactionConnection();
                }
            }
            finally {
                if (newTransaction) {
                    try {
                        TaskPersistLayer.rollbackTransaction();
                    }
                    finally {
                        TaskPersistLayer.closeTransactionConnection();
                    }
                }
                if (null != bps) {
                    for (i = 0; i < bps.length; ++i) {
                        if (null == bps[i]) continue;
                        bps[i].close();
                    }
                }
                zipiTimer.stop();
            }
        }
        return allOK;
    }

    public boolean deleteRecordsIncludingChildren(TaskID[] taskIds) throws TaskPersistLayerException {
        boolean allOK = true;
        for (int i = 0; i < taskIds.length; ++i) {
            TaskID[] childIds = NCTSEStateMapTable.getInstance().getChildTaskIds(taskIds[i], null);
            if (childIds == null || childIds.length <= 0 || this.deleteRecordsIncludingChildren(childIds)) continue;
            allOK = false;
        }
        try {
            if (!this.deleteRecords(taskIds)) {
                allOK = false;
            }
        }
        catch (SQLException exc) {
            exc.printStackTrace();
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.deleteRecordsIncludingChildren: " + exc.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(exc, true);
            TaskPersistLayer.throwException(exc);
        }
        return allOK;
    }

    public TaskID getNextTaskFromQueue(String serviceName, String serverGroup) throws TaskPersistLayerException {
        return NCTaskQueueTable.getInstance().getNextTaskFromQueue(serviceName, serverGroup);
    }

    public int getCountPendingTasks(TaskID parent) throws TaskPersistLayerException {
        try {
            return TaskStateTable.getCountChildren(TaskStatus.PENDING, null, parent);
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.getCountFailedTasks: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    public int getCountFailedTasks(TaskID parent) throws TaskPersistLayerException {
        try {
            return TaskStateTable.getCountChildren(TaskStatus.FAILED, TaskStatus.TERMINATED, parent);
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.getCountFailedTasks: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    public int getCountCompletedTasks(TaskID parent) throws TaskPersistLayerException {
        try {
            return TaskStateTable.getCountChildren(TaskStatus.COMPLETED, null, parent);
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.getCountCompletedTasks: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    public int getCountReadyTasks() throws TaskPersistLayerException {
        try {
            return NCTaskQueueTable.getInstance().getCountTasks(TaskQueueStatus.READY);
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.getCountReadyTasks: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    public int getCountQueuedAndReadyTasks() throws TaskPersistLayerException {
        try {
            TaskQueueStatus[] statii = new TaskQueueStatus[]{TaskQueueStatus.QUEUED, TaskQueueStatus.READY};
            return NCTaskQueueTable.getInstance().getCountTasks(statii);
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.getCountQueuedAndReadyTasks: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    public static String getEventID(Option[] options, AsynchOptionEnum xenum) {
        String eventID = null;
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                AsynchOption temp;
                if (!(options[i] instanceof AsynchOption) || !AsynchOptionEnum.runContext.equals((Object)(temp = (AsynchOption)options[i]).getName())) continue;
                AsynchOptionStringArray ids = (AsynchOptionStringArray)temp;
                eventID = ids.getValue()[ids.getValue().length - 1];
                break;
            }
        }
        return eventID;
    }

    public static String getSdsInstance() {
        return serverInst;
    }

    public static PreparedStatement prepareStatement(String sql) throws TaskPersistLayerException, SQLException {
        return TaskPersistLayer.getConnection().prepareStatement(sql);
    }

    public int execute(final String sql, final String field, final SQLObject[] values) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                int count = 0;
                try {
                    SqlUpdateVerb update = new SqlUpdateVerb();
                    count = update.execute(sql, field, values);
                }
                catch (TaskPersistLayerException e) {
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.execute: " + e.getLocalizedMessage());
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
                    throw e;
                }
                return count;
            }
        };
        SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
        return (Integer)handler.execute(sqlExecute);
    }

    public static void checkCloseConnection() {
        if (dbcon.get() != null) {
            try {
                NCConnection.instance().getConnectionFactory().releaseConnection(dbcon.get());
            }
            catch (SQLException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            }
            finally {
                dbcon.set(null);
            }
        }
    }

    public static JDBCConnection getConnection() throws TaskPersistLayerException {
        if (dbcon.get() == null) {
            if (trancon.get() != null) {
                return trancon.get();
            }
            throw new TaskPersistLayerException(I18NCode.IO_DB_CONNECTION_ERROR);
        }
        return dbcon.get();
    }

    public static boolean checkCreateConnection(boolean readOnly, int isolationLevel) throws TaskPersistLayerException {
        JDBCConnection con = null;
        if (dbcon.get() != null) {
            throw new TaskPersistLayerException(I18NCode.IO_DB_CONNECTION_ERROR);
        }
        if (trancon.get() == null) {
            try {
                if (readOnly) {
                    if (isolationLevel != -1) {
                        con = NCConnection.instance().getConnectionFactory().createReadOnlyConnection(isolationLevel);
                        dbcon.set(con);
                    } else {
                        con = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
                        dbcon.set(con);
                    }
                } else {
                    con = NCConnection.instance().getConnectionFactory().createConnection();
                    dbcon.set(con);
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.checkCreateConnection: " + e.getLocalizedMessage());
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
                TaskPersistLayer.throwException(e);
            }
        }
        return con != null;
    }

    private static JDBCConnection getTransactionConnection() {
        Validate.stateIsTrue(trancon.get() != null);
        return trancon.get();
    }

    public static void startTransaction() throws TaskPersistLayerException {
        TaskPersistLayer.createTransactionConnection();
    }

    public static void startTransaction(int isolationLevel) throws TaskPersistLayerException, SQLException {
        TaskPersistLayer.createTransactionConnection();
        TaskPersistLayer.getTransactionConnection().setAutoCommit(false);
    }

    public static void commitTransaction() throws TaskPersistLayerException, SQLException {
        JDBCUtils.comitTransaction(TaskPersistLayer.getTransactionConnection());
    }

    private static JDBCConnection createTransactionConnection() throws TaskPersistLayerException {
        JDBCConnection con = null;
        con = trancon.get();
        if (con != null) {
            throw new TaskPersistLayerException(I18NCode.IO_DB_CONNECTION_ERROR);
        }
        try {
            con = NCConnection.instance().getConnectionFactory().createConnection();
            trancon.set(con);
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.createTransactionConnection: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            TaskPersistLayer.throwException(e);
        }
        return con;
    }

    public static void closeTransactionConnection() {
        JDBCConnection con = null;
        con = trancon.get();
        if (con != null) {
            try {
                try {
                    con.setAutoCommit(true);
                }
                finally {
                    NCConnection.instance().getConnectionFactory().releaseConnection(trancon.get());
                }
            }
            catch (SQLException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.closeTransactionConnection: " + e.getLocalizedMessage());
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            }
            finally {
                trancon.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskToReadyStatus(final TaskRecord taskRecord) throws Exception {
        SQLExecute sqlExec = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                if (TaskStateRecord.updateStatus(taskRecord.getTaskId(), TaskStatus.READY, TaskStatus.PENDING) != 0) {
                    taskRecord.setStatus(TaskQueueStatus.READY);
                    taskRecord.setSdsInstanceId(null);
                    ArrayList<String> updateFields = new ArrayList<String>();
                    updateFields.add("STATUS");
                    updateFields.add("SDS_INSTANCE_ID");
                    taskRecord.update(updateFields.toArray(new String[0]));
                }
                return null;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskPersistLayer.setTaskToReadyStatus");
        try {
            SQLTransactionExecuteHandler handler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
            handler.execute(sqlExec);
        }
        finally {
            zipiTimer.stop();
        }
    }

    public static void rollbackTransaction() {
        try {
            JDBCConnection conn = TaskPersistLayer.getTransactionConnection();
            if (conn != null) {
                conn.rollback();
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.rollbackTransaction: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
        }
    }

    public static boolean inTransaction() {
        return trancon.get() != null;
    }

    public static void throwException(Exception e) throws TaskPersistLayerException {
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        if (e instanceof TaskPersistLayerException) {
            throw (TaskPersistLayerException)e;
        }
        throw new TaskPersistLayerException(e);
    }

    public static void closeStatement(PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.closeStatement: " + e.getLocalizedMessage());
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            }
        }
    }

    public static void closeStatement(PreparedStatement ps, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.closeStatement: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
        }
    }

    public static void closeStatement(Statement s, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (s != null) {
                s.close();
            }
        }
        catch (SQLException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.closeStatement: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
        }
    }

    public static TaskRecord getTaskFromEventId(String eventId) throws TaskPersistLayerException {
        try {
            TaskID task = TaskPersistLayer.resolveRestartId(TaskID.fromEventId(eventId));
            return NCTaskQueueTable.getInstance().find(task, false);
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.getTaskFromEventId: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    public static TaskStateRecord getTaskStateFromEventId(String eventId) throws TaskPersistLayerException {
        try {
            TaskStateRecord rec = null;
            TaskID task = TaskPersistLayer.resolveRestartId(TaskID.fromEventId(eventId));
            rec = new TaskStateRecord();
            if (!rec.find(task)) {
                rec = null;
            }
            return rec;
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.getTaskStateFromEventId: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    public static void setTaskPriority(TaskID taskId, int priority) throws TaskPersistLayerException {
        try {
            ArrayList<String> allTasks = new ArrayList<String>();
            TaskPersistLayer.getAllChildTasks(taskId, allTasks);
            if (!allTasks.isEmpty()) {
                String[] taskIDs = allTasks.toArray(new String[allTasks.size()]);
                NCTaskQueueTable.getInstance().setPriority(taskIDs, priority);
            }
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("TaskPersistLayer.setTaskPriority: " + e.getLocalizedMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e, true);
            throw e;
        }
    }

    private static void getAllChildTasks(TaskID taskId, ArrayList<String> tasks) throws TaskPersistLayerException {
        if (taskId != null) {
            tasks.add(taskId.getID());
            TaskStateTable.StepInfo[] children = TaskStateTable.getChildren(taskId, null);
            for (int i = 0; i < children.length; ++i) {
                TaskID childTask = children[i].taskId;
                if (tasks.contains(childTask)) continue;
                TaskPersistLayer.getAllChildTasks(childTask, tasks);
            }
        }
    }

    protected static void mock_setInstance(TaskPersistLayer value) {
        instance = value;
    }

    private class DeleteRecordsSQL
    implements SQLExecute {
        boolean deleted = false;
        TaskID id;

        DeleteRecordsSQL(TaskID id) {
            this.id = id;
        }

        public Object execute() throws TaskPersistLayerException {
            ZipiTimer zipiTimer = ZipiBridge.startTimer("DeleteRecordsSQL.execute");
            try {
                this.deleted = TaskStateTable.deleteTask(this.id) != 0;
                this.deleted = this.deleted && TaskTable.deleteTask(this.id) != 0;
                this.deleted = this.deleted && TaskAncestorsTable.deleteTask(this.id) != 0;
                TaskPropertyRecord.delete(this.id);
                TaskHistoryDetailRecord thdr = new TaskHistoryDetailRecord(this.id);
                thdr.delete();
            }
            finally {
                zipiTimer.stop();
            }
            return null;
        }

        public boolean getDeleted() {
            return this.deleted;
        }
    }

    private class AddSQLExecute
    implements SQLExecute {
        private boolean background;
        private boolean makeHeirachyId;
        private TaskID parentID;
        private TaskStateRecord childStateRecord;
        private TaskStateRecord.UpdateObject parentUpdateObject;
        private BulkTaskRecords bulkTaskRecords;
        private boolean seqOnEnd;
        private int seqCount;
        private SequenceSpec[] spec;
        private int nextSeqId;
        private TaskDependencies dependencies;
        private TaskQueueStatus status;
        private TaskID heirachyId;

        private AddSQLExecute(TaskID parentID, boolean background, boolean seqOnEnd, int seqCount, SequenceSpec[] spec, int nextSeqId, TaskDependencies dependencies, boolean makeHeirachyId, TaskID heirachyId, TaskStateRecord childStateRecord, BulkTaskRecords bulkTaskRecords) {
            this.parentID = parentID;
            this.background = background;
            this.seqOnEnd = seqOnEnd;
            this.seqCount = seqCount;
            this.spec = spec;
            this.nextSeqId = nextSeqId;
            this.dependencies = dependencies;
            this.makeHeirachyId = makeHeirachyId;
            this.heirachyId = heirachyId;
            this.childStateRecord = childStateRecord;
            this.bulkTaskRecords = bulkTaskRecords;
        }

        private AddSQLExecute(TaskID parentID, boolean background, boolean seqOnEnd, int seqCount, SequenceSpec[] spec, int nextSeqId, boolean makeHeirachyId, TaskID heirachyId) {
            this(parentID, background, seqOnEnd, seqCount, spec, nextSeqId, null, makeHeirachyId, heirachyId, null, new BulkTaskRecords());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute() throws TaskPersistLayerException {
            boolean storeDependencies = this.dependencies == null;
            ZipiTimer zipiTimer = ZipiBridge.startTimer("AddSQLExecute.execute");
            try {
                boolean isRecursiveCall;
                if (this.dependencies == null) {
                    this.dependencies = new TaskDependencies();
                }
                if (this.parentID != null) {
                    this.updateExistingParentRecord();
                } else if (this.childStateRecord != null) {
                    this.childStateRecord.updateFields(this.background, this.seqCount, this.seqOnEnd);
                }
                for (int i = 0; i != this.spec.length; ++i) {
                    this.dependencies.addDependency(this.spec[i].getId(), this.spec[i].getDependentIds());
                    int seqId = 0;
                    if (this.spec[i].getSeqType() == SequenceSpec.SEQ_ON_FAILED) {
                        seqId = 30100;
                    } else if (this.spec[i].getSeqType() == SequenceSpec.SEQ_ON_FINISHED) {
                        seqId = 30300;
                    } else if (this.spec[i].getSeqType() == SequenceSpec.SEQ_ON_SUCCEEDED) {
                        seqId = 30200;
                    } else if (this.spec[i].getSeqType() == SequenceSpec.SEQ_NEW && i != 0) {
                        ++this.nextSeqId;
                        seqId = this.nextSeqId;
                    } else {
                        seqId = this.nextSeqId;
                    }
                    TaskStateRecord state = new TaskStateRecord(this.spec[i], seqId, this.parentID, !this.background);
                    if (this.makeHeirachyId && this.heirachyId == null) {
                        this.heirachyId = state.taskID;
                    }
                    TaskRecord task = new TaskRecord(this.spec[i], state.taskID, this.parentID, null, !this.background);
                    this.bulkTaskRecords.add(new TaskRecords(task, state));
                    this.dependencies.resolveId(this.spec[i].getId(), state.taskID);
                    if (this.spec[i].getChildren().size() <= 0) continue;
                    this.addKids(state, this.background, this.spec[i].getChildren().toArray(new SequenceSpec[0]), this.dependencies, this.status);
                }
                if (storeDependencies) {
                    this.dependencies.storeDependencies();
                }
                boolean bl = isRecursiveCall = this.childStateRecord != null;
                if (!isRecursiveCall) {
                    this.bulkWriteTaskRecords();
                }
            }
            finally {
                zipiTimer.stop();
            }
            return null;
        }

        private void updateExistingParentRecord() throws TaskPersistLayerException {
            this.parentUpdateObject = new TaskStateRecord.UpdateObject(this.parentID);
            if (this.bulkTaskRecords.isPending(this.parentID)) {
                this.bulkTaskRecords.flush();
            }
            if (!this.background) {
                this.parentUpdateObject.runViaMS();
            } else {
                this.parentUpdateObject.incCountSeq(this.seqCount);
                if (this.seqOnEnd) {
                    this.parentUpdateObject.setSeqOnEnd(true);
                }
            }
            if (this.parentID != null) {
                this.parentUpdateObject.execute();
            }
        }

        private void bulkWriteTaskRecords() throws TaskPersistLayerException {
            this.bulkTaskRecords.flush();
        }

        private void addKids(TaskStateRecord state, boolean background, SequenceSpec[] spec, TaskDependencies dependencies, TaskQueueStatus status) throws TaskPersistLayerException {
            boolean seqOnEnd = false;
            int seqCount = 1;
            for (int j = 0; j < spec.length; ++j) {
                if (spec[j].getSeqType() == SequenceSpec.SEQ_NEW && j > 0) {
                    Validate.isTrue(++seqCount != 30000);
                    continue;
                }
                if (spec[j].getSeqType() != SequenceSpec.SEQ_ON_FAILED && spec[j].getSeqType() != SequenceSpec.SEQ_ON_FINISHED && spec[j].getSeqType() != SequenceSpec.SEQ_ON_SUCCEEDED) continue;
                seqOnEnd = true;
            }
            AddSQLExecute addKids = new AddSQLExecute(state.taskID, background, seqOnEnd, seqCount, spec, 1, dependencies, this.makeHeirachyId, this.heirachyId, state, this.bulkTaskRecords);
            addKids.execute();
        }

        public TaskRecords[] getTaskRecords() {
            return this.bulkTaskRecords.getWritten();
        }
    }

    public static class TaskRecords {
        public final TaskRecord taskRecord;
        public final TaskStateRecord taskStateRecord;

        TaskRecords(TaskRecord taskRecord, TaskStateRecord taskStateRecord) {
            this.taskRecord = taskRecord;
            this.taskStateRecord = taskStateRecord;
        }
    }
}

