/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskRecord;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class TaskPriorityQueue
extends TreeSet<TaskRecord.IDDateStruct> {
    private static final long serialVersionUID = 1L;
    private static Comparator<TaskRecord.IDDateStruct> customComparator = new Comparator<TaskRecord.IDDateStruct>(){

        @Override
        public int compare(TaskRecord.IDDateStruct task1, TaskRecord.IDDateStruct task2) {
            if (task1.id.getID().compareTo(task2.id.getID()) == 0) {
                return 0;
            }
            if (task1.priority == task2.priority) {
                if (task1.dateEntered == task2.dateEntered) {
                    return task1.id.getID().compareTo(task2.id.getID());
                }
                return task1.dateEntered < task2.dateEntered ? -1 : 1;
            }
            return task1.priority - task2.priority;
        }
    };

    public TaskPriorityQueue() {
        super(customComparator);
    }

    @Override
    public synchronized TaskRecord.IDDateStruct pollFirst() {
        return (TaskRecord.IDDateStruct)super.pollFirst();
    }

    public synchronized TaskRecord.IDDateStruct peek() {
        Iterator iter = this.iterator();
        if (iter.hasNext()) {
            return (TaskRecord.IDDateStruct)iter.next();
        }
        return null;
    }

    @Override
    public synchronized boolean add(TaskRecord.IDDateStruct idDateStruct) {
        if (idDateStruct != null && idDateStruct.id != null) {
            return super.add(idDateStruct);
        }
        return false;
    }

    public synchronized boolean updatePriority(TaskID taskId, int newPriority) {
        if (taskId == null) {
            return false;
        }
        TaskRecord.IDDateStruct newEle = null;
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            TaskRecord.IDDateStruct ele = (TaskRecord.IDDateStruct)iter.next();
            if (ele.id == null || !ele.id.getID().equalsIgnoreCase(taskId.getID())) continue;
            newEle = ele;
            newEle.priority = newPriority;
            iter.remove();
            break;
        }
        return this.add(newEle);
    }
}

