/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandler;
import com.cognos.jsmcommon.tse.SQLObject;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class TaskPropertyRecord {
    public TaskID taskID;
    public String name;
    public Object value;
    static final int MAX_SIZE_VALUE = 500;
    static final String ALL_COLUMNS = "TASK_ID,PROP_NAME,PROP_VALUE";
    static final String SQL_CREATE = "INSERT INTO NC_TASK_PROPERTY (TASK_ID,PROP_NAME,PROP_VALUE) values (?,?,?)";
    static final String SQL_GET_VALUES = "SELECT PROP_VALUE FROM NC_TASK_PROPERTY WHERE TASK_ID=? AND PROP_NAME=?";
    static final String SQL_GET_ALL_VALUES = "SELECT PROP_VALUE, PROP_NAME FROM NC_TASK_PROPERTY WHERE TASK_ID=?";
    static final String SQL_HAS_VALUES = "SELECT COUNT(TASK_ID) FROM NC_TASK_PROPERTY WHERE TASK_ID=?";
    static final String SQL_DELETE_ALL = "DELETE FROM NC_TASK_PROPERTY WHERE TASK_ID=?";
    static final String SQL_DELETE = "DELETE FROM NC_TASK_PROPERTY WHERE TASK_ID=? AND PROP_NAME=?";
    static final String SQL_SET_PROP = "UPDATE NC_TASK_PROPERTY SET PROP_VALUE=? WHERE TASK_ID=? AND PROP_NAME=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskPropertyRecord.SQL_CREATE);
                    ps.setString(1, TaskPropertyRecord.this.taskID.toString());
                    ps.setString(2, TaskPropertyRecord.this.name);
                    if (TaskPropertyRecord.this.value == null) {
                        ps.setNull(3, 12);
                    } else {
                        ps.setString(3, TaskPropertyRecord.this.value.toString());
                    }
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps);
                }
                return null;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskPropertyRecord.create");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, false);
            handler.execute(sqlExecute);
        }
        finally {
            zipiTimer.stop();
        }
    }

    static int delete(TaskID taskID) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskPropertyRecord.delete(TaskID)");
        try {
            int n = TaskPersistLayer.getInstance().execute(SQL_DELETE_ALL, null, new SQLObject[]{taskID.getSqlValue()});
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int delete(TaskID taskID, String propName) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskPropertyRecord.delete(TaskID, propName)");
        try {
            int n = TaskPersistLayer.getInstance().execute(SQL_DELETE, null, new SQLObject[]{taskID.getSqlValue(), new SQLObject(propName, 1)});
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperty(TaskID taskID, String name, Object value) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskPropertyRecord.setProperty");
        try {
            SQLObject[] params = new SQLObject[]{new SQLObject(value, 1), taskID.getSqlValue(), new SQLObject(name, 1)};
            if (TaskPersistLayer.getInstance().execute(SQL_SET_PROP, null, params) == 0) {
                TaskPropertyRecord.addProperty(taskID, name, value);
            }
        }
        finally {
            zipiTimer.stop();
        }
    }

    public static void addProperty(TaskID taskID, String name, Object value) throws TaskPersistLayerException {
        TaskPropertyRecord prop = new TaskPropertyRecord();
        prop.taskID = taskID;
        prop.name = name;
        prop.value = value;
        prop.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getValues(final TaskID taskID, final String propName) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<String> values = new ArrayList<String>();
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskPropertyRecord.SQL_GET_VALUES);
                    ps.setString(1, taskID.getID());
                    ps.setString(2, propName);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        values.add(rs.getString(1).trim());
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return values.toArray();
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskPropertyRecord.getValues(taskID, propName)");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            Object[] objectArray = (Object[])handler.execute(sqlExecute);
            return objectArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParameterValue[] getAllValues(final TaskID taskID) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskPropertyRecord.SQL_GET_ALL_VALUES);
                    ps.setString(1, taskID.getID());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String name = rs.getString(2);
                        String value = rs.getString(1);
                        values.add(ObjectModelUtil.makeParameterValue(name == null ? "" : name.trim(), value == null ? "" : value.trim()));
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return values.toArray(new ParameterValue[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskPropertyRecord.getValues(taskID)");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            ParameterValue[] parameterValueArray = (ParameterValue[])handler.execute(sqlExecute);
            return parameterValueArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countValues(final TaskID taskID) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                int count = 0;
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskPropertyRecord.SQL_HAS_VALUES);
                    ps.setString(1, taskID.getID());
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return count;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskPropertyRecord.countValues");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            int n = (Integer)handler.execute(sqlExecute);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    public static ParameterValue[] getParameterValues(TaskID taskID, String propName) throws TaskPersistLayerException {
        Object[] values = TaskPropertyRecord.getValues(taskID, propName);
        ParameterValue[] paramValues = new ParameterValue[values.length];
        for (int i = 0; i != values.length; ++i) {
            paramValues[i] = ObjectModelUtil.makeParameterValue(propName, values[i].toString());
        }
        return paramValues;
    }
}

