/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.developer.schemas.bibus._3.MonitorOptionGUID;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.BiBusSpec;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class TaskRecord {
    public static final TaskID RESTART_IGNORE_HISTORY_WRITE = new TaskID("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
    public static final String SERVER_GROUP = "SERVER_GROUP";
    public static final String SERVICE_NAME = "SERVICE_NAME";
    public static final String HISTORY_STORE_ID = "HISTORY_STORE_ID";
    public static final String STATUS = "STATUS";
    public static final String PRIORITY = "PRIORITY";
    public static final String RUN_SPEC = "TASK";
    public static final String SDS_INSTANCE_ID = "SDS_INSTANCE_ID";
    public static final String RESTART_ID = "RESTART_ID";
    public static final String TASK_ID = "TASK_ID";
    public static final String ACTUAL_EXECUTION_TIME = "ACTUAL_EXECUTION_TIME";
    public static final String DISPATCHER_ID = "DISPATCHER_ID";
    public static final String ACTUAL_COMPLETION_TIME = "ACTUAL_COMPLETION_TIME";
    public static final String DATE_ENTERED = "DATE_ENTERED";
    public static final String PROCESS_ID = "PROCESS_ID";
    public static final String TARGET_DISPATCHER_ID = "TARGET_DISPATCHER_ID";
    public static final String TENANT_ID = "TENANT_ID";
    private TaskID taskID;
    private String serverGroup;
    private String serviceName;
    private TaskQueueStatus status;
    private byte priority;
    private long timeStamp;
    private TaskRunSpec runSpec;
    private boolean stopOnError;
    private String historyStoreID;
    private String sdsInstanceID;
    private TaskID restartID;
    private long actualExecutionTime;
    private String dispatcherID;
    private int processID;
    private String scheduleTriggerName;
    private String scheduleType;
    private String accountPath;
    private String taskStoreID;
    private String objectClass;
    private long actualCompletionTime;
    private String[] ancestorStoreIDs;
    private String ownerStoreID;
    private String targetDispatcherID;
    private String tenantID;
    public transient List childTaskIDs;

    public TaskRecord() {
    }

    public TaskRecord(SequenceSpec spec, TaskID task, TaskID parent, TaskID restartID, boolean runViaMS) {
        this.setTimeStamp(new Date().getTime());
        this.setRunSpec(spec.getTask());
        this.setTaskId(task);
        this.setServerGroup(spec.getTask().serverGroup);
        this.setServiceName(spec.getTask().serviceName);
        this.setStatus(spec.getStatus() == null ? TaskQueueStatus.QUEUED : spec.getStatus());
        if (this.getRunSpec() != null && this.getRunSpec() instanceof BiBusRunSpec) {
            Option[] taskOptions;
            for (Option taskOption : taskOptions = ((BiBusRunSpec)this.getRunSpec()).options) {
                if (taskOption == null || !(taskOption instanceof MonitorOptionGUID) || !"dispatcherID".equals(((MonitorOptionGUID)taskOption).getName().getValue())) continue;
                this.setTargetDispatcherId(((MonitorOptionGUID)taskOption).getValue().get_value());
            }
        }
        this.setSdsInstanceId(runViaMS || parent == null ? TaskPersistLayer.getSdsInstance() : null);
        if (spec.getTask() instanceof BiBusSpec) {
            BiBusSpec busSpec = (BiBusSpec)spec.getTask();
            this.setAccountPath(busSpec.getAccountPath());
            this.setPriority(busSpec.priority);
        }
        if (spec.getTask() instanceof BiBusRunSpec) {
            BiBusRunSpec busRunSpec = (BiBusRunSpec)spec.getTask();
            this.setScheduleType(busRunSpec.scheduleType);
            this.setScheduleTriggerName(busRunSpec.scheduleTrigger);
            this.setTaskStoreId(busRunSpec.taskStoreID);
            this.setObjectClass(busRunSpec.objectClass);
            this.setAncestorStoreIds(busRunSpec.ancestorStoreIDs);
            this.setOwnerStoreId(busRunSpec.ownerPath);
            this.setTenantId(busRunSpec.tenantID);
            busRunSpec.ancestorStoreIDs = null;
            busRunSpec.ownerPath = null;
        }
        this.setRestartId(restartID);
    }

    public TaskRecord(SequenceSpec spec, TaskID task, TaskID parent, boolean runViaMS) {
        this(spec, task, parent, null, false);
    }

    public int update(String[] fields) throws TaskPersistLayerException {
        return NCTaskQueueTable.getInstance().update(this, fields);
    }

    public void create() throws TaskPersistLayerException {
        NCTaskQueueTable.getInstance().insertRecord(this);
    }

    public void setTaskId(TaskID taskID) {
        this.taskID = taskID;
    }

    public TaskID getTaskId() {
        return this.taskID;
    }

    public void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setStatus(TaskQueueStatus status) {
        this.status = status;
    }

    public TaskQueueStatus getStatus() {
        return this.status;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Date getTimeStampAsDate() {
        return new Date(this.timeStamp);
    }

    public void setRunSpec(TaskRunSpec runSpec) {
        this.runSpec = runSpec;
    }

    public TaskRunSpec getRunSpec() {
        return this.runSpec;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setHistoryStoreId(String historyStoreID) {
        this.historyStoreID = historyStoreID;
    }

    public String getHistoryStoreId() {
        return this.historyStoreID;
    }

    public void setSdsInstanceId(String sdsInstanceID) {
        this.sdsInstanceID = sdsInstanceID;
    }

    public String getSdsInstanceId() {
        return this.sdsInstanceID;
    }

    public void setRestartId(TaskID restartID) {
        this.restartID = restartID;
    }

    public TaskID getRestartId() {
        return this.restartID;
    }

    public void setActualExecutionTime(long value) {
        this.actualExecutionTime = value;
    }

    public long getActualExecutionTime() {
        return this.actualExecutionTime;
    }

    public Date getActualExecutionTimeAsDate() {
        return new Date(this.actualExecutionTime);
    }

    public void setDispatcherId(String dispatcherID) {
        this.dispatcherID = dispatcherID;
    }

    public String getDispatcherId() {
        return this.dispatcherID;
    }

    public void setProcessId(int processID) {
        this.processID = processID;
    }

    public int getProcessId() {
        return this.processID;
    }

    public void setScheduleTriggerName(String scheduleTriggerName) {
        this.scheduleTriggerName = scheduleTriggerName;
    }

    public String getScheduleTriggerName() {
        return this.scheduleTriggerName;
    }

    public void setScheduleType(String scheduleType) {
        this.scheduleType = scheduleType;
    }

    public String getScheduleType() {
        return this.scheduleType;
    }

    public void setAccountPath(String accountPath) {
        this.accountPath = accountPath;
    }

    public String getAccountPath() {
        return this.accountPath;
    }

    public void setTaskStoreId(String taskStoreID) {
        this.taskStoreID = taskStoreID;
    }

    public String getTaskStoreId() {
        return this.taskStoreID;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setActualCompletionTime(long actualCompletionTime) {
        this.actualCompletionTime = actualCompletionTime;
    }

    public long getActualCompletionTime() {
        return this.actualCompletionTime;
    }

    public void setAncestorStoreIds(String[] value) {
        this.ancestorStoreIDs = null == value ? null : Arrays.copyOf(value, value.length);
    }

    public String[] getAncestorStoreIds() {
        return null == this.ancestorStoreIDs ? null : Arrays.copyOf(this.ancestorStoreIDs, this.ancestorStoreIDs.length);
    }

    public void setOwnerStoreId(String ownerStoreID) {
        this.ownerStoreID = ownerStoreID;
    }

    public String getOwnerStoreId() {
        return this.ownerStoreID;
    }

    public void setTargetDispatcherId(String targetDispatcherID) {
        this.targetDispatcherID = targetDispatcherID;
    }

    public String getTargetDispatcherId() {
        return this.targetDispatcherID;
    }

    public void setTenantId(String tenantID) {
        this.tenantID = tenantID;
    }

    public String getTenantId() {
        return this.tenantID;
    }

    public static void main(String[] args) {
        String[] fields = new String[]{"1", "3", "4", "5"};
        int blobFieldIndex = 3;
        if (blobFieldIndex != -1) {
            String[] fields2 = new String[fields.length - 1];
            System.arraycopy(fields, 0, fields2, 0, blobFieldIndex);
            System.arraycopy(fields, blobFieldIndex + 1, fields2, blobFieldIndex, fields2.length - blobFieldIndex);
            fields = fields2;
        }
    }

    public static class IDDateStruct {
        public TaskID id = null;
        public long dateEntered;
        public int priority;

        public IDDateStruct(TaskID id, long dateEntered) {
            this(id, dateEntered, 3);
        }

        public IDDateStruct(TaskID id, long dateEntered, int priority) {
            this.dateEntered = dateEntered;
            this.id = id;
            this.priority = priority != 0 ? priority : 3;
        }
    }
}

