/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.tse.NCTSEStateMapTable;
import com.cognos.jsmcommon.tse.SQLObject;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskStatus;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;

public class TaskStateRecord {
    public TaskID taskID;
    public short seq;
    public short count;
    public TaskID parentID;
    public TaskStatus status;
    public TaskID rootID;
    public short curSeq;
    public short countSeq;
    public TaskStatus failStatus;
    public boolean stopOnError;
    public boolean runViaMS;
    public boolean seqOnEnd;
    public byte stepFailed;
    public boolean writeAllHistories = false;
    public short executing = 0;
    public int modCount = -1;
    public static final int MAX_SEQ_STEPS = 30000;
    public static final int SEQ_ON_FAILED = 30100;
    public static final int SEQ_ON_SUCCEEDED = 30200;
    public static final int SEQ_ON_FINISHED = 30300;
    public static final byte STEP_FAILED_ABORT = 1;
    public static final byte STEP_FAILED_CONTINUE = 2;
    public static final String STEP_COUNT = "STEP_COUNT";
    public static final String COUNT_SEQ = "COUNT_SEQ";
    public static final String CUR_SEQ = "CUR_SEQ";
    public static final String STATUS = "STATUS";
    public static final String FAIL_STATUS = "FAIL_STATUS";
    public static final String STEP_FAILED = "STEP_FAILED";
    public static final String SEQ_ON_END = "SEQ_ON_END";
    public static final String EXECUTING = "EXECUTING";

    public TaskStateRecord() {
    }

    public TaskStateRecord(SequenceSpec spec, int seqId, TaskID parent, boolean runViaMS) {
        this.seq = (short)seqId;
        this.stopOnError = spec.isStopOnError();
        this.runViaMS = runViaMS;
        this.parentID = parent;
        this.failStatus = TaskStatus.NONE;
        if (spec.getTask() != null) {
            this.status = TaskStatus.PENDING;
            if (spec.getTask().eventID != null) {
                this.taskID = TaskID.create(spec.getTask().eventID);
            }
        } else {
            this.status = TaskStatus.RUNNING;
        }
        if (this.taskID == null) {
            this.taskID = TaskID.create();
        }
    }

    public boolean find(TaskID id) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().find(this, id);
    }

    public TaskStateRecord[] findAncestors() throws TaskPersistLayerException {
        return this.findAncestors(this.parentID);
    }

    public TaskStateRecord[] findAncestors(TaskID firstAncestor) throws TaskPersistLayerException {
        ArrayList<TaskStateRecord> parents = new ArrayList<TaskStateRecord>();
        TaskID thisParentID = firstAncestor;
        while (thisParentID != null) {
            TaskStateRecord next = NCTSEStateMapTable.getInstance().find(thisParentID);
            parents.add(next);
            thisParentID = next.parentID;
        }
        return parents.toArray(new TaskStateRecord[0]);
    }

    public void create() throws TaskPersistLayerException {
        NCTSEStateMapTable.getInstance().insert(this);
    }

    public static void incCountSeq(TaskID taskID, int n) throws TaskPersistLayerException {
        NCTSEStateMapTable.getInstance().incCountSeq(taskID, n);
    }

    public static void incStepCount(TaskID taskID, int n) throws TaskPersistLayerException {
        NCTSEStateMapTable.getInstance().incStepCount(taskID, n);
    }

    public static boolean decStepCount(TaskID taskID) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().decStepCount(taskID);
    }

    public boolean decStepCount() throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().decStepCount(this.taskID);
    }

    public boolean decParentStepCount() throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().decStepCount(this.parentID);
    }

    public static void setStatus(TaskID taskID, TaskStatus status) throws TaskPersistLayerException {
        NCTSEStateMapTable.getInstance().setStatus(taskID, status);
    }

    public void setStatus(TaskStatus status) throws TaskPersistLayerException {
        NCTSEStateMapTable.getInstance().setStatus(this.taskID, status);
    }

    public static void setStepFailedAbort(TaskID taskID) throws TaskPersistLayerException {
        NCTSEStateMapTable.getInstance().setStepFailedAbort(taskID);
    }

    public static int updateStepFailed(TaskID taskID, byte value) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().updateStepFailed(taskID, value);
    }

    public static int updateStatus(TaskID taskId, TaskStatus newStatus, TaskStatus oldStatus) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().updateStatus(taskId, newStatus, oldStatus);
    }

    public int updateStatus(TaskStatus newStatus, TaskStatus oldStatus) throws TaskPersistLayerException {
        int updated = NCTSEStateMapTable.getInstance().updateStatus(this.taskID, newStatus, oldStatus);
        if (updated > 0) {
            this.status = newStatus;
        }
        return updated;
    }

    public static int updateStatus(TaskID taskID, TaskStatus newStatus, TaskStatus oldStatus, int modCount) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().updateStatus(taskID, newStatus, oldStatus, modCount);
    }

    public int updateStatus(TaskStatus newStatus, TaskStatus oldStatus, int modCount) throws TaskPersistLayerException {
        int updated = NCTSEStateMapTable.getInstance().updateStatus(this.taskID, newStatus, oldStatus, modCount);
        if (updated > 0) {
            this.status = newStatus;
        }
        return updated;
    }

    public static int setCancel(TaskID taskID) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().setCancel(taskID);
    }

    public static int setStepsAsReady(TaskID taskID, int seq, TaskStatus newStatus) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().setStepsAsReady(taskID, seq, newStatus);
    }

    public static int nextStep(TaskID taskID, int seq, int stepCount) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().nextStep(taskID, seq, stepCount);
    }

    public static void setSeqOnEnd(TaskID taskID, boolean hasSeq) throws TaskPersistLayerException {
        NCTSEStateMapTable.getInstance().setSeqOnEnd(taskID, hasSeq);
    }

    public static boolean isRootTask(TaskID parentID) throws TaskPersistLayerException {
        TaskID thisParentID = parentID;
        int count = 0;
        while (thisParentID != null) {
            TaskStateRecord next = NCTSEStateMapTable.getInstance().find(thisParentID);
            thisParentID = next.parentID;
            if (thisParentID == null) continue;
            ++count;
        }
        return count == 0;
    }

    public static int updateExecutingCount(int value, TaskID parentID) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().updateExecutingCount(value, parentID);
    }

    public static TaskStatus getActualStatus(TaskStatus status, int executingCount) {
        TaskStatus newStatus = null;
        newStatus = status != null && executingCount == 0 && (status.equals(TaskStatus.RUNNING) || status.equals(TaskStatus.INACTIVE)) ? TaskStatus.PENDING : status;
        return newStatus;
    }

    public static TaskStatus getActualStatus(TaskStatus status, int curSeq, int countSeq) {
        TaskStatus newStatus = status;
        if (status != null && (status.equals(TaskStatus.RUNNING) || status.equals(TaskStatus.INACTIVE)) && countSeq > 0 && curSeq == 0) {
            status = TaskStatus.PENDING;
        }
        return newStatus;
    }

    public static int getSeqCount(TaskID taskId) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getSeqCount(taskId);
    }

    public void resetForRestart(short restartSequence, short param_countSeq, short stepCount, TaskStatus param_status, boolean run) throws TaskPersistLayerException {
        NCTSEStateMapTable.getInstance().resetForRestart(this, restartSequence, param_countSeq, stepCount, param_status, run);
    }

    public int updateStepFailed(byte value) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().updateStepFailed(this.taskID, value);
    }

    public static TaskStateRecord findRecord(TaskID id) throws TaskPersistLayerException {
        TaskStateRecord record = new TaskStateRecord();
        boolean found = record.find(id);
        if (found) {
            return record;
        }
        return null;
    }

    public static TaskID[] getSeqSteps(TaskID taskID, int seq, TaskStatus status) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getSeqSteps(taskID, seq, status);
    }

    public void updateFields(boolean background, int seqCount, boolean seqOnEnd) {
        if (!background) {
            this.curSeq = 1;
            this.countSeq = 1;
            this.count = (short)(this.count + 1);
        } else {
            this.countSeq = (short)(this.countSeq + seqCount);
            if (seqOnEnd) {
                this.seqOnEnd = true;
            }
        }
    }

    public TaskID getParentId() {
        return this.parentID;
    }

    public static class UpdateObject {
        private static String SET_SQL = "UPDATE NC_TSE_STATE_MAP SET ";
        private static String INC_COUNT_SEQ = "COUNT_SEQ=COUNT_SEQ+? ";
        private static String SET_RUN_VIA_MS = "CUR_SEQ=1, COUNT_SEQ=1, STEP_COUNT=STEP_COUNT+1 ";
        private static String SET_SEQ_ON_END = "SEQ_ON_END=? ";
        private static String SET_UPDATE_EXECUTING_COUNT = "EXECUTING=? ";
        private static String INC_UPDATE_EXECUTING_COUNT = "EXECUTING=EXECUTING+? ";
        private static String DEC_UPDATE_EXECUTING_COUNT = "EXECUTING=EXECUTING-? ";
        private TaskID m_taskID;
        private List m_values = new ArrayList();
        private String m_sql = SET_SQL;
        private boolean m_fieldsSet = false;

        public UpdateObject(TaskID taskID) throws TaskPersistLayerException {
            this.m_taskID = taskID;
        }

        public void incCountSeq(int seqCount) {
            this.addFieldSql(INC_COUNT_SEQ);
            this.m_values.add(new SQLObject(seqCount));
            this.m_fieldsSet = true;
        }

        public void runViaMS() {
            this.addFieldSql(SET_RUN_VIA_MS);
            this.m_fieldsSet = true;
        }

        public void setSeqOnEnd(boolean setSeqOnEnd) {
            this.addFieldSql(SET_SEQ_ON_END);
            this.m_values.add(new SQLObject(setSeqOnEnd));
            this.m_fieldsSet = true;
        }

        public void updateExecutingCount(int value) {
            String updateStatement = null;
            switch (value) {
                case 0: {
                    updateStatement = SET_UPDATE_EXECUTING_COUNT;
                    break;
                }
                case 1: {
                    updateStatement = INC_UPDATE_EXECUTING_COUNT;
                    break;
                }
                case -1: {
                    updateStatement = DEC_UPDATE_EXECUTING_COUNT;
                    value = 1;
                }
            }
            if (updateStatement != null) {
                this.addFieldSql(updateStatement);
                this.m_values.add(new SQLObject(new Integer(value), 4));
            }
            this.m_fieldsSet = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute() throws TaskPersistLayerException {
            if (!this.m_fieldsSet) {
                return 0;
            }
            String sql = this.m_sql + " WHERE TASK_ID = ?";
            SQLObject[] objects = new SQLObject[this.m_values.size() + 1];
            this.m_values.toArray(objects);
            objects[objects.length - 1] = this.m_taskID.getSqlValue();
            PreparedStatement ps = null;
            int result = 0;
            try {
                result = TaskPersistLayer.getInstance().execute(sql, null, objects);
            }
            finally {
                TaskPersistLayer.closeStatement(ps);
            }
            return result;
        }

        private void addFieldSql(String sql) {
            if (this.m_fieldsSet) {
                this.m_sql = this.m_sql + ", " + sql;
            } else {
                this.m_fieldsSet = true;
                this.m_sql = this.m_sql + sql;
            }
        }
    }
}

