/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandler;
import com.cognos.jsmcommon.tse.NCTSEStateMapTable;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class TaskStateTable {
    private static final String SQL_GET_CHILDREN_PROPERTIES = "SELECT state.TASK_ID, state.STEP_COUNT, state.CUR_SEQ, state.COUNT_SEQ, state.SEQ, state.STATUS, state.RUN_VIA_MS, prop.TASK_ID, prop.PROP_NAME, prop.PROP_VALUE FROM NC_TSE_STATE_MAP state, NC_TASK_PROPERTY prop WHERE state.TASK_ID = prop.TASK_ID AND state.PARENT_ID=? AND prop.PROP_NAME=?";

    public static StepInfo[] getStatusSeqChildren(TaskID taskID, short seq, TaskStatus status) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getStatusSeqChildren(taskID, seq, status);
    }

    public static StepInfo[] getStatusChildren(TaskID taskID, TaskStatus status) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getStatusChildren(taskID, status);
    }

    public static TaskID[] getTaskIDs() throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getTaskIDs();
    }

    public static boolean hasChildTasks(TaskID taskId) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().hasChildTasks(taskId);
    }

    public static StepInfo[] getTasksForPurge(TaskID taskID, int limit) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getTasksForPurge(taskID, limit);
    }

    public static StepInfo[] getChildren(TaskID taskID, TaskStatus status) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getChildren(taskID, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StepInfoProperties[] getChildrenProperties(final TaskID taskID, final TaskStatus status, final String propertyName) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<StepInfoProperties> tasks = new ArrayList<StepInfoProperties>();
                try {
                    String sql = TaskStateTable.SQL_GET_CHILDREN_PROPERTIES;
                    if (status != null) {
                        sql = sql + " AND state.STATUS=?";
                    }
                    ps = TaskPersistLayer.prepareStatement(sql);
                    ps.setString(1, taskID.toString());
                    ps.setString(2, propertyName);
                    if (status != null) {
                        ps.setByte(3, status.getId());
                    }
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        StepInfo obj = new StepInfo(new TaskID(rs.getString(1)), rs.getShort(2), rs.getShort(3), rs.getShort(4), rs.getShort(5), rs.getByte(6), rs.getBoolean(7), null);
                        Object[] propValues = new Object[]{rs.getString(10)};
                        StepInfoProperties stepProps = new StepInfoProperties();
                        stepProps.stepInfo = obj;
                        stepProps.properties = propValues;
                        tasks.add(stepProps);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return tasks.toArray(new StepInfoProperties[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskStateTable.getChildrenProperties");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            StepInfoProperties[] stepInfoPropertiesArray = (StepInfoProperties[])handler.execute(sqlExecute);
            return stepInfoPropertiesArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StepInfoProperties[] getChildrenPropertiesBeforeSequence(final TaskID taskID, final TaskStatus status, final String propertyName, final short highSeq) throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<StepInfoProperties> tasks = new ArrayList<StepInfoProperties>();
                try {
                    String sql = TaskStateTable.SQL_GET_CHILDREN_PROPERTIES;
                    sql = sql + " AND state.SEQ<?";
                    if (status != null) {
                        sql = sql + " AND state.STATUS=?";
                    }
                    ps = TaskPersistLayer.prepareStatement(sql);
                    ps.setString(1, taskID.toString());
                    ps.setString(2, propertyName);
                    ps.setShort(3, highSeq);
                    if (status != null) {
                        ps.setByte(4, status.getId());
                    }
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        StepInfo obj = new StepInfo(new TaskID(rs.getString(1)), rs.getShort(2), rs.getShort(3), rs.getShort(4), rs.getShort(5), rs.getByte(6), rs.getBoolean(7), null);
                        Object[] propValues = new Object[]{rs.getString(10)};
                        StepInfoProperties stepProps = new StepInfoProperties();
                        stepProps.stepInfo = obj;
                        stepProps.properties = propValues;
                        tasks.add(stepProps);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return tasks.toArray(new StepInfoProperties[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskStateTable.getChildrenPropertiesBeforeSequence");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            StepInfoProperties[] stepInfoPropertiesArray = (StepInfoProperties[])handler.execute(sqlExecute);
            return stepInfoPropertiesArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    public static StepInfo[] getTaskTree(String rootId) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getTaskTree(rootId);
    }

    public static StepInfo[] getRunningTasks(String sdsInstanceId) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getRunningTasks(sdsInstanceId);
    }

    public static int setParentToNullOnCompletedChildren(TaskID taskID, TaskStatus setStatus) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().setParentToNullOnCompletedChildren(taskID, setStatus);
    }

    public static int setParentToNullOnChildren(TaskID taskID, TaskStatus setStatus) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().setParentToNullOnChildren(taskID, setStatus);
    }

    public static StepInfo[] getInactiveTasks(String sdsInstanceId) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getInactiveTasks(sdsInstanceId);
    }

    public static void setChildrensInstanceID(TaskID taskID) throws TaskPersistLayerException {
        NCTaskQueueTable.getInstance().setSdsInstance(taskID);
        StepInfo[] kids = TaskStateTable.getChildren(taskID, null);
        if (kids != null && kids.length > 0) {
            for (int i = 0; i < kids.length; ++i) {
                TaskStateTable.setChildrensInstanceID(kids[i].taskId);
            }
        }
    }

    static int deleteTask(TaskID taskID) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().deleteTask(taskID);
    }

    static int getCountChildren(TaskStatus status1, TaskStatus status2, TaskID parent) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getCountChildren(status1, status2, parent);
    }

    public static final class StepInfoProperties {
        public StepInfo stepInfo;
        public Object[] properties;
    }

    public static final class StepInfo {
        public final TaskID taskId;
        public final TaskID parentId;
        public final short count;
        public final short curSeq;
        public final short countSeq;
        public final short seq;
        public final boolean runViaMS;
        public final byte status;

        StepInfo(TaskID id, short count, short curSeq, short countSeq, short seq, byte status, boolean runViaMS, TaskID parentID) {
            this.taskId = id;
            this.count = count;
            this.curSeq = curSeq;
            this.countSeq = countSeq;
            this.seq = seq;
            this.status = status;
            this.runViaMS = runViaMS;
            this.parentId = parentID;
        }

        public final boolean hasChildren() {
            return this.countSeq > 0;
        }

        public TaskStatus getStatus() {
            return TaskStatus.fromId(this.status);
        }
    }
}

