/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.tse.SQLObject;

public final class TaskStatus {
    public static final TaskStatus NONE = new TaskStatus(0);
    public static final TaskStatus READY = new TaskStatus(10);
    public static final TaskStatus PENDING = new TaskStatus(11);
    public static final TaskStatus RUNNING = new TaskStatus(12);
    public static final TaskStatus PAUSED = new TaskStatus(13);
    public static final TaskStatus ALLOCATED = new TaskStatus(14);
    public static final TaskStatus INACTIVE = new TaskStatus(15);
    public static final TaskStatus COMPLETED = new TaskStatus(20);
    public static final TaskStatus CANCELLED = new TaskStatus(21);
    public static final TaskStatus FAILED = new TaskStatus(22);
    public static final TaskStatus TERMINATED = new TaskStatus(23);
    public static final TaskStatus PURGED = new TaskStatus(24);
    private int id;

    public final byte getId() {
        return (byte)this.id;
    }

    public final SQLObject getSqlValue() {
        return new SQLObject(new Byte((byte)this.id), 4);
    }

    public static TaskStatus fromId(byte id) {
        switch (id) {
            case 0: {
                return NONE;
            }
            case 10: {
                return READY;
            }
            case 11: {
                return PENDING;
            }
            case 12: {
                return RUNNING;
            }
            case 13: {
                return PAUSED;
            }
            case 14: {
                return ALLOCATED;
            }
            case 15: {
                return INACTIVE;
            }
            case 20: {
                return COMPLETED;
            }
            case 21: {
                return CANCELLED;
            }
            case 22: {
                return FAILED;
            }
            case 23: {
                return TERMINATED;
            }
            case 24: {
                return PURGED;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static String getSqlFilterForTerminated() {
        return "STATUS>=20 AND STATUS<=29";
    }

    public static String getSqlFilterForPurgable() {
        return "STATUS IN (20, 23)";
    }

    public String toString() {
        switch (this.id) {
            case 0: {
                return "NONE";
            }
            case 10: {
                return "READY";
            }
            case 11: {
                return "PENDING";
            }
            case 12: {
                return "RUNNING";
            }
            case 13: {
                return "PAUSED";
            }
            case 14: {
                return "ALLOCATED";
            }
            case 15: {
                return "INACTIVE";
            }
            case 20: {
                return "COMPLETED";
            }
            case 21: {
                return "CANCELLED";
            }
            case 22: {
                return "FAILED";
            }
            case 23: {
                return "TERMINATED";
            }
            case 24: {
                return "PURGED";
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean isTerminatingStatus() {
        return this.id >= 20 && this.id <= 29;
    }

    public boolean hasWrittenHistory() {
        return this.id >= 15;
    }

    public boolean hasNotWrittenHistory() {
        return this.id <= 11;
    }

    public boolean canRestart(boolean topLevel) {
        boolean restartable = false;
        if (topLevel) {
            restartable = FAILED == this;
            restartable = restartable || PURGED == this;
            restartable = restartable || TERMINATED == this;
        } else {
            restartable = INACTIVE != this && CANCELLED != this && PAUSED != this && COMPLETED != this;
        }
        return restartable;
    }

    public static boolean checkPurge(TaskStatus taskStatus) {
        boolean canPurge = false;
        if (taskStatus != null && (taskStatus.equals(COMPLETED) || taskStatus.equals(TERMINATED) || taskStatus.equals(PURGED))) {
            canPurge = true;
        }
        return canPurge;
    }

    public static TaskStatus mapStatus(EventStatus status) {
        if (EventStatus.CANCELLED.equals(status)) {
            return CANCELLED;
        }
        if (EventStatus.FAILED.equals(status)) {
            return FAILED;
        }
        if (EventStatus.PURGED.equals(status)) {
            return PURGED;
        }
        if (EventStatus.SUCCEEDED.equals(status)) {
            return COMPLETED;
        }
        if (EventStatus.TERMINATED.equals(status)) {
            return TERMINATED;
        }
        if (EventStatus.EXECUTING.equals(status)) {
            return RUNNING;
        }
        if (EventStatus.SUSPENDED.equals(status)) {
            return PAUSED;
        }
        if (EventStatus.PENDING.equals(status)) {
            return PENDING;
        }
        if (EventStatus.INACTIVE.equals(status)) {
            return INACTIVE;
        }
        throw new IllegalArgumentException();
    }

    public static EventStatus mapStatus(TaskStatus status) {
        if (CANCELLED == status) {
            return EventStatus.CANCELLED;
        }
        if (FAILED == status) {
            return EventStatus.FAILED;
        }
        if (PURGED == status) {
            return EventStatus.PURGED;
        }
        if (COMPLETED == status) {
            return EventStatus.SUCCEEDED;
        }
        if (TERMINATED == status) {
            return EventStatus.TERMINATED;
        }
        if (RUNNING == status || ALLOCATED == status) {
            return EventStatus.EXECUTING;
        }
        if (PENDING == status || READY == status) {
            return EventStatus.PENDING;
        }
        if (PAUSED == status) {
            return EventStatus.SUSPENDED;
        }
        if (INACTIVE == status) {
            return EventStatus.INACTIVE;
        }
        throw new IllegalArgumentException();
    }

    public static TaskStatus getStatusForRestart(TaskStatus status) {
        if (FAILED == status) {
            return READY;
        }
        if (PURGED == status) {
            return PENDING;
        }
        if (TERMINATED == status) {
            return PENDING;
        }
        if (PENDING == status) {
            return PENDING;
        }
        throw new IllegalArgumentException(status.toString() + " is not a valid status to restart.");
    }

    public boolean isWaiting() {
        return this.id == 15;
    }

    public static boolean isValidForNotify(TaskStatus status) {
        if (status == null) {
            return false;
        }
        if (COMPLETED.equals(status)) {
            return true;
        }
        if (TERMINATED.equals(status)) {
            return true;
        }
        return FAILED.equals(status);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskStatus) {
            TaskStatus task = (TaskStatus)obj;
            if (this.id == task.id) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    private TaskStatus(int id) {
        this.id = id;
    }
}

