/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.tse;

import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandler;
import com.cognos.jsmcommon.tse.NCTSEStateMapTable;
import com.cognos.jsmcommon.tse.SQLObject;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class TaskTable {
    static final String SQL_DELETE_TASK = "DELETE FROM NC_TASK_QUEUE WHERE TASK_ID=?";
    private static final String SDS_INSTANCES = "SELECT DISTINCT SDS_INSTANCE_ID FROM NC_TASK_QUEUE WHERE (SDS_INSTANCE_ID IS NOT NULL)";

    public static StoreInfo[] getCompletedStoreInfo(TaskID taskID, int limit) throws TaskPersistLayerException {
        return NCTSEStateMapTable.getInstance().getCompletedStoreInfo(taskID, limit);
    }

    static int deleteTask(TaskID taskID) throws TaskPersistLayerException {
        return TaskPersistLayer.getInstance().execute(SQL_DELETE_TASK, null, new SQLObject[]{taskID.getSqlValue()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getInstanceGuids() throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<String> ids = new ArrayList<String>();
                try {
                    ps = TaskPersistLayer.prepareStatement(TaskTable.SDS_INSTANCES);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ids.add(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return ids.toArray(new String[0]);
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("TaskTable.getInstanceGuids");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            String[] stringArray = (String[])handler.execute(sqlExecute);
            return stringArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    public static final class StoreInfo {
        public final TaskID taskId;
        public final String storeId;
        public final TaskID restartId;
        public final Date executionTime;

        StoreInfo(TaskID id, String storeId, TaskID restartId, Date executionTime) {
            this.taskId = id;
            this.storeId = storeId;
            this.restartId = restartId;
            this.executionTime = executionTime;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StoreInfo)) {
                return false;
            }
            return ((StoreInfo)obj).taskId.equals(this.taskId);
        }

        public int hashCode() {
            return this.taskId.hashCode();
        }

        public String toString() {
            return this.taskId.toString();
        }
    }
}

