/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.DispatcherTransportVar;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.MigrationTask;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RoutingInfo;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.jsmcommon.api.APIException;
import com.cognos.jsmcommon.api.ProcessHandlerException;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.service.ServiceConstants;
import com.cognos.jsmcommon.soap.util.AxisUtils;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ObjectCopyUtil;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPElement;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.XMLUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class BiBusUtilities {
    private static final Namespace NS_BUS = BIBusEnvelope.NS_BUS;
    private static final QName BUS_BIBUS_HEADER = BIBusEnvelope.BUS_BIBUS_HEADER;
    private static final javax.xml.namespace.QName JAX_BI_BUS_QNAME = new javax.xml.namespace.QName(NS_BUS.getURI(), BUS_BIBUS_HEADER.getName(), NS_BUS.getPrefix());
    private static final QName CAM_ACTION = DocumentHelper.createQName((String)"action", (Namespace)NS_BUS);
    private static final QName XSI_TYPE = com.cognos.pogo.pdk.SOAPEnvelope.XSI_TYPE;
    private static final QName ITEM = BIBusEnvelope.ITEM;
    private static final QName NAME = DocumentHelper.createQName((String)"name", (Namespace)NS_BUS);
    private static final QName VALUE = DocumentHelper.createQName((String)"value", (Namespace)NS_BUS);
    private static final QName CM_QUERY = DocumentHelper.createQName((String)"query", (Namespace)NS_BUS);
    public static final QName CM_REQUESTS = DocumentHelper.createQName((String)"requests", (Namespace)NS_BUS);
    private static final String XSD_STRING = com.cognos.pogo.pdk.SOAPEnvelope.XSD_STRING;
    public static final String SOAP_ENC_ARRAY = com.cognos.pogo.pdk.SOAPEnvelope.SOAP_ENC_ARRAY;
    public static final QName SOAP_ENC_ARRAYTYPE = com.cognos.pogo.pdk.SOAPEnvelope.SOAP_ENC_ARRAYTYPE;
    public static final String CM_QUERYREQUEST = NS_BUS.getPrefix() + ":queryRequest";
    public static final String CM_PROPENUM = NS_BUS.getPrefix() + ":propEnum";
    public static final QName CM_SEARCH = DocumentHelper.createQName((String)"search", (Namespace)NS_BUS);
    public static final QName CM_PROPERTIES = DocumentHelper.createQName((String)"properties", (Namespace)NS_BUS);
    public static BiBusHeader testHeader;

    public static final BiBusHeader extractBiBusHeader() throws AxisFault {
        if (testHeader == null) {
            return BiBusUtilities.removeConversationContext(BiBusUtilities.extractBiBusHeader(MessageContext.getCurrentContext()));
        }
        return testHeader;
    }

    public static BiBusHeader removeConversationContext(BiBusHeader header) {
        if (header == null) {
            return header;
        }
        Tracking tracking = header.getTracking();
        if (tracking == null) {
            return header;
        }
        tracking.setConversationContext(null);
        header.setTracking(tracking);
        return header;
    }

    public static final BiBusHeader extractBiBusHeader(SOAPEnvelope envelope) throws AxisFault {
        Object obj = null;
        if (envelope == null) {
            return null;
        }
        try {
            SOAPHeaderElement header = envelope.getHeaderByName(ServiceConstants.BUS_QNAME.getNamespaceURI(), ServiceConstants.BUS_QNAME.getLocalPart());
            if (header != null) {
                obj = header.getValueAsType(ServiceConstants.BUS_QNAME);
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_EXTRACTING_HEADER, new String[]{e.getMessage() + ":1"});
            ProcessHandlerException phe = new ProcessHandlerException(I18NCode.MSG_ERROR_EXTRACTING_HEADER, new String[]{e.getMessage() + ""});
            SDSServiceException sdsEx = new SDSServiceException(I18NCode.OTH_ERROR_EXTRACTING_HEADER, (Throwable)phe);
            BiBusUtilities.throwHeaderException(new APIException(sdsEx));
        }
        return (BiBusHeader)obj;
    }

    public static final BiBusHeader extractBiBusHeader(MessageContext mc) throws AxisFault {
        if (testHeader == null) {
            return BiBusUtilities.extractBiBusHeader(mc.getCurrentMessage().getSOAPEnvelope());
        }
        return testHeader;
    }

    public static final void addFormFieldVarToResponseHeader(String name, String value) throws AxisFault {
        MessageContext mc = MessageContext.getCurrentContext();
        try {
            if (mc != null) {
                SOAPHeaderElement soapHeader = mc.getCurrentMessage().getSOAPEnvelope().getHeaderByName(ServiceConstants.BUS_QNAME.getNamespaceURI(), ServiceConstants.BUS_QNAME.getLocalPart());
                MessageElement formFieldVarsElement = BiBusUtilities.getHeaderElement((MessageElement)soapHeader, BIBusEnvelope.BUS_FORM_FIELD_VARS.getName());
                if (formFieldVarsElement == null) {
                    FormFieldVar[] formVarsObject = new FormFieldVar[]{new FormFieldVar()};
                    formVarsObject[0].setName(name);
                    formVarsObject[0].setValue(value);
                    javax.xml.namespace.QName qname = new javax.xml.namespace.QName(BIBusEnvelope.BUS_FORM_FIELD_VARS.getName());
                    formFieldVarsElement = new MessageElement(qname, (Object)formVarsObject);
                    soapHeader.addChildElement((SOAPElement)formFieldVarsElement);
                    BiBusUtilities.setDirty(formFieldVarsElement);
                } else {
                    BiBusUtilities.addAxisVar(formFieldVarsElement, name, value);
                }
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_EXTRACTING_HEADER, new String[]{e.getMessage() + ":2"});
            ProcessHandlerException phe = new ProcessHandlerException(I18NCode.MSG_ERROR_EXTRACTING_HEADER, new String[]{e.getMessage() + ""});
            SDSServiceException sdsEx = new SDSServiceException(I18NCode.OTH_ERROR_EXTRACTING_HEADER, (Throwable)phe);
            BiBusUtilities.throwHeaderException(new APIException(sdsEx));
        }
    }

    private static void setDirty(MessageElement element) {
        element.setDirty(true);
        SOAPElement se = element.getParentElement();
        if (se instanceof MessageElement) {
            BiBusUtilities.setDirty((MessageElement)se);
        }
    }

    private static MessageElement getHeaderElement(MessageElement headerElement, String headerElementName) {
        if (headerElement.getName().equals(headerElementName)) {
            return headerElement;
        }
        MessageElement element = null;
        Iterator formVars = headerElement.getChildElements();
        while (formVars.hasNext() && element == null) {
            Object next = formVars.next();
            if (!(next instanceof MessageElement)) continue;
            MessageElement childElement = (MessageElement)next;
            element = BiBusUtilities.getHeaderElement(childElement, headerElementName);
        }
        return element;
    }

    public static final void throwHeaderException(APIException e) throws AxisFault {
        AxisFault fault = AxisFault.makeFault((Exception)e);
        fault.setFaultCodeAsString(e.getFaultCode(Locale.getDefault()));
        fault.setFaultString(e.getFaultString(Locale.getDefault()));
        fault.setFaultDetail(e.getDetails(Locale.getDefault()));
        throw fault;
    }

    public static BIBusEnvelope getHeadedEnvelope(BiBusHeader header) {
        AxisUtils axisUtils = AxisUtils.getInstance();
        String headerString = null;
        try {
            headerString = axisUtils.serialize(header, JAX_BI_BUS_QNAME);
        }
        catch (Exception e) {
            String msg = "BiBusUtilities.getHeadedEnvelope - failed to serialize the header";
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(msg);
        }
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)headerString);
        }
        catch (DocumentException e) {
            String msg = "BiBusUtilities.getHeadedEnvelope - failed to parse the header";
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(msg);
        }
        BIBusEnvelope returnEnv = new BIBusEnvelope();
        returnEnv.setBIBusHeader((org.dom4j.Element)doc.getRootElement().detach());
        return returnEnv;
    }

    public static BIBusEnvelope addCAMAction(BIBusEnvelope envelope, String action) {
        org.dom4j.Element cam = envelope.getCAM();
        BiBusUtilities.populateCAMAction(cam, action);
        return envelope;
    }

    public static BiBusHeader retrieveHeader(BIBusEnvelope env) {
        AxisUtils axisUtils = AxisUtils.getInstance();
        Object headerObject = null;
        try {
            headerObject = axisUtils.deserialize(env.getBIBusHeader(), JAX_BI_BUS_QNAME);
        }
        catch (Exception e) {
            String msg = "BiBusUtilities.getHeadedEnvelope - failed to deserialize the header";
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(msg);
        }
        return (BiBusHeader)headerObject;
    }

    public static void setRoutingServerGroup(SearchPathSingleObject searchPath, JobBiBusHeaders headers) throws SDSServiceException {
        if (searchPath == null || headers == null) {
            return;
        }
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(headers);
        PropEnum[] props = new PropEnum[]{PropEnum.routingServerGroup, PropEnum.routingHints};
        try {
            BaseClass[] routing = cmPort.query(new SearchPathMultipleObject(searchPath.get_value()), props, null, null);
            if (routing != null && routing.length == 1) {
                BiBusUtilities.setRoutingServerGroup(routing[0], headers.getBiBusHeader());
            }
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, e);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("SDKClientException when retrieving routing group from Content Manager.");
            throw new SDSServiceException(I18NCode.GEN_CM_QUERY_ERROR, new Object[]{searchPath.get_value()});
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("EMFSecurityException when retrieving routing group from Content Manager.");
            throw new SDSServiceException(I18NCode.GEN_CM_QUERY_ERROR, new Object[]{searchPath.get_value()});
        }
        finally {
            cmPort.close();
        }
    }

    public static void setRoutingServerGroup(BaseClass base, BiBusHeader headers) throws SDSServiceException {
        StringProp routingServerGroup = null;
        if (base instanceof MigrationTask) {
            routingServerGroup = ((MigrationTask)base).getRoutingServerGroup();
            routingServerGroup = new StringProp();
            routingServerGroup.setValue("");
        } else {
            try {
                Method m = base.getClass().getMethod("getRoutingServerGroup", new Class[0]);
                routingServerGroup = (StringProp)m.invoke((Object)base, new Object[0]);
            }
            catch (NoSuchMethodException m) {
            }
            catch (Exception e) {
                throw new SDSServiceException(I18NCode.MSG_ROUTING_RETRIEVE_FAILED, new Object[]{e.getLocalizedMessage()}, e);
            }
        }
        if (routingServerGroup != null) {
            RoutingInfo routingInfo = new RoutingInfo();
            routingInfo.setRoutingServerGroup(routingServerGroup.getValue());
            headers.setRouting(routingInfo);
        } else if (headers.getRouting() != null) {
            headers.setRouting(null);
        }
    }

    public static BIBusEnvelope setQuery(BIBusEnvelope envelope, String path, String[] props) {
        org.dom4j.Element body = envelope.getBody();
        org.dom4j.Element query = body.addElement(CM_QUERY);
        org.dom4j.Element requests = query.addElement(CM_REQUESTS);
        requests.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        requests.addAttribute(SOAP_ENC_ARRAYTYPE, CM_QUERYREQUEST + "[1]");
        org.dom4j.Element item = requests.addElement(ITEM);
        item.addAttribute(XSI_TYPE, CM_QUERYREQUEST);
        org.dom4j.Element search = item.addElement(CM_SEARCH);
        search.addAttribute(XSI_TYPE, XSD_STRING);
        search.addText(path);
        org.dom4j.Element properties = item.addElement(CM_PROPERTIES);
        properties.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        properties.addAttribute(SOAP_ENC_ARRAYTYPE, CM_PROPENUM + "[" + props.length + "]");
        for (int i = 0; i < props.length; ++i) {
            org.dom4j.Element property = properties.addElement(ITEM);
            property.addAttribute(XSI_TYPE, CM_PROPENUM);
            property.addText(props[i]);
        }
        return envelope;
    }

    private static void populateCAMAction(org.dom4j.Element cam, String action) {
        if (action != null) {
            org.dom4j.Element cam_action = cam.addElement(CAM_ACTION);
            cam_action.addAttribute(XSI_TYPE, XSD_STRING);
            cam_action.setText(action);
        }
    }

    private static void addAxisVar(MessageElement element, String name, String value) throws Exception {
        org.w3c.dom.Document doc = XMLUtils.newDocument();
        Element itemEle = doc.createElement(ITEM.getName());
        Element nameEle = doc.createElement(NAME.getName());
        nameEle.setAttributeNS(XSI_TYPE.getNamespaceURI(), XSI_TYPE.getQualifiedName(), com.cognos.pogo.pdk.SOAPEnvelope.XSD_STRING);
        nameEle.appendChild(doc.createTextNode(name));
        Element valueEle = doc.createElement(VALUE.getName());
        valueEle.setAttributeNS(XSI_TYPE.getNamespaceURI(), XSI_TYPE.getQualifiedName(), com.cognos.pogo.pdk.SOAPEnvelope.XSD_STRING);
        valueEle.appendChild(doc.createTextNode(value));
        itemEle.appendChild(nameEle);
        itemEle.appendChild(valueEle);
        element.addChild(new MessageElement(itemEle));
        BiBusUtilities.setDirty(element);
    }

    public static org.w3c.dom.Document getAsW3cDocument(BiBusHeader biBusHeader) {
        org.w3c.dom.Document w3cDoc = null;
        BIBusEnvelope biBusEnv = BiBusUtilities.getHeadedEnvelope(biBusHeader);
        org.dom4j.Element headerElement = biBusEnv.getHeader();
        org.dom4j.Element biBusElement = (org.dom4j.Element)headerElement.selectSingleNode("//*[local-name()='biBusHeader']");
        String headerAsString = biBusElement.asXML();
        try {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(headerAsString.getBytes("UTF-8"));
            w3cDoc = XMLUtils.newDocument((InputStream)sourceStream);
        }
        catch (UnsupportedEncodingException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        catch (ParserConfigurationException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        catch (SAXException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        catch (IOException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        return w3cDoc;
    }

    public static void main(String[] args) {
        BiBusHeader header = new BiBusHeader();
        CAM cam = new CAM();
        cam.setAction("logonAs");
        header.setCAM(cam);
        Tracking tracking = new Tracking();
        header.setTracking(tracking);
    }

    public static BiBusHeader getDeepCopy(BiBusHeader header) {
        BiBusHeader copy = null;
        try {
            copy = (BiBusHeader)ObjectCopyUtil.deepCopy(header);
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(ex);
        }
        return copy;
    }

    public static BiBusHeader getShallowCopy(BiBusHeader header) {
        BiBusHeader shallowCopy = new BiBusHeader();
        shallowCopy.setCAF(header.getCAF());
        shallowCopy.setCAM(header.getCAM());
        shallowCopy.setCAMProtect(header.getCAMProtect());
        shallowCopy.setDispatcherTransportVars(header.getDispatcherTransportVars());
        shallowCopy.setHdrSession(header.getHdrSession());
        shallowCopy.setProviders(header.getProviders());
        shallowCopy.setRouting(header.getRouting());
        shallowCopy.setTracking(header.getTracking());
        shallowCopy.setUserPreferenceVars(header.getUserPreferenceVars());
        return shallowCopy;
    }

    public static boolean hasCredentialPath(BiBusHeader header) {
        String credPath = BiBusUtilities.getCredentialPath(header);
        return credPath != null && credPath.length() > 0;
    }

    public static String getCredentialPath(BiBusHeader header) {
        if (header != null && header.getCAM() != null) {
            return header.getCAM().getCAMCredentialPath();
        }
        return null;
    }

    public static void addFormFieldVar(BiBusHeader header, String name, String value) {
        HdrSession hdrSession = header.getHdrSession();
        if (hdrSession != null) {
            FormFieldVar[] formFieldVars = hdrSession.getFormFieldVars();
            int index = BiBusUtilities.getFormFieldVarIndex(formFieldVars, name);
            if (index >= 0) {
                formFieldVars[index].setValue(value);
            } else {
                if (formFieldVars == null) {
                    formFieldVars = new FormFieldVar[1];
                } else {
                    FormFieldVar[] formFieldVarsTmp = new FormFieldVar[formFieldVars.length + 1];
                    System.arraycopy(formFieldVars, 0, formFieldVarsTmp, 0, formFieldVars.length);
                    formFieldVars = formFieldVarsTmp;
                }
                FormFieldVar formFieldVar = new FormFieldVar();
                formFieldVar.setName(name);
                formFieldVar.setValue(value);
                formFieldVars[formFieldVars.length - 1] = formFieldVar;
            }
            hdrSession.setFormFieldVars(formFieldVars);
        }
    }

    public static String getUserPreferenceVar(BiBusHeader header, String name) {
        UserPreferenceVar[] userPreferenceVars;
        int index;
        String value = "";
        if (header != null && name != null && !name.trim().equals("") && (index = BiBusUtilities.getUserPreferenceVarIndex(userPreferenceVars = header.getUserPreferenceVars(), name)) >= 0) {
            value = userPreferenceVars[index].getValue();
        }
        return value;
    }

    private static int getUserPreferenceVarIndex(UserPreferenceVar[] userPreferenceVars, String name) {
        if (userPreferenceVars != null && userPreferenceVars.length > 0) {
            for (int i = 0; i < userPreferenceVars.length; ++i) {
                if (!userPreferenceVars[i].getName().equals(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String getFormFieldVar(BiBusHeader header, String name) {
        FormFieldVar[] formFieldVars;
        int index;
        String value = "";
        HdrSession hdrSession = header.getHdrSession();
        if (hdrSession != null && (index = BiBusUtilities.getFormFieldVarIndex(formFieldVars = hdrSession.getFormFieldVars(), name)) >= 0) {
            value = formFieldVars[index].getValue();
        }
        return value;
    }

    private static int getFormFieldVarIndex(FormFieldVar[] formFieldVars, String name) {
        if (formFieldVars != null && formFieldVars.length > 0) {
            for (int i = 0; i < formFieldVars.length; ++i) {
                if (!formFieldVars[i].getName().equals(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static void updateRequesterDispatcherTransportVarResponse(BiBusHeader header, String requestorValue) {
        String REQUESTOR = "requester";
        DispatcherTransportVar[] dispatcherTransportVars = header.getDispatcherTransportVars();
        int index = BiBusUtilities.getDispatcherTransportVarIndex(dispatcherTransportVars, "requester");
        if (index >= 0) {
            DispatcherTransportVar requestorVar = dispatcherTransportVars[index];
            String ourVarValue = requestorVar.getValue();
            int ourVarLocation = ourVarValue.lastIndexOf(requestorValue);
            if (ourVarLocation >= 0) {
                ourVarValue = ourVarValue.substring(0, ourVarLocation);
            }
            requestorVar.setValue(ourVarValue);
        }
    }

    public static void addRequesterDispatcherTransportVar(BiBusHeader header, String requestorValue) {
        String REQUESTOR = "requester";
        if (requestorValue != null) {
            String value = BiBusUtilities.getDispatcherTransportVar(header, "requester");
            value = value.length() > 0 ? value + ";" + requestorValue : requestorValue;
            BiBusUtilities.addDispatcherTransportVar(header, "requester", value);
        }
    }

    public static void addDispatcherTransportVar(BiBusHeader header, String name, String value) {
        DispatcherTransportVar[] dispatcherTransportVars = header.getDispatcherTransportVars();
        int index = BiBusUtilities.getDispatcherTransportVarIndex(dispatcherTransportVars, name);
        if (index >= 0) {
            dispatcherTransportVars[index].setValue(value);
        } else {
            if (dispatcherTransportVars == null) {
                dispatcherTransportVars = new DispatcherTransportVar[1];
            } else {
                DispatcherTransportVar[] DispatcherTransportVarsTmp = new DispatcherTransportVar[dispatcherTransportVars.length + 1];
                System.arraycopy(dispatcherTransportVars, 0, DispatcherTransportVarsTmp, 0, dispatcherTransportVars.length);
                dispatcherTransportVars = DispatcherTransportVarsTmp;
            }
            DispatcherTransportVar DispatcherTransportVar2 = new DispatcherTransportVar();
            DispatcherTransportVar2.setName(name);
            DispatcherTransportVar2.setValue(value);
            dispatcherTransportVars[dispatcherTransportVars.length - 1] = DispatcherTransportVar2;
        }
        header.setDispatcherTransportVars(dispatcherTransportVars);
    }

    public static String getDispatcherTransportVar(BiBusHeader header, String name) {
        String value = "";
        DispatcherTransportVar[] DispatcherTransportVars = header.getDispatcherTransportVars();
        int index = BiBusUtilities.getDispatcherTransportVarIndex(DispatcherTransportVars, name);
        if (index >= 0) {
            value = DispatcherTransportVars[index].getValue();
        }
        return value;
    }

    private static int getDispatcherTransportVarIndex(DispatcherTransportVar[] DispatcherTransportVars, String name) {
        if (DispatcherTransportVars != null && DispatcherTransportVars.length > 0) {
            for (int i = 0; i < DispatcherTransportVars.length; ++i) {
                if (!DispatcherTransportVars[i].getName().equals(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String getOperation(BIBusEnvelope envelope) {
        org.dom4j.Element operationElement;
        String operation = null;
        org.dom4j.Element body = envelope.getBody();
        if (body != null && (operationElement = (org.dom4j.Element)body.selectSingleNode("./*")) != null) {
            operation = operationElement.getName();
        }
        return operation;
    }

    public static void addEnvironmentVar(BiBusHeader header, String name, String value) {
        HdrSession hdrSession = header.getHdrSession();
        if (hdrSession != null) {
            EnvironmentVar[] environmentVars = hdrSession.getEnvironmentVars();
            int index = BiBusUtilities.getEnvironmentVarIndex(environmentVars, name);
            if (index >= 0) {
                environmentVars[index].setValue(value);
            } else {
                if (environmentVars == null) {
                    environmentVars = new EnvironmentVar[1];
                } else {
                    EnvironmentVar[] environmentVarsTmp = new EnvironmentVar[environmentVars.length + 1];
                    System.arraycopy(environmentVars, 0, environmentVarsTmp, 0, environmentVars.length);
                    environmentVars = environmentVarsTmp;
                }
                EnvironmentVar environmentVar = new EnvironmentVar();
                environmentVar.setName(name);
                environmentVar.setValue(value);
                environmentVars[environmentVars.length - 1] = environmentVar;
            }
            hdrSession.setEnvironmentVars(environmentVars);
        }
    }

    public static String getEnvironmentVar(BiBusHeader header, String name) {
        EnvironmentVar[] environmentVars;
        int index;
        String value = "";
        HdrSession hdrSession = header.getHdrSession();
        if (hdrSession != null && (index = BiBusUtilities.getEnvironmentVarIndex(environmentVars = hdrSession.getEnvironmentVars(), name)) >= 0) {
            value = environmentVars[index].getValue();
        }
        return value;
    }

    private static int getEnvironmentVarIndex(EnvironmentVar[] environmentVars, String name) {
        if (environmentVars != null && environmentVars.length > 0) {
            for (int i = 0; i < environmentVars.length; ++i) {
                if (!environmentVars[i].getName().equals(name)) continue;
                return i;
            }
        }
        return -1;
    }
}

