/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.History;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.IClientBase;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.ArrayList;

public class CommonHistoryHelper {
    public static History[] getHistoryFromCM(String[] paths, BiBusHeader header) {
        History[] histories = new History[]{};
        try {
            histories = CommonHistoryHelper.getHistoryFromCM(paths, header, new PropEnum[]{PropEnum.searchPath, PropEnum.storeID, PropEnum.status, PropEnum.eventID, PropEnum.ownerEventID, PropEnum.restartEventID});
        }
        catch (SDKClientException sDKClientException) {
        }
        catch (EMFSecurityException eMFSecurityException) {
            // empty catch block
        }
        return histories;
    }

    public static History[] getHistoryFromCM(String[] paths, BiBusHeader header, PropEnum[] props) throws SDKClientException, EMFSecurityException {
        History[] histories = new History[paths.length];
        CAM cam = null;
        if (paths.length == 0) {
            return histories;
        }
        StringBuffer logpaths = new StringBuffer();
        QueryRequest[] requests = new QueryRequest[paths.length];
        for (int i = 0; i < requests.length; ++i) {
            requests[i] = new QueryRequest();
            requests[i].setSearch(paths[i]);
            requests[i].setProperties(props);
            if (i != 0) {
                logpaths.append(": ");
            }
            logpaths.append(paths[i]);
        }
        IClientBase cmPort = null;
        try {
            cam = header.getCAM();
            header.setCAM(null);
            cmPort = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
            cmPort.setLogCategory(JSMCommonCategory.RUNTIME);
            cmPort.signNextRequest("JSM");
            QueryReply[] replys = cmPort.queryMultiple(requests);
            for (int i = 0; replys != null && i < replys.length; ++i) {
                BaseClass[] baseClasses = replys[i].getQueryResult();
                if (baseClasses == null || baseClasses.length != 1 || !(baseClasses[0] instanceof History)) continue;
                histories[i] = (History)baseClasses[0];
            }
        }
        catch (EMFSecurityException ex) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("CamSecurityException when retrieving history with path [" + logpaths.toString() + "].");
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(ex.getMessage());
            throw ex;
        }
        catch (SDKClientException ex) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("SDKClientException when retrieving history with path [" + logpaths.toString() + "].");
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.INFO, ex);
            throw ex;
        }
        finally {
            header.setCAM(cam);
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return histories;
    }

    public static History getHistoryFromCM(String path, BiBusHeader header) {
        History[] histories = CommonHistoryHelper.getHistoryFromCM(new String[]{path}, header);
        return histories == null || histories.length == 0 ? null : histories[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseHistoryDetail[] getHistoryDetailsFromCM(String historyPath, BiBusHeader header) {
        ArrayList<BaseClass> detailsList = new ArrayList<BaseClass>();
        QueryRequest request = new QueryRequest();
        request.setSearch(historyPath + "/*");
        request.setProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.detail, PropEnum.detailTime, PropEnum.severity});
        IClientBase cmPort = null;
        try {
            QueryRequest[] requests = new QueryRequest[]{request};
            cmPort = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
            cmPort.setLogCategory(JSMCommonCategory.RUNTIME);
            cmPort.signNextRequest("JSM");
            QueryReply[] replys = cmPort.queryMultiple(requests);
            if (replys != null) {
                for (int i = 0; i < replys.length; ++i) {
                    BaseClass[] baseClasses = replys[i].getQueryResult();
                    if (baseClasses == null) continue;
                    for (int j = 0; j < baseClasses.length; ++j) {
                        if (!(baseClasses[j] instanceof BaseHistoryDetail)) continue;
                        detailsList.add(baseClasses[j]);
                    }
                }
            }
        }
        catch (EMFSecurityException ex) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("CamSecurityException when retrieving details for history with path [" + historyPath + "].");
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(ex.getMessage());
        }
        catch (SDKClientException ex) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("SDKClientException when retrieving details for history with path [" + historyPath + "].");
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.INFO, ex);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        BaseHistoryDetail[] details = new BaseHistoryDetail[detailsList.size()];
        return detailsList.toArray(details);
    }
}

