/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.AuditStatus;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.TrustedSession;
import java.util.BitSet;

public class ConnectionPool {
    private static final ConnectionPool instance = new ConnectionPool();
    private CAMFactory camFactory = null;
    private boolean poolDisposed = false;
    private boolean poolInitialized = false;
    private int maximumPoolSize = 100;
    private boolean nonBlocking = false;
    private BitSet allocatedConnections;
    private TrustedSession[] clientConnections;
    private boolean disposeUponFailure = false;

    private ConnectionPool() {
        try {
            String poolSize = CRNProperties.getInstance().getProperty("trustedSession.pool.max");
            this.maximumPoolSize = Integer.parseInt(poolSize);
            this.messageOut("trustedSession connectionPool max set to : " + this.maximumPoolSize, SDSLevel.INFO, null, AuditStatus.BLANK);
        }
        catch (PropertiesException e) {
            this.messageOut("Error retrieving property 'trustedSession.pool.max'.  Property is either not set, or is badly configured.  SDS will use default value of :" + this.maximumPoolSize, SDSLevel.ERROR, I18NCode.OTH_PROPS_ERROR, "Failure");
        }
        catch (NumberFormatException e) {
            this.messageOut("Error retrieving property 'trustedSession.pool.max'.  Property is either not set, or is badly configured.  SDS will use default value of :" + this.maximumPoolSize, SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, "Failure");
        }
        if (this.maximumPoolSize < 1) {
            this.maximumPoolSize = 1;
        }
        this.allocatedConnections = new BitSet(this.maximumPoolSize);
        this.clientConnections = new TrustedSession[this.maximumPoolSize];
        this.camFactory = new CAMFactory();
        int numberOfSessionsToInit = Math.min(this.maximumPoolSize, 5);
        try {
            this.camFactory.initialize("<initializeDocument><serviceID>SDS</serviceID></initializeDocument>".getBytes());
            for (int i = 0; i < numberOfSessionsToInit; ++i) {
                TrustedRequestSession trs = this.camFactory.createTrustedSession();
                this.clientConnections[i] = new TrustedSession(trs, i);
            }
        }
        catch (CAMCryptoException e) {
            this.messageOut("Error initializing CAMFactory in SDS ConnectionPool " + e.getMessage(), SDSLevel.FATAL, I18NCode.GEN_THROWABLE_ERROR, "Failure");
        }
    }

    private void messageOut(String message, SDSLevel sdsLevel, I18NCode i18NCode, String ipfStatus) {
        SDSLogger.getLogger(JSMCommonCategory.TRACE).log(sdsLevel, i18NCode, new String[]{message});
    }

    public static ConnectionPool getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustedSession getSession() throws IllegalStateException {
        int nextAvailablePosition = -1;
        TrustedSession aConnection = null;
        while (true) {
            if (this.poolDisposed) {
                throw new IllegalStateException("The connection pool has been shutdown");
            }
            nextAvailablePosition = this.testAndSetNextAvailable();
            if (nextAvailablePosition == -1) {
                try {
                    if (this.nonBlocking) {
                        return null;
                    }
                    ConnectionPool connectionPool = this;
                    synchronized (connectionPool) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.messageOut("Acquired connection " + nextAvailablePosition, SDSLevel.INFO, null, "Success");
            aConnection = this.assignConnection(nextAvailablePosition);
            if (aConnection != null) break;
            String s = "ConnectionPool - problem creating Trusted Request session - retrying" + nextAvailablePosition;
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_IS_NULL);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{s});
            this.release(nextAvailablePosition);
        }
        return aConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustedSession assignConnection(int position) {
        if (this.clientConnections[position] == null) {
            CAMFactory cAMFactory = this.camFactory;
            synchronized (cAMFactory) {
                try {
                    TrustedRequestSession trs = this.camFactory.createTrustedSession();
                    this.clientConnections[position] = new TrustedSession(trs, position);
                }
                catch (Throwable e) {
                    this.clientConnections[position] = null;
                }
            }
        }
        return this.clientConnections[position];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int testAndSetNextAvailable() {
        int selectedPosition = -1;
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            for (int i = 0; i < this.maximumPoolSize; ++i) {
                if (this.allocatedConnections.get(i)) continue;
                selectedPosition = i;
                this.allocatedConnections.set(selectedPosition);
                break;
            }
        }
        return selectedPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int position) {
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            this.allocatedConnections.clear(position);
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                this.notify();
            }
        }
        this.messageOut("Released connection " + position + " - " + this.checkAvailableConnections() + " free connections available", SDSLevel.INFO, null, "Success");
    }

    private int checkAvailableConnections() {
        int available = 0;
        for (int i = 0; i < this.maximumPoolSize; ++i) {
            if (this.allocatedConnections.get(i)) continue;
            ++available;
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.poolDisposed) {
            return;
        }
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            this.poolDisposed = true;
            this.camFactory.terminate();
        }
    }

    public void setNonBlocking(boolean b) {
        this.nonBlocking = b;
    }

    public boolean isDisposed() {
        return this.poolDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            for (int i = 0; i < this.maximumPoolSize; ++i) {
                if (!this.allocatedConnections.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    boolean isDisposeUponFailure() {
        return this.disposeUponFailure;
    }

    public void setDisposeUponFailure(boolean b) {
        this.disposeUponFailure = b;
    }
}

