/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.IClientBase;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;

public class CredentialUtil {
    private CredentialUtil() {
    }

    public static String getCamCredentials(JobBiBusHeaders headers) throws EMFSecurityException {
        BiBusHeader header = headers.getBiBusHeader();
        String credentialPath = headers.getCamCredential();
        if (credentialPath == null && ((credentialPath = CredentialUtil.getUserCredentialPath(header)) == null || credentialPath.length() == 0)) {
            AuthenticatorFactory.getInstance().generateTC(header);
            credentialPath = CredentialUtil.getUserCredentialPath(header);
        }
        return credentialPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserCredentialPath(BiBusHeader header) {
        String path = header.getCAM().getCAMCredentialPath();
        if (path == null) {
            IClientBase cm = null;
            try {
                cm = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
                BaseClass[] classes = cm.query(new SearchPathMultipleObject("~/credential"), new PropEnum[]{PropEnum.searchPath}, new Sort[0], new QueryOptions());
                if (classes != null && classes.length >= 1) {
                    StringProp prop = classes[0] != null ? classes[0].getSearchPath() : null;
                    path = prop != null ? prop.getValue() : path;
                }
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            }
            finally {
                if (cm != null) {
                    cm.close();
                }
            }
        }
        return path;
    }
}

