/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.DocumentContent;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.NonNegativeIntegerProp;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.jsmcommon.property.CRNProperties;
import java.math.BigInteger;

public class DataSizeChecker {
    public static final int MEGABYTE_IN_BYTES = 0x100000;
    private static final double HIGH_LIMIT_MB = 2047.0;

    public static double getPropertySizeLimitValue(String sizeLimitProperty) {
        Double limit = 0.0;
        try {
            String limit_string = CRNProperties.getInstance().getProperty(sizeLimitProperty);
            if (limit_string != null) {
                limit = Double.valueOf(limit_string);
                if (limit < 0.0) {
                    limit = 0.0;
                } else if (limit > 2047.0) {
                    limit = 2047.0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return limit;
    }

    public static BigInteger getAgentConditionDataSize() {
        CRNProperties theProperties = CRNProperties.getInstance();
        int agentConditionSizeLimitMB = theProperties.getIntProperty("asMaximumAgentConditionSize", 15);
        return BigInteger.valueOf((long)agentConditionSizeLimitMB * 0x100000L);
    }

    public static boolean isAttachmentSizeOKASV(long size) {
        long sizeLimit = Math.round(DataSizeChecker.getPropertySizeLimitValue("asMaximumEMailAttachmentSize") * 1048576.0);
        return DataSizeChecker.checkSize(size, sizeLimit);
    }

    public static boolean checkSize(long size, long sizeLimit) {
        return sizeLimit <= 0L || size < sizeLimit;
    }

    public static boolean hasData(Object obj) {
        boolean hasData = false;
        if (obj instanceof Output) {
            Output output = (Output)obj;
            hasData = output.getData() != null && output.getData().getValue().length > 0;
        } else if (obj instanceof MemoPartMIMEAttachment) {
            MemoPartMIMEAttachment mpma = (MemoPartMIMEAttachment)obj;
            hasData = mpma.getData() != null && mpma.getData().length > 0;
        } else if (obj instanceof DocumentContent) {
            DocumentContent docContent = (DocumentContent)obj;
            hasData = docContent.getData() != null && docContent.getData().getValue().length > 0;
        }
        return hasData;
    }

    public static long getObjectSize(Object obj) {
        long size = 0L;
        if (obj instanceof Output) {
            Output output = (Output)obj;
            size = DataSizeChecker.getSize(output.getDataSize());
        } else if (obj instanceof MemoPartMIMEAttachment) {
            byte[] data;
            MemoPartMIMEAttachment mpma = (MemoPartMIMEAttachment)obj;
            BigInteger biSize = mpma.getDataSize();
            size = biSize != null && !biSize.equals(BigInteger.ZERO) ? (long)biSize.intValue() : ((data = mpma.getData()) != null ? (long)data.length : 0L);
        } else if (obj instanceof DocumentContent) {
            DocumentContent docContent = (DocumentContent)obj;
            size = DataSizeChecker.getSize(docContent.getDataSize());
        }
        return size;
    }

    public static long getSize(NonNegativeIntegerProp dataSizeProp) {
        BigInteger dataSizeBigInt;
        long size = 0L;
        if (dataSizeProp != null && (dataSizeBigInt = dataSizeProp.getValue()) != null) {
            size = dataSizeBigInt.longValue();
        }
        return size;
    }
}

