/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class FileUtil {
    public static String stripFileExtension(String file) {
        String[] parts = FileUtil.getFileNameParts(file);
        return parts[0];
    }

    public static String[] getFileNameParts(String file) {
        String[] parts = new String[]{"", ""};
        if (file != null) {
            parts = file.split("\\.");
            if (parts.length > 2) {
                String[] splitParts = parts;
                parts = new String[]{"", ""};
                for (int i = 0; i < splitParts.length - 1; ++i) {
                    parts[0] = parts[0] + splitParts[i];
                    if (i == splitParts.length - 2) continue;
                    parts[0] = parts[0] + ".";
                }
                parts[1] = splitParts[splitParts.length - 1];
            } else if (parts.length == 1) {
                parts = new String[]{parts[0], ""};
            } else if (parts.length == 0) {
                parts = new String[]{"", ""};
            }
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copy(File inputFile, String newFileName) throws IOException {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        File outputFile = new File(inputFile.getParent(), newFileName);
        try {
            int singleByte;
            FileInputStream fis = new FileInputStream(inputFile);
            bis = new BufferedInputStream(fis);
            FileOutputStream fos = new FileOutputStream(outputFile);
            FileDescriptor fd = fos.getFD();
            bos = new BufferedOutputStream(fos);
            while ((singleByte = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(singleByte);
            }
            fd.sync();
        }
        finally {
            if (bis != null) {
                bis.close();
                if (bos != null) {
                    bos.close();
                }
            }
        }
        return outputFile;
    }
}

