/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.jsmcommon.util.IHashList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HashList<K, V>
implements IHashList<K, V> {
    private Map<K, List<V>> m_map;

    public HashList() {
        this.m_map = new HashMap<K, List<V>>();
    }

    public HashList(int size) {
        this.m_map = new HashMap<K, List<V>>(size);
    }

    public HashList(Map<K, List<V>> map) {
        if (map != null) {
            this.m_map = map;
        } else {
            map = new HashMap<K, List<List<V>>>();
        }
    }

    @Override
    public V get(K key, int index) {
        return this.getList(key).get(index);
    }

    @Override
    public int getSize(K key) {
        return this.getList(key).size();
    }

    @Override
    public void put(K key, List<V> list) {
        this.m_map.put(key, list);
    }

    @Override
    public void put(K key, V value, int index) {
        this.getList(key).add(index, value);
    }

    @Override
    public void clear(K key) {
        this.getList(key).clear();
    }

    @Override
    public V remove(K key, int index) {
        V obj = null;
        List<V> list = this.getList(key);
        obj = list.remove(index);
        if (list.isEmpty()) {
            this.m_map.remove(key);
        }
        return obj;
    }

    @Override
    public V remove(K key, V object) {
        V obj = null;
        List<V> list = this.getList(key);
        if (list.remove(object)) {
            obj = object;
        }
        if (list.isEmpty()) {
            this.m_map.remove(key);
        }
        return obj;
    }

    public int size() {
        return this.m_map.size();
    }

    public int totalSize() {
        Set<K> keys = this.m_map.keySet();
        int total = 0;
        for (K key : keys) {
            total += this.getSize(key);
        }
        return total;
    }

    public boolean isEmpty() {
        return this.m_map.size() == 0;
    }

    @Override
    public boolean isEmpty(K key) {
        return this.getList(key).size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.m_map.containsKey(key);
    }

    public boolean containsValue(Object list) {
        return this.m_map.containsValue(list);
    }

    @Override
    public boolean contains(K key, V value) {
        boolean contains = this.m_map.containsKey(key);
        if (contains) {
            contains = this.getList(key).contains(value);
        }
        return contains;
    }

    @Override
    public List<V> get(K key) {
        return this.getList(key);
    }

    @Override
    public void put(K key, V value) {
        List<V> list = this.getList(key);
        list.add(value);
    }

    public Object remove(Object key) {
        return this.m_map.remove(key);
    }

    @Override
    public V removeLast(K key) {
        V object_return = null;
        List<V> list = this.getList(key);
        int last_index = list.size() - 1;
        if (last_index >= 0) {
            object_return = list.remove(last_index);
        }
        if (list.isEmpty()) {
            this.m_map.remove(key);
        }
        return object_return;
    }

    @Override
    public V getFirst(K key) {
        V object_return = null;
        List<V> list = this.getList(key);
        if (list.size() > 0) {
            object_return = list.get(0);
        }
        return object_return;
    }

    @Override
    public List<V> getFirstValues() {
        ArrayList<V> firstList = new ArrayList<V>();
        Set<K> keyset = this.keySet();
        for (K key : keyset) {
            firstList.add(this.getFirst(key));
        }
        return firstList;
    }

    @Override
    public V getLast(K key) {
        V object_return = null;
        List<V> list = this.getList(key);
        int last_index = list.size() - 1;
        if (last_index >= 0) {
            object_return = list.get(last_index);
        }
        return object_return;
    }

    @Override
    public V removeFirst(K key) {
        V object_return = null;
        List<V> list = this.getList(key);
        if (list.size() > 0) {
            object_return = list.remove(0);
        }
        if (list.isEmpty()) {
            this.m_map.remove(key);
        }
        return object_return;
    }

    public boolean validateIndex(K key, int index) {
        return index >= 0 && index < this.getList(key).size();
    }

    public void putAll(Map<K, List<V>> t) {
        for (Map.Entry<K, List<V>> entry : t.entrySet()) {
            if (entry.getValue() instanceof List) {
                this.m_map.put(entry.getKey(), entry.getValue());
                continue;
            }
            throw new UnsupportedOperationException("The map entries in a noticecast.util.HashList must be java.util.List");
        }
    }

    public void clear() {
        this.m_map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.m_map.keySet();
    }

    public Collection<V> values() {
        ArrayList<V> contents_list = new ArrayList<V>();
        for (List<V> entry_list : this.m_map.values()) {
            Iterator<V> hashed_list_iter = entry_list.iterator();
            while (hashed_list_iter.hasNext()) {
                contents_list.add(hashed_list_iter.next());
            }
        }
        return contents_list;
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.m_map.entrySet();
    }

    public List<V> getList(K key) {
        List<V> list = this.m_map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.m_map.put(key, list);
        }
        return list;
    }

    public V[] getArray(K key, V[] array) {
        List<V> list = this.getList(key);
        return list.toArray(array);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<K, List<V>> item : this.m_map.entrySet()) {
            List<V> values = item.getValue();
            K key = item.getKey();
            buffer.append("\nKey: ");
            buffer.append(key.toString());
            for (int i = 0; i < values.size(); ++i) {
                buffer.append("\nValue " + i + ": ");
                buffer.append(values.get(i).toString());
                buffer.append(", ");
            }
            buffer.append("\n ");
        }
        return buffer.toString();
    }

    public V[] toArray(V[] array) {
        return this.values().toArray(array);
    }
}

