/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.UserAccountUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class Headers
implements Serializable {
    static final long serialVersionUID = 70009003L;
    private BiBusHeader header;
    private List<Element> extraHeaders = new ArrayList<Element>();
    private Element wsAddressingHeader;

    public Headers(BiBusHeader header) {
        this.header = header;
    }

    public BiBusHeader getBiBusHeader() {
        return this.header;
    }

    public void setBiBusHeader(BiBusHeader header) {
        this.header = header;
    }

    public List<Element> getExtraHeaders() {
        return this.extraHeaders;
    }

    public void setExtraHeaders(List<Element> extraHeaders) {
        this.extraHeaders = extraHeaders;
    }

    public void addExtraHeader(Element extraHeader) {
        this.extraHeaders.add(extraHeader);
    }

    public void updateExtraHeader(Element extraHeader) {
        Element[] elements = new Element[this.extraHeaders.size()];
        this.extraHeaders.toArray(elements);
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].getName().equals(extraHeader.getName())) continue;
            this.extraHeaders.remove(elements[i]);
        }
        this.extraHeaders.add(extraHeader);
    }

    public String getCredential() {
        String credential = null;
        if (this.header.getCAM() != null && this.header.getCAM().getCAMCredentialPath() != null) {
            credential = this.header.getCAM().getCAMCredentialPath();
        }
        if (credential == null) {
            UserAccountUtil uau = new UserAccountUtil(new JobBiBusHeaders(this.header));
            credential = uau.getUserAccount().getSearchPath().getValue() + "/credential";
        }
        return credential;
    }

    public Element getReplyToElement() {
        Iterator<Element> it = this.extraHeaders.iterator();
        while (it.hasNext() && this.wsAddressingHeader == null) {
            Element headerNode = it.next();
            if (!headerNode.getName().equals("ReplyTo")) continue;
            this.wsAddressingHeader = headerNode;
        }
        return this.wsAddressingHeader;
    }

    public String getHeaderContent(String name) {
        Iterator<Element> it = this.extraHeaders.iterator();
        String val = null;
        while (it.hasNext() && this.wsAddressingHeader == null) {
            Element headerNode = it.next();
            if (!headerNode.getName().equals(name)) continue;
            val = headerNode.getText();
        }
        return val;
    }

    public Element getTo() {
        Iterator<Element> it = this.extraHeaders.iterator();
        Element doc = null;
        while (it.hasNext() && doc == null) {
            Element headerNode = it.next();
            if (!headerNode.getName().equals("To")) continue;
            doc = headerNode;
        }
        return doc;
    }

    public String getProductLanguage() {
        String lang = "";
        BiBusHeader header = this.getBiBusHeader();
        if (header != null) {
            UserPreferenceVar[] prefs = header.getUserPreferenceVars();
            boolean found = false;
            if (prefs != null) {
                for (int i = 0; !found && i < prefs.length; ++i) {
                    UserPreferenceVar pref = prefs[i];
                    if (!"productLocale".equalsIgnoreCase(pref.getName())) continue;
                    lang = pref.getValue();
                    found = true;
                }
            }
        }
        return lang;
    }
}

