/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

public class HexFormatter {
    public static String toHex(byte b, int length) {
        return HexFormatter.formatLength(Integer.toString(b & 0xFF, 16), length);
    }

    public static String toHex(short s, int length) {
        return HexFormatter.formatLength(Integer.toString(s & 0xFFFF, 16), length);
    }

    public static String toHex(int i, int length) {
        return HexFormatter.formatLength(Long.toString((long)i & 0xFFFFFFFFL, 16), length);
    }

    public static String toHex(long l, int length) {
        String value = (l & 0xF000000000000000L) != 0L ? Long.toString(l >>> 60, 16) + HexFormatter.toHex(l & 0xFFFFFFFFFFFFFFFL, 15) : Long.toString(l, 16);
        return HexFormatter.formatLength(value, length);
    }

    private static String formatLength(String s, int length) {
        StringBuffer buffer = new StringBuffer();
        if (s.length() < length) {
            for (int i = 0; i < length - s.length(); ++i) {
                buffer.append("0");
            }
            buffer.append(s);
        } else if (s.length() > length) {
            buffer.append(s.substring(s.length() - length));
        } else {
            buffer.append(s);
        }
        return buffer.toString();
    }
}

