/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ObjectModelUtil;

public class HistoryUpdateTrustedChecker {
    private JobBiBusHeaders m_header;

    public HistoryUpdateTrustedChecker(BiBusHeader header) {
        this.m_header = new JobBiBusHeaders(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean determineTrustedFlagState(String searchPath) throws SDKClientException, EMFSecurityException {
        boolean useTrusted = false;
        BaseClass baseClass = null;
        ContentManagerServiceClientPort cmPort = null;
        try {
            cmPort = Client.instance().getContentManagerServiceClient(this.m_header);
            baseClass = ObjectModelUtil.getBaseClass(cmPort, searchPath, ObjectModelUtil.PERMISSSION_PROPS);
            if (baseClass == null) {
                String resolvedPath = this.existsInCM(cmPort, searchPath);
                if (resolvedPath != null) {
                    useTrusted = true;
                }
            } else if (!AuthenticatorFactory.getInstance().hasPermissions(baseClass, new String[]{"execute"})) {
                useTrusted = true;
            } else if (!AuthenticatorFactory.getInstance().hasPermissions(baseClass, new String[]{"write"})) {
                useTrusted = true;
            }
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return useTrusted;
    }

    private String existsInCM(ContentManagerServiceClientPort cmPort, String searchPath) {
        String path = null;
        try {
            PropEnum[] props = new PropEnum[]{PropEnum.searchPath};
            this.signNextRequest(cmPort);
            BaseClass[] baseClasses = cmPort.query(new SearchPathMultipleObject(searchPath), props, null, new QueryOptions());
            if (baseClasses != null && baseClasses.length >= 1) {
                path = baseClasses[0].getSearchPath() != null ? baseClasses[0].getSearchPath().getValue() : null;
            }
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(this.getClass().getName() + ".existsInCM(" + searchPath + ") - CM query threw an SDKClientException: " + e.getLocalizedMessage());
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(this.getClass().getName() + ".existsInCM(" + searchPath + ") - CM query threw a EMFSecurityException: " + e.getLocalizedMessage());
        }
        return path;
    }

    private void signNextRequest(ContentManagerServiceClientPort cmPort) {
        BiBusHeader header = cmPort.getBiBusHeader();
        CAM cam = header.getCAM();
        if (cam != null) {
            header.setCAM(null);
        }
        cmPort.setBiBusHeader(header);
        cmPort.signNextRequest("JSM");
    }
}

