/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportValidation;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.HashList;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.axis.AxisFault;

public class I18NMessageUtil {
    private HashList m_problems = new HashList();
    private static final SeverityEnum[] m_all_severities = new SeverityEnum[]{SeverityEnum.fatal, SeverityEnum.error, SeverityEnum.warn, SeverityEnum.info, SeverityEnum.debug};

    public int size() {
        return this.m_problems.size();
    }

    public I18NMessage[] getMessages() {
        Object[] array = this.m_problems.toArray(new Object[0]);
        return this.getNoDupMessages(array);
    }

    public I18NMessage[] getMessages(SeverityEnum severity) {
        Object[] array = this.m_problems.getList(severity).toArray(new Object[0]);
        return this.getNoDupMessages(array);
    }

    public I18NMessage[] getNoDupMessages(Object[] array) {
        ArrayList<Object> messages = new ArrayList<Object>();
        ArrayList noDupCodeList = new ArrayList();
        for (int i = 0; i < array.length; ++i) {
            I18NMessage m;
            Object element = array[i];
            if (!(element instanceof I18NMessage) || noDupCodeList.contains(m = (I18NMessage)element)) continue;
            messages.add(element);
        }
        I18NMessage[] localisedMessages = new I18NMessage[messages.size()];
        messages.toArray(localisedMessages);
        return localisedMessages;
    }

    public void addMessages(I18NMessage[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            this.addMessage(messages[i]);
        }
    }

    public void addMessage(I18NMessage message) {
        this.m_problems.put(message.getSeverity(), message);
    }

    public AsynchDetailReportValidation[] getAsynchDetail() throws AxisFault {
        Locale locale = LocaleUtil.getRequestProductLocale(BiBusUtilities.extractBiBusHeader());
        ArrayList<AsynchDetailReportValidation> allDetails = new ArrayList<AsynchDetailReportValidation>();
        for (int i = 0; i < m_all_severities.length; ++i) {
            AsynchDetailReportValidation[] details = this.getAsynchDetail(m_all_severities[i], locale);
            allDetails.addAll(Arrays.asList(details));
        }
        AsynchDetailReportValidation[] reply = new AsynchDetailReportValidation[allDetails.size()];
        allDetails.toArray(reply);
        return reply;
    }

    public AsynchDetailReportValidation[] getAsynchDetail(SeverityEnum severity, Locale locale) {
        List things = this.m_problems.getList(severity);
        AsynchDetailReportValidation[] details = new AsynchDetailReportValidation[things.size()];
        for (int i = 0; i < things.size(); ++i) {
            Object thing = things.get(i);
            if (!(thing instanceof I18NMessage)) continue;
            I18NMessage message = (I18NMessage)thing;
            details[i] = new AsynchDetailReportValidation();
            XmlEncodedXML xml = new XmlEncodedXML();
            xml.set_value(message.getMessage(locale));
            details[i].setDefects(xml);
            details[i].setMaximumSeverity(ObjectModelUtil.convert(severity));
        }
        return details;
    }

    public static I18NMessage[] getMessages(AsynchDetail[] details, I18NCode wrapper) {
        ArrayList<I18NMessage> messages = new ArrayList<I18NMessage>();
        for (int i = 0; i < details.length; ++i) {
            if (!(details[i] instanceof AsynchDetailReportValidation)) continue;
            AsynchDetailReportValidation validationDetail = (AsynchDetailReportValidation)details[i];
            messages.add(I18NMessageUtil.getMessage(validationDetail, wrapper));
        }
        return messages.toArray(new I18NMessage[messages.size()]);
    }

    public static I18NMessage getMessage(AsynchDetailReportValidation validationDetail, I18NCode wrapper) {
        return new I18NMessage(wrapper, new Object[]{validationDetail.getDefects()}, ObjectModelUtil.convert(validationDetail.getMaximumSeverity()));
    }

    public static SeverityEnum[] getMatchingSeverities(SeverityEnum severity) {
        ArrayList<SeverityEnum> severities = new ArrayList<SeverityEnum>();
        for (int i = 0; i < m_all_severities.length; ++i) {
            if (ObjectModelUtil.compareSeverity(severity, m_all_severities[i]) < 0) continue;
            severities.add(m_all_severities[i]);
        }
        return severities.toArray(new SeverityEnum[0]);
    }
}

