/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAXPUtils {
    private static String normalize(String s, boolean bCanonical) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (bCanonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        continue block7;
                    }
                    str.append(ch);
                    continue block7;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static void printChildNode(Node oNode, Writer out, boolean bCanonical) throws IOException {
        if (oNode == null) {
            return;
        }
        NodeList oChildren = oNode.getChildNodes();
        int iChildLen = oChildren == null ? 0 : oChildren.getLength();
        for (int i = 0; i < iChildLen; ++i) {
            JAXPUtils.printNode(oChildren.item(i), out, bCanonical);
        }
    }

    public static void printNode(Node oNode, Writer out, boolean bCanonical) throws IOException {
        if (oNode == null) {
            return;
        }
        switch (oNode.getNodeType()) {
            case 9: {
                if (!bCanonical) {
                    out.write("<?xml version=\"1.0\"?>");
                }
                JAXPUtils.printNode(((Document)oNode).getDocumentElement(), out, bCanonical);
                out.flush();
                break;
            }
            case 1: {
                out.write(60);
                out.write(oNode.getNodeName());
                NamedNodeMap oAttrMap = oNode.getAttributes();
                int iAttrLen = oAttrMap == null ? 0 : oAttrMap.getLength();
                for (int i = 0; i < iAttrLen; ++i) {
                    Attr oAttr = (Attr)oAttrMap.item(i);
                    out.write(32);
                    out.write(oAttr.getNodeName());
                    out.write("=\"");
                    out.write(JAXPUtils.normalize(oAttr.getNodeValue(), bCanonical));
                    out.write(34);
                }
                out.write(62);
                NodeList oChildren = oNode.getChildNodes();
                int iChildLen = oChildren == null ? 0 : oChildren.getLength();
                for (int i = 0; i < iChildLen; ++i) {
                    JAXPUtils.printNode(oChildren.item(i), out, bCanonical);
                }
                break;
            }
            case 5: {
                if (bCanonical) {
                    NodeList oEntityChildren = oNode.getChildNodes();
                    int oChildLen = oEntityChildren == null ? 0 : oEntityChildren.getLength();
                    for (int i = 0; i < oChildLen; ++i) {
                        JAXPUtils.printNode(oEntityChildren.item(i), out, bCanonical);
                    }
                    break;
                }
                out.write(38);
                out.write(oNode.getNodeName());
                out.write(59);
                break;
            }
            case 4: {
                if (bCanonical) {
                    out.write(JAXPUtils.normalize(oNode.getNodeValue(), bCanonical));
                    break;
                }
                out.write("<![CDATA[");
                out.write(oNode.getNodeValue());
                out.write("]]>");
                break;
            }
            case 3: {
                out.write(JAXPUtils.normalize(oNode.getNodeValue(), bCanonical));
                break;
            }
            case 7: {
                out.write("<?");
                out.write(oNode.getNodeName());
                String data = oNode.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.write(32);
                    out.write(data);
                }
                out.write("?>");
            }
        }
        if (oNode.getNodeType() == 1) {
            out.write("</");
            out.write(oNode.getNodeName());
            out.write(62);
        }
        out.flush();
    }
}

