/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Locale;

public class LocaleUtil {
    private static ICCLConfiguration icclConfig = CCLConfigurationFactory.getInstance();
    public static final String PRODUCT_LOCALE_STRING = "productLocale";
    public static final String CONTENT_LOCALE_STRING = "contentLocale";
    public static final int CONTENT_LOCALE_TYPE = 1;
    public static final int PRODUCT_LOCALE_TYPE = 2;
    public static final int GENERAL_LOCALE_TYPE = 3;

    public static ICCLConfiguration getICCLConfiguration() {
        return icclConfig;
    }

    public static void setCCLConfigurationForTesting(ICCLConfiguration testConfig) {
        icclConfig = testConfig;
    }

    public static Locale getProductLocale(BiBusHeader header) {
        UserPreferenceVar[] preferences = header.getUserPreferenceVars();
        if (preferences == null) {
            return LocaleUtil.getServerLocale();
        }
        String localeString = null;
        for (int i = 0; localeString == null && i < preferences.length; ++i) {
            if (!preferences[i].getName().equals(PRODUCT_LOCALE_STRING)) continue;
            localeString = preferences[i].getValue();
        }
        return LocaleUtil.getLocale(localeString);
    }

    public static Locale getServerLocale() {
        String localeString = CRNProperties.getInstance().getProperties().getProperty("serverLocale");
        Locale locale = LocaleUtil.getLocale(localeString);
        return locale;
    }

    private static boolean validCode(String code, String[] choices) {
        boolean found = false;
        for (int i = 0; i < choices.length && !found; ++i) {
            if (!choices[i].equalsIgnoreCase(code)) continue;
            found = true;
        }
        return found;
    }

    public static final Locale getRequestProductLocale(BiBusHeader header) {
        Locale locale = Locale.getDefault();
        try {
            String id = LocaleUtil.getUserPreference(PRODUCT_LOCALE_STRING, header);
            locale = id != null ? LocaleUtil.getLocale(id) : locale;
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_EXTRACTING_HEADER, new String[]{e.getMessage() + ":3"});
        }
        return locale;
    }

    public static final Locale getRequestContentLocale(BiBusHeader header) {
        Locale locale = Locale.getDefault();
        try {
            String id = LocaleUtil.getUserPreference(CONTENT_LOCALE_STRING, header);
            locale = id != null ? LocaleUtil.getLocale(id) : locale;
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_ERROR_EXTRACTING_HEADER, new String[]{e.getMessage() + ":3"});
        }
        return locale;
    }

    public static final String getUserPreference(String key, BiBusHeader headers) throws Exception {
        UserPreferenceVar[] preferences = headers.getUserPreferenceVars();
        String value = null;
        for (int i = 0; value == null && i < preferences.length; ++i) {
            if (!preferences[i].getName().equals(key)) continue;
            value = preferences[i].getValue();
        }
        return value;
    }

    public static synchronized Locale getLocale(String localeString) {
        if (localeString == null || "".equals(localeString)) {
            return Locale.getDefault();
        }
        int separator_position = Math.max(localeString.indexOf("-"), localeString.indexOf("_"));
        String language = separator_position == -1 ? localeString.trim().toLowerCase() : localeString.substring(0, separator_position).trim().toLowerCase();
        String country = separator_position == -1 ? "" : localeString.substring(separator_position + 1, localeString.length()).trim().toUpperCase();
        Locale locale = LocaleUtil.validCode(language, Locale.getISOLanguages()) && LocaleUtil.validCode(country, Locale.getISOCountries()) ? new Locale(language, country) : null;
        locale = locale == null && LocaleUtil.validCode(language, Locale.getISOLanguages()) ? new Locale(language, "") : locale;
        return locale == null ? Locale.getDefault() : locale;
    }

    public static Locale createContentLocale(String theContentLocaleString) {
        return LocaleUtil.createLocaleObject(1, theContentLocaleString);
    }

    public static Locale createProductLocale(String theProductLocaleString) {
        return LocaleUtil.createLocaleObject(2, theProductLocaleString);
    }

    private static Locale createLocaleObject(int localeTypeToMap, String theLocaleString) {
        Locale locale = null;
        if (theLocaleString != null && theLocaleString.length() > 0) {
            try {
                String normalizedLocaleString = null;
                switch (localeTypeToMap) {
                    case 1: {
                        normalizedLocaleString = LocaleUtil.getICCLConfiguration().mapContentLocale(theLocaleString, true);
                        break;
                    }
                    case 2: {
                        normalizedLocaleString = LocaleUtil.getICCLConfiguration().mapProductLocale(theLocaleString, true);
                        break;
                    }
                    default: {
                        normalizedLocaleString = LocaleUtil.getICCLConfiguration().normalizeLocale(theLocaleString);
                    }
                }
                locale = LocaleUtil.getLocale(normalizedLocaleString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

