/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.AddressSMTP;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionAddressSMTPArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionSearchPathMultipleObjectArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionString;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartAgentObject;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObjectLinks;
import com.cognos.developer.schemas.bibus._3.MemoPartString;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.developer.schemas.bibus._3.SmtpContentTypeEnum;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MemoOptionsBuilder {
    private static Set<DeliveryOptionEnum> externallAddressStyles = new HashSet<DeliveryOptionEnum>();
    private List<DeliveryOption> m_options = new ArrayList<DeliveryOption>();

    public List<DeliveryOption> getOptions() {
        return this.m_options;
    }

    public DeliveryOption[] getOptionsArray() {
        return this.m_options.toArray(new DeliveryOption[0]);
    }

    public void addOption(DeliveryOption option) {
        this.m_options.add(option);
    }

    public void addBody(String body) {
        DeliveryOptionMemoPart memo = new DeliveryOptionMemoPart();
        memo.setName(DeliveryOptionEnum.memoPart);
        MemoPart[] memoParts = new MemoPart[2];
        MemoPartString stringText = new MemoPartString();
        stringText.setContentDisposition(SmtpContentDispositionEnum.inline);
        stringText.setText(body);
        memoParts[0] = stringText;
        MemoPartMIMEAttachment htmlText = new MemoPartMIMEAttachment();
        htmlText.setContentDisposition(SmtpContentDispositionEnum.inline);
        htmlText.setData(body.getBytes());
        htmlText.setDataType("text/html");
        memoParts[1] = htmlText;
        MemoPartComposite composite = new MemoPartComposite();
        composite.setContentDisposition(SmtpContentDispositionEnum.inline);
        composite.setContentType(SmtpContentTypeEnum.alternative);
        composite.setParts(memoParts);
        memo.setValue((MemoPart)composite);
        this.m_options.add((DeliveryOption)memo);
    }

    public void addBody(String subject, String bodyPlain, String bodyHTML) {
        this.addSubject(subject);
        DeliveryOptionMemoPart memo = new DeliveryOptionMemoPart();
        memo.setName(DeliveryOptionEnum.memoPart);
        MemoPart[] memoParts = new MemoPart[2];
        MemoPartString stringText = new MemoPartString();
        stringText.setContentDisposition(SmtpContentDispositionEnum.inline);
        stringText.setText(bodyPlain);
        memoParts[0] = stringText;
        MemoPartMIMEAttachment htmlText = new MemoPartMIMEAttachment();
        htmlText.setContentDisposition(SmtpContentDispositionEnum.inline);
        try {
            htmlText.setData(bodyHTML.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        htmlText.setDataType("text/html;charset=\"UTF-8\"");
        memoParts[1] = htmlText;
        MemoPartComposite composite = new MemoPartComposite();
        composite.setContentDisposition(SmtpContentDispositionEnum.inline);
        composite.setContentType(SmtpContentTypeEnum.alternative);
        composite.setParts(memoParts);
        memo.setValue((MemoPart)composite);
        this.m_options.add((DeliveryOption)memo);
    }

    public void addLink(String label, ClassEnum objectClass, String searchPath) {
        MemoPartObjectLinks memoPartObjectLinks = null;
        DeliveryOptionMemoPart memoPartDeliveryOption = this.getMemoPart();
        if (memoPartDeliveryOption != null) {
            ObjectLink[] links = new ObjectLink[]{};
            memoPartObjectLinks = this.getLinks(memoPartDeliveryOption);
            if (memoPartObjectLinks == null) {
                memoPartObjectLinks = new MemoPartObjectLinks();
                links = memoPartObjectLinks.getLinks();
            }
            ObjectLink link = new ObjectLink();
            link.setLabel(label);
            link.setObjectClass(objectClass);
            link.setSearchPath(new SearchPathSingleObject(searchPath));
            if (links.length > 0) {
                ObjectLink[] newLinks = new ObjectLink[links.length + 1];
                System.arraycopy(links, 0, newLinks, 0, links.length);
                links = newLinks;
            } else {
                links = new ObjectLink[1];
            }
            memoPartObjectLinks.setLinks(links);
            this.appendToMemoPart(memoPartDeliveryOption, (MemoPart)memoPartObjectLinks);
        }
    }

    public void addAttachment(String name, String locale, String format, String searchPath) {
        DeliveryOptionMemoPart memoPartDeliveryOption = this.getMemoPart();
        if (memoPartDeliveryOption != null) {
            MemoPartAgentObject link = new MemoPartAgentObject();
            link.setContentDisposition(SmtpContentDispositionEnum.attachment);
            link.setFormat(format);
            link.setLocale(locale);
            link.setName(name);
            link.setSearchPath(new SearchPathSingleObject(searchPath));
            this.appendToMemoPart(memoPartDeliveryOption, (MemoPart)link);
        }
    }

    public void addAttachment(MemoPartAgentObject attachment) {
        DeliveryOptionMemoPart memoPartDeliveryOption = this.getMemoPart();
        if (memoPartDeliveryOption != null) {
            this.appendToMemoPart(memoPartDeliveryOption, (MemoPart)attachment);
        }
    }

    public void addLink(ObjectLink link) {
        MemoPartObjectLinks memoPartObjectLinks = null;
        DeliveryOptionMemoPart memoPartDeliveryOption = this.getMemoPart();
        if (memoPartDeliveryOption != null) {
            boolean appendNewLinkMemoPart;
            memoPartObjectLinks = this.getLinks(memoPartDeliveryOption);
            boolean bl = appendNewLinkMemoPart = memoPartObjectLinks == null;
            if (appendNewLinkMemoPart) {
                memoPartObjectLinks = new MemoPartObjectLinks();
            }
            ObjectLink[] links = new ObjectLink[]{};
            if (appendNewLinkMemoPart) {
                links = new ObjectLink[]{link};
                this.appendToMemoPart(memoPartDeliveryOption, (MemoPart)memoPartObjectLinks);
            } else {
                links = memoPartObjectLinks.getLinks();
                ObjectLink[] newLinks = new ObjectLink[links.length + 1];
                System.arraycopy(links, 0, newLinks, 0, links.length);
                newLinks[links.length] = link;
                links = newLinks;
            }
            memoPartObjectLinks.setLinks(links);
        }
    }

    public void addSubject(String value) {
        DeliveryOptionString subject = new DeliveryOptionString();
        subject.setName(DeliveryOptionEnum.subject);
        subject.setValue(value);
        this.addOption((DeliveryOption)subject);
    }

    public void addExternalAddress(AddressSMTP[] addresses, DeliveryOptionEnum type) {
        DeliveryOptionAddressSMTPArray toAddressOption = new DeliveryOptionAddressSMTPArray();
        toAddressOption.setName(type);
        toAddressOption.setValue(addresses);
        this.addOption((DeliveryOption)toAddressOption);
    }

    public void addExternalAddress(String[] addressArray, DeliveryOptionEnum type) throws Exception {
        List<Object> addressList = this.convert(AddressSMTP.class, addressArray);
        this.addExternalAddress(addressList.toArray(new AddressSMTP[0]), type);
    }

    public void addExternalAddress(String address, DeliveryOptionEnum type) throws Exception {
        List<Object> addressList = this.convert(AddressSMTP.class, new String[]{address});
        this.addExternalAddress(addressList.toArray(new AddressSMTP[0]), type);
    }

    public void addAddresses(SearchPathMultipleObject[] addresses, DeliveryOptionEnum type) {
        DeliveryOptionSearchPathMultipleObjectArray recipients = null;
        if (this.isValid(addresses)) {
            DeliveryOption opt = this.getOption(type, DeliveryOptionSearchPathMultipleObjectArray.class);
            if (opt != null) {
                recipients = (DeliveryOptionSearchPathMultipleObjectArray)opt;
                SearchPathMultipleObject[] existingAddresses = recipients.getValue();
                ArrayList<SearchPathMultipleObject> mergedList = new ArrayList<SearchPathMultipleObject>(Arrays.asList(existingAddresses));
                mergedList.addAll(Arrays.asList(addresses));
                recipients.setValue(mergedList.toArray(new SearchPathMultipleObject[mergedList.size()]));
            } else {
                recipients = new DeliveryOptionSearchPathMultipleObjectArray();
                recipients.setName(type);
                recipients.setValue(addresses);
                this.addOption((DeliveryOption)recipients);
            }
        }
    }

    public void addAddresses(String[] addresses, DeliveryOptionEnum type) throws Exception {
        if (MemoOptionsBuilder.isExternalAddressType(type)) {
            this.addExternalAddress(addresses, type);
            return;
        }
        List<Object> addressList = this.convert(SearchPathMultipleObject.class, addresses);
        this.addAddresses(addressList.toArray(new SearchPathMultipleObject[0]), type);
    }

    public void addAddress(String address, DeliveryOptionEnum type) throws Exception {
        if (MemoOptionsBuilder.isExternalAddressType(type)) {
            this.addExternalAddress(address, type);
            return;
        }
        List<Object> addressList = this.convert(SearchPathMultipleObject.class, new String[]{address});
        this.addAddresses(addressList.toArray(new SearchPathMultipleObject[0]), type);
    }

    private static boolean isExternalAddressType(DeliveryOptionEnum type) {
        return externallAddressStyles.contains(type);
    }

    private void appendToMemoPart(DeliveryOptionMemoPart memoPartDeliveryOption, MemoPart memoPart) {
        if (memoPartDeliveryOption != null && memoPartDeliveryOption.getValue() instanceof MemoPartComposite) {
            MemoPartComposite memoPartComposite = (MemoPartComposite)memoPartDeliveryOption.getValue();
            MemoPart[] parts = memoPartComposite.getParts();
            MemoPart[] newParts = new MemoPart[parts.length + 1];
            if (parts.length > 0) {
                System.arraycopy(parts, 0, newParts, 0, parts.length);
            }
            int destIndex = parts.length > 0 ? parts.length : 0;
            newParts[destIndex] = memoPart;
            memoPartComposite.setParts(newParts);
        }
    }

    private DeliveryOptionMemoPart getMemoPart() {
        DeliveryOptionMemoPart memoPartDeliveryOption = null;
        for (DeliveryOption option : this.m_options) {
            DeliveryOptionEnum optionName = option.getName();
            if (!optionName.equals((Object)DeliveryOptionEnum.memoPart) || !(option instanceof DeliveryOptionMemoPart)) continue;
            memoPartDeliveryOption = (DeliveryOptionMemoPart)option;
        }
        return memoPartDeliveryOption;
    }

    private MemoPartObjectLinks getLinks(DeliveryOptionMemoPart memoPartDeliveryOption) {
        MemoPartObjectLinks memoPartObjectLinks = null;
        MemoPart memoPart = memoPartDeliveryOption.getValue();
        if (memoPart instanceof MemoPartComposite) {
            MemoPartComposite memoPartComposite = (MemoPartComposite)memoPart;
            MemoPart[] parts = memoPartComposite.getParts();
            for (int i = 0; i < parts.length; ++i) {
                MemoPart part = parts[i];
                if (!(part instanceof MemoPartObjectLinks)) continue;
                memoPartObjectLinks = (MemoPartObjectLinks)part;
                break;
            }
        }
        return memoPartObjectLinks;
    }

    private DeliveryOption getOption(DeliveryOptionEnum type, Class clazz) {
        DeliveryOption option = null;
        List<DeliveryOption> options = this.getOptions();
        for (DeliveryOption deliveryOption : options) {
            if (!deliveryOption.getClass().equals(clazz) || !deliveryOption.getName().equals((Object)type)) continue;
            option = deliveryOption;
        }
        return option;
    }

    private boolean isValid(SearchPathMultipleObject[] addresses) {
        boolean isValid = true;
        for (int i = 0; i < addresses.length && isValid; ++i) {
            SearchPathMultipleObject addr = addresses[i];
            isValid = isValid && addr != null && addr.get_value() != null && addr.get_value().length() > 0;
        }
        return isValid;
    }

    private List<Object> convert(Class<?> aClass, String[] values) throws SecurityException, NoSuchMethodException, IllegalAccessException, InstantiationException, IllegalArgumentException, InvocationTargetException {
        ArrayList<Object> result = new ArrayList<Object>();
        Method m = aClass.getMethod("set_value", String.class);
        for (int i = 0; values != null && i < values.length; ++i) {
            Object obj = aClass.newInstance();
            m.invoke(obj, values[i]);
            result.add(obj);
        }
        return result;
    }

    public void clean() {
        this.m_options.clear();
    }

    static {
        externallAddressStyles.add(DeliveryOptionEnum.toAddress);
        externallAddressStyles.add(DeliveryOptionEnum.ccAddress);
        externallAddressStyles.add(DeliveryOptionEnum.bccAddress);
    }
}

