/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.AgentDefinition;
import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.AnyTypeProp;
import com.cognos.developer.schemas.bibus._3.AnyURIProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.BooleanProp;
import com.cognos.developer.schemas.bibus._3.BoundRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.HierarchicalParmValueItem;
import com.cognos.developer.schemas.bibus._3.LanguageProp;
import com.cognos.developer.schemas.bibus._3.MultilingualString;
import com.cognos.developer.schemas.bibus._3.MultilingualStringProp;
import com.cognos.developer.schemas.bibus._3.Nil;
import com.cognos.developer.schemas.bibus._3.NmtokenArrayProp;
import com.cognos.developer.schemas.bibus._3.NmtokenProp;
import com.cognos.developer.schemas.bibus._3.NonNegativeIntegerProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.ParameterCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.ParameterDataTypeEnum;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringArrayProp;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UnboundedEndRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedStartRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.ValidateSeverityEnum;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.util.ObjectModelClassEnum;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;

public class ObjectModelUtil {
    private static final HashMap m_severity_integer = new HashMap();
    public static final PropEnum[] PERMISSSION_PROPS = new PropEnum[]{PropEnum.defaultName, PropEnum.objectClass, PropEnum.searchPath, PropEnum.permissions};
    public static final String WRITE = "write";

    private ObjectModelUtil() {
    }

    public static SearchPathSingleObject makeSearPathSingleObject(String value) {
        SearchPathSingleObject sp = new SearchPathSingleObject();
        sp.set_value(value);
        return sp;
    }

    public static NonNegativeIntegerProp makeNonNegIntegerProp(String value) {
        NonNegativeIntegerProp nnip = new NonNegativeIntegerProp();
        nnip.setValue(new BigInteger(value));
        return nnip;
    }

    public static StringArrayProp makeStringArrayProp(String[] value) {
        StringArrayProp sp = new StringArrayProp();
        sp.setValue(value);
        return sp;
    }

    public static boolean getBoolean(BooleanProp prop) {
        return prop != null ? prop.isValue() : false;
    }

    public static BooleanProp makeBooleanProp(boolean value) {
        BooleanProp sp = new BooleanProp();
        sp.setValue(value);
        return sp;
    }

    public static AnyTypeProp makeAnyTypeProp(String value) {
        AnyTypeProp sp = new AnyTypeProp();
        sp.setValue(value);
        return sp;
    }

    public static ParameterValueArrayProp makePVArrayProp(ParameterValue[] pvs) {
        ParameterValueArrayProp pvap = new ParameterValueArrayProp();
        pvap.setValue(pvs == null ? new ParameterValue[]{} : pvs);
        return pvap;
    }

    public static NmtokenProp makeNMTokenProp(String value) {
        NmtokenProp prop = new NmtokenProp();
        prop.setValue(value);
        return prop;
    }

    public static SearchPathSingleObject[] makeSearchPathSingleObjects(String[] value) {
        if (value == null) {
            return new SearchPathSingleObject[0];
        }
        SearchPathSingleObject[] paths = new SearchPathSingleObject[value.length];
        for (int i = 0; i < value.length; ++i) {
            paths[i] = new SearchPathSingleObject();
            paths[i].set_value(value[i]);
        }
        return paths;
    }

    public static SearchPathSingleObject makeSearchPath(String value) {
        SearchPathSingleObject sp = new SearchPathSingleObject();
        sp.set_value(value);
        return sp;
    }

    public static AnyURIProp makeAnyURIProp(String value) {
        AnyURIProp u = new AnyURIProp();
        u.setValue(value);
        return u;
    }

    public static MultilingualStringProp makeMultiLingualProp(String value, Locale locale) {
        MultilingualStringProp u = new MultilingualStringProp();
        MultilingualString mls = new MultilingualString();
        mls.setLocale(locale.toString());
        mls.setValue(value);
        u.setValue(new MultilingualString[]{mls});
        return u;
    }

    public static BaseClassArrayProp makeBaseClassArrayProp(BaseClass[] bases) {
        BaseClassArrayProp u = new BaseClassArrayProp();
        u.setValue(bases);
        return u;
    }

    public static BaseClassArrayProp makeBaseClassArrayProp(BaseClass base) {
        BaseClassArrayProp u = new BaseClassArrayProp();
        u.setValue(new BaseClass[]{base});
        return u;
    }

    public static TokenProp makeTokenProp(String value) {
        TokenProp sp = new TokenProp();
        sp.setValue(value);
        return sp;
    }

    public static AgentDefinition[] makeAgentDefinitions(String[] searchPaths) {
        AgentDefinition[] objects = new AgentDefinition[searchPaths.length];
        for (int i = 0; i < searchPaths.length; ++i) {
            objects[i] = new AgentDefinition();
            objects[i].setSearchPath(ObjectModelUtil.makeStringProp(searchPaths[i]));
        }
        return objects;
    }

    public static BaseClass[] makeNils(String[] searchPaths) {
        BaseClass[] objects = new BaseClass[searchPaths.length];
        for (int i = 0; i < searchPaths.length; ++i) {
            objects[i] = new Nil();
            objects[i].setSearchPath(ObjectModelUtil.makeStringProp(searchPaths[i]));
        }
        return objects;
    }

    public static BaseClass[] makeNils(BaseClass[] bases) {
        BaseClass[] objects = new BaseClass[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            objects[i] = new Nil();
            objects[i].setSearchPath(bases[i].getSearchPath());
        }
        return objects;
    }

    public static GuidProp makeGuidProp(String value) {
        GuidProp guidProp = new GuidProp();
        if (value == null) {
            return guidProp;
        }
        Guid guid = new Guid(value);
        guidProp.setValue(guid);
        return guidProp;
    }

    public static String getGuidPropValue(GuidProp gProp) {
        if (gProp == null) {
            return null;
        }
        Guid g = gProp.getValue();
        return g != null ? g.get_value() : null;
    }

    public static BaseClassArrayProp makeLink(SearchPathSingleObject value) {
        BaseClassArrayProp bcap = new BaseClassArrayProp();
        if (value == null || value.get_value() == null || "".equals(value.get_value())) {
            return bcap;
        }
        BaseClass[] bases = new BaseClass[]{new Nil()};
        bases[0].setSearchPath(ObjectModelUtil.makeStringProp(value.get_value()));
        bcap.setValue(bases);
        return bcap;
    }

    public static OptionArrayProp makeOptionArrayProp(Option[] value) {
        OptionArrayProp prop = new OptionArrayProp();
        prop.setValue(value);
        return prop;
    }

    public static ParameterValueArrayProp makeParameterArrayProp(ParameterValue[] value) {
        ParameterValueArrayProp prop = new ParameterValueArrayProp();
        prop.setValue(value);
        return prop;
    }

    public static StringProp makeStringProp(String value) {
        StringProp prop = new StringProp();
        prop.setValue(value);
        return prop;
    }

    public static String getSearchPath(BaseClass value) {
        if (value != null) {
            return ObjectModelUtil.getSearchPath(value.getSearchPath());
        }
        return null;
    }

    public static String getSearchPath(SearchPathSingleObject value) {
        if (value != null) {
            return value.get_value();
        }
        return null;
    }

    public static String[] getSearchPaths(SearchPathSingleObject[] value) {
        if (value == null) {
            return new String[0];
        }
        String[] paths = new String[value.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = value[i] != null ? value[i].get_value() : "";
        }
        return paths;
    }

    public static String getSearchPath(StringProp value) {
        if (value != null) {
            return value.getValue();
        }
        return null;
    }

    public static DateTimeProp makeDateTimeProp(Calendar time) {
        DateTimeProp dtp = new DateTimeProp();
        dtp.setValue(time);
        return dtp;
    }

    public static String getMultilingualString(MultilingualString[] ml_strings, int index) {
        return ml_strings != null && ml_strings.length >= index && ml_strings[index] != null ? ml_strings[index].getValue() : null;
    }

    public static BaseClass getBaseClass(BaseClassArrayProp baseClasses, int index) {
        BaseClass base = null;
        if (baseClasses != null && baseClasses.getValue() != null) {
            base = ObjectModelUtil.getBaseClass(baseClasses.getValue(), index);
        }
        return base;
    }

    public static BaseClass getBaseClass(BaseClass[] baseClasses, int index) {
        BaseClass base = null;
        if (baseClasses != null && baseClasses.length > index) {
            base = baseClasses[index];
        }
        return base;
    }

    public static SearchPathSingleObject getSearchPath(BaseClassArrayProp baseClasses, int index) {
        SearchPathSingleObject sp = null;
        BaseClass base = ObjectModelUtil.getBaseClass(baseClasses, index);
        if (base != null) {
            if (base.getStoreID() != null && base.getStoreID().getValue() != null && !"".equals(base.getStoreID().getValue())) {
                sp = ObjectModelUtil.getSearchPath(base.getStoreID().getValue());
            } else if (base.getSearchPath() != null && base.getSearchPath().getValue() != null && !"".equals(base.getSearchPath().getValue())) {
                sp = new SearchPathSingleObject();
                sp.set_value(base.getSearchPath().getValue());
            }
        }
        return sp;
    }

    public static ObjectModelClassEnum getOMClass(BaseClassArrayProp baseClasses, int index) {
        ObjectModelClassEnum om_class = null;
        BaseClass base = ObjectModelUtil.getBaseClass(baseClasses, index);
        if (base != null) {
            om_class = ObjectModelClassEnum.getObjectModelClassEnum(base);
        }
        return om_class;
    }

    public static String getUri(AnyURIProp prop) {
        String sp = null;
        if (prop != null && prop.getValue() != null && !"".equals(prop.getValue())) {
            sp = prop.getValue();
        }
        return sp;
    }

    public static SearchPathSingleObject getAgentAncestorSp(BaseClass base) {
        SearchPathSingleObject sp = null;
        if (base == null || base.getAncestors() == null) {
            return sp;
        }
        AncestorInfo[] ancestors = base.getAncestors().getValue();
        for (int i = 0; i < ancestors.length; ++i) {
            if (!ObjectModelUtil.isAgentSearchPath(ancestors[i].getSearchPath())) continue;
            sp = ObjectModelUtil.makeSearPathSingleObject(ancestors[i].getSearchPath());
        }
        return sp;
    }

    public static boolean hasCapability(BaseParameter param, ParameterCapabilityEnum capability) {
        ParameterCapabilityEnum[] capabilities = param.getCapabilities();
        for (int i = 0; capabilities != null && i < capabilities.length; ++i) {
            if (!capability.equals((Object)capabilities[i])) continue;
            return true;
        }
        return false;
    }

    public static SeverityEnum convert(ValidateSeverityEnum toConvert) {
        SeverityEnum senum = null;
        if (ValidateSeverityEnum.information.equals((Object)toConvert)) {
            senum = SeverityEnum.info;
        } else if (ValidateSeverityEnum.error.equals((Object)toConvert)) {
            senum = SeverityEnum.error;
        } else if (ValidateSeverityEnum.warning.equals((Object)toConvert)) {
            senum = SeverityEnum.warn;
        }
        return senum;
    }

    public static ValidateSeverityEnum convert(SeverityEnum toConvert) {
        ValidateSeverityEnum senum = null;
        if (SeverityEnum.debug.equals((Object)toConvert)) {
            senum = ValidateSeverityEnum.information;
        } else if (SeverityEnum.info.equals((Object)toConvert)) {
            senum = ValidateSeverityEnum.information;
        } else if (SeverityEnum.warn.equals((Object)toConvert)) {
            senum = ValidateSeverityEnum.warning;
        } else if (SeverityEnum.error.equals((Object)toConvert)) {
            senum = ValidateSeverityEnum.error;
        } else if (SeverityEnum.fatal.equals((Object)toConvert)) {
            senum = ValidateSeverityEnum.error;
        }
        return senum;
    }

    public static int compareSeverity(SeverityEnum toCheck, SeverityEnum reference) {
        return ObjectModelUtil.getSeverityInteger(toCheck) - ObjectModelUtil.getSeverityInteger(reference);
    }

    private static int getSeverityInteger(SeverityEnum severity) {
        if (severity == null) {
            return 0;
        }
        Integer level = (Integer)m_severity_integer.get(severity);
        return level != null ? level : 0;
    }

    public static boolean isStoreIDPath(String sp) {
        return sp != null && sp.startsWith("storeID(");
    }

    public static SearchPathSingleObject getSearchPathFromGuid(String storeId) {
        Guid guid = new Guid();
        guid.set_value(storeId);
        return ObjectModelUtil.getSearchPath(guid);
    }

    public static SearchPathSingleObject getSearchPath(Guid guid) {
        SearchPathSingleObject spso = new SearchPathSingleObject();
        spso.set_value("storeID(\"" + (guid != null && guid.get_value() != null ? guid.get_value().trim() : "") + "\")");
        return spso;
    }

    public static BaseClassArrayProp changeAgentpathsToAgentOutputPaths(BaseClassArrayProp searchPath, String requiredFormat) {
        if (searchPath == null || searchPath.getValue() == null || searchPath.getValue().length == 0) {
            return searchPath;
        }
        BaseClass[] link_array = searchPath.getValue();
        for (int i = 0; i < link_array.length; ++i) {
            String sp = link_array[i].getSearchPath().getValue();
            String hyde = ObjectModelUtil.changeAgentpathsToAgentOutputPaths(sp, requiredFormat);
            StringProp spsp = new StringProp();
            spsp.setValue(hyde);
            link_array[i].setSearchPath(spsp);
        }
        return searchPath;
    }

    public static String changePathsToDefaultOutputPaths(String sp) {
        String result = sp;
        if (sp != null && sp.indexOf("containsReferences") <= 0) {
            result = "defaultOutput(" + sp + ")";
        }
        return result;
    }

    public static String changeAgentpathsToAgentOutputPaths(String sp, String requiredFormat) {
        String result = sp;
        if (sp != null && sp.indexOf("agentOutputHotList") <= 0 && ObjectModelUtil.isAgentSearchPath(sp)) {
            result = ObjectModelUtil.getAgentStatePathFromAgentPath(sp) + "/agentOutputHotList[last()]/output[@format='" + requiredFormat + "']";
        }
        return result;
    }

    public static String getAgentStatePathFromAgentPath(String sp) {
        String result = sp;
        if (sp != null && sp.indexOf("agentOutputHotList") <= 0 && ObjectModelUtil.isAgentSearchPath(sp)) {
            result = "/transientStateFolder/agentState[containsReferences(@definition, " + sp + ")]";
        }
        return result;
    }

    public static boolean isAgentSearchPath(String sp) {
        if (sp == null) {
            return false;
        }
        return sp.indexOf("agentDefinition") != -1 || sp.indexOf("agentDefinitionView") != -1;
    }

    public static SearchPathSingleObject changeAgentpathsToAgentOutputPaths(SearchPathSingleObject path, String requiredFormat) {
        if (path == null || path.get_value() == null || path.get_value().length() == 0) {
            return path;
        }
        String newPath = ObjectModelUtil.changeAgentpathsToAgentOutputPaths(path.get_value(), requiredFormat);
        SearchPathSingleObject sp = new SearchPathSingleObject();
        sp.set_value(newPath);
        return sp;
    }

    public static String getParameterValue(ParmValueItem item) {
        String parmValue = null;
        if (item instanceof BoundRangeParmValueItem) {
            String start = ((BoundRangeParmValueItem)item).getStart().getUse();
            String end = ((BoundRangeParmValueItem)item).getEnd().getUse();
            parmValue = start + "," + end;
        }
        if (item instanceof HierarchicalParmValueItem) {
            parmValue = ((HierarchicalParmValueItem)item).getValue().getUse();
        }
        if (item instanceof SimpleParmValueItem) {
            parmValue = ((SimpleParmValueItem)item).getUse();
        }
        if (item instanceof UnboundedEndRangeParmValueItem) {
            parmValue = ((UnboundedEndRangeParmValueItem)item).getStart().getUse();
        }
        if (item instanceof UnboundedStartRangeParmValueItem) {
            parmValue = ((UnboundedStartRangeParmValueItem)item).getEnd().getUse();
        }
        return parmValue;
    }

    public static ParameterDataTypeEnum getParameterType(String metadataItemString) {
        ParameterDataTypeEnum parameterType = null;
        if (metadataItemString == null || "".equals(metadataItemString)) {
            return parameterType;
        }
        parameterType = metadataItemString.compareToIgnoreCase("memberUniqueName") == 0 || metadataItemString.compareToIgnoreCase("memberUniqueName") == 0 ? ParameterDataTypeEnum.memberUniqueName : (metadataItemString.compareToIgnoreCase("xs:string") == 0 || metadataItemString.compareToIgnoreCase("xsdString") == 0 ? ParameterDataTypeEnum.xsdString : (metadataItemString.compareToIgnoreCase("xs:int") == 0 || metadataItemString.compareToIgnoreCase("xsdInt") == 0 ? ParameterDataTypeEnum.xsdInt : (metadataItemString.compareToIgnoreCase("xs:float") == 0 || metadataItemString.compareToIgnoreCase("xsdFloat") == 0 ? ParameterDataTypeEnum.xsdFloat : (metadataItemString.compareToIgnoreCase("xs:credential") == 0 || metadataItemString.compareToIgnoreCase("credential") == 0 ? ParameterDataTypeEnum.credential : (metadataItemString.compareToIgnoreCase("xs:byte") == 0 || metadataItemString.compareToIgnoreCase("xsdByte") == 0 ? ParameterDataTypeEnum.xsdByte : (metadataItemString.compareToIgnoreCase("xs:decimal") == 0 || metadataItemString.compareToIgnoreCase("xsdDecimal") == 0 ? ParameterDataTypeEnum.xsdDecimal : (metadataItemString.compareToIgnoreCase("xs:double") == 0 || metadataItemString.compareToIgnoreCase("xsdDouble") == 0 ? ParameterDataTypeEnum.xsdDouble : (metadataItemString.compareToIgnoreCase("xs:long") == 0 || metadataItemString.compareToIgnoreCase("xsdLong") == 0 ? ParameterDataTypeEnum.xsdLong : (metadataItemString.compareToIgnoreCase("xs:short") == 0 || metadataItemString.compareToIgnoreCase("xsdShort") == 0 ? ParameterDataTypeEnum.xsdShort : (metadataItemString.compareToIgnoreCase("xs:time") == 0 || metadataItemString.compareToIgnoreCase("xsdTime") == 0 ? ParameterDataTypeEnum.xsdTime : (metadataItemString.compareToIgnoreCase("xs:unsignedByte") == 0 || metadataItemString.compareToIgnoreCase("xsdUnsignedByte") == 0 ? ParameterDataTypeEnum.xsdUnsignedByte : (metadataItemString.compareToIgnoreCase("xs:unsignedInt") == 0 || metadataItemString.compareToIgnoreCase("xsdUnsignedInt") == 0 ? ParameterDataTypeEnum.xsdUnsignedInt : (metadataItemString.compareToIgnoreCase("xs:unsignedLong") == 0 || metadataItemString.compareToIgnoreCase("xsdUnsignedLong") == 0 ? ParameterDataTypeEnum.xsdUnsignedLong : (metadataItemString.compareToIgnoreCase("xs:unsignedShort") == 0 || metadataItemString.compareToIgnoreCase("xsdUnsignedShort") == 0 ? ParameterDataTypeEnum.xsdUnsignedShort : (metadataItemString.compareToIgnoreCase("xs:duration") == 0 || metadataItemString.compareToIgnoreCase("xsdDuration") == 0 ? ParameterDataTypeEnum.xsdDuration : (metadataItemString.compareToIgnoreCase("xs:dateTime") == 0 || metadataItemString.compareToIgnoreCase("xsdDateTime") == 0 ? ParameterDataTypeEnum.xsdDateTime : (metadataItemString.compareToIgnoreCase("xs:date") == 0 || metadataItemString.compareToIgnoreCase("xsdDate") == 0 ? ParameterDataTypeEnum.xsdDate : ParameterDataTypeEnum.xsdString)))))))))))))))));
        return parameterType;
    }

    public static String getPromptType(String paramDataType, String promptName) {
        String promptType = null;
        if (paramDataType == null || "".equals(paramDataType)) {
            return promptType;
        }
        promptType = paramDataType.compareToIgnoreCase("xsdString") == 0 ? "<textBox required='true' multiLine='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:int") == 0 || paramDataType.compareToIgnoreCase("xsdInt") == 0 ? "<textBox required='true' numbersOnly='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:float") == 0 || paramDataType.compareToIgnoreCase("xsdFloat") == 0 ? "<textBox required='true' numbersOnly='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("memberUniqueName") == 0 || paramDataType.compareToIgnoreCase("memberUniqueName") == 0 ? "<textBox required='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:credential") == 0 || paramDataType.compareToIgnoreCase("credential") == 0 ? "<selectDataSourceSignon required='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:byte") == 0 || paramDataType.compareToIgnoreCase("xsdByte") == 0 ? "<textBox required='true' numbersOnly='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:decimal") == 0 || paramDataType.compareToIgnoreCase("xsdDecimal") == 0 ? "<textBox required='true' numbersOnly='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:double") == 0 || paramDataType.compareToIgnoreCase("xsdDouble") == 0 ? "<textBox required='true' numbersOnly='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:long") == 0 || paramDataType.compareToIgnoreCase("xsdLong") == 0 ? "<textBox required='true' numbersOnly='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:short") == 0 || paramDataType.compareToIgnoreCase("xsdShort") == 0 ? "<textBox required='true' numbersOnly='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:time") == 0 || paramDataType.compareToIgnoreCase("xsdTime") == 0 ? "<selectTime required='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:unsignedByte") == 0 || paramDataType.compareToIgnoreCase("xsdUnsignedByte") == 0 ? "<textBox required='true' numbersOnly='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:unsignedInt") == 0 || paramDataType.compareToIgnoreCase("xsdUnsignedInt") == 0 ? "<textBox required='true' numbersOnly='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:unsignedLong") == 0 || paramDataType.compareToIgnoreCase("xsdUnsignedLong") == 0 ? "<textBox required='true' numbersOnly='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:unsignedShort") == 0 || paramDataType.compareToIgnoreCase("xsdUnsignedShort") == 0 ? "<textBox required='true' numbersOnly='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:duration") == 0 || paramDataType.compareToIgnoreCase("xsdDuration") == 0 ? "<selectInterval required='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:dateTime") == 0 || paramDataType.compareToIgnoreCase("xsdDateTime") == 0 ? "<selectDateTime required='true' parameter='" + promptName + "'/>" : (paramDataType.compareToIgnoreCase("xs:date") == 0 || paramDataType.compareToIgnoreCase("xsdDate") == 0 ? "<selectDate required='true' parameter='" + promptName + "'/>" : "<textBox required='true' multiLine='true' parameter='" + promptName + "'/>")))))))))))))))));
        return promptType;
    }

    public static BaseClass getBaseClass(ContentManagerServiceClientPort contentManager, SearchPathSingleObject spso, PropEnum[] props) throws SDKClientException, EMFSecurityException {
        String searchPath = spso.get_value();
        return ObjectModelUtil.getBaseClass(contentManager, searchPath, props);
    }

    public static BaseClass getBaseClass(ContentManagerServiceClientPort contentManager, String searchPath, PropEnum[] props) throws SDKClientException, EMFSecurityException {
        BaseClass baseClass = null;
        BaseClass[] baseClasses = contentManager.query(new SearchPathMultipleObject(searchPath), props, new Sort[0], new QueryOptions());
        if (baseClasses != null && baseClasses.length >= 1 && baseClasses[0].getSearchPath().getValue() != null) {
            baseClass = baseClasses[0];
        }
        return baseClass;
    }

    public static String[] getPermissions(BaseClass baseClass) {
        NmtokenArrayProp tokens = baseClass.getPermissions();
        String[] permissions = null;
        permissions = tokens != null && tokens.getValue() != null ? tokens.getValue() : new String[]{};
        return permissions;
    }

    public static String getOutputName(Output output) {
        NmtokenProp formatToken;
        LanguageProp localeProp;
        StringProp burstKey;
        if (output == null) {
            return null;
        }
        StringBuffer nameBuffer = new StringBuffer();
        if (output.getAncestors() != null) {
            AncestorInfo[] info = output.getAncestors().getValue();
            for (int i = info.length - 1; i >= 0; --i) {
                ClassEnum classEnum = info[i].getObjectClass();
                if (!ObjectModelClassEnum.REPORT.equals(classEnum) && !ObjectModelClassEnum.REPORT_VIEW.equals(classEnum) && !ObjectModelClassEnum.QUERY.equals(classEnum) && !ObjectModelClassEnum.ANALYSIS.equals(classEnum)) continue;
                nameBuffer.append(info[i].getTitle());
                break;
            }
        }
        if (null != (burstKey = output.getBurstKey()) && null != burstKey.getValue() && burstKey.getValue().length() > 0) {
            nameBuffer.append(" ").append(burstKey.getValue()).append(" ");
        }
        if (null != (localeProp = output.getLocale()) && null != localeProp.getValue() && localeProp.getValue().length() > 0) {
            nameBuffer.append(" ").append(localeProp.getValue());
        }
        if (null != (formatToken = output.getFormat()) && null != formatToken.getValue() && formatToken.getValue().length() > 0) {
            nameBuffer.append(".").append(formatToken.getValue());
        }
        return nameBuffer.toString();
    }

    public static ParameterValue[] mergeParameters(ParameterValue[] low, ParameterValue[] high) {
        int i;
        HashMap<String, ParameterValue> paramMap = new HashMap<String, ParameterValue>();
        if (low != null) {
            for (i = 0; i < low.length; ++i) {
                paramMap.put(low[i].getName(), low[i]);
            }
        }
        if (high != null) {
            for (i = 0; i < high.length; ++i) {
                paramMap.put(high[i].getName(), high[i]);
            }
        }
        return paramMap.values().toArray(new ParameterValue[paramMap.size()]);
    }

    public static ParameterValue makeParameterValue(String name, String value) {
        ParameterValue pv = new ParameterValue();
        pv.setName(name);
        SimpleParmValueItem item = new SimpleParmValueItem();
        item.setDisplay(value);
        item.setUse(value);
        pv.setValue(new ParmValueItem[]{item});
        return pv;
    }

    public static ParameterValue findParameter(ParameterValue[] values, String name) {
        for (int i = 0; i != values.length; ++i) {
            if (!values[i].getName().equals(name)) continue;
            return values[i];
        }
        return null;
    }

    public static String findEventIdFromHistoryPath(String historyPath) {
        String eventId = null;
        try {
            int endIndex;
            if (historyPath == null) {
                return eventId;
            }
            int index = historyPath.indexOf("@eventID");
            int startIndex = historyPath.indexOf("\"", index = historyPath.indexOf("=", index));
            if (startIndex == -1) {
                startIndex = historyPath.indexOf("'", index);
                endIndex = historyPath.indexOf("'", startIndex + 1);
            } else {
                endIndex = historyPath.indexOf("\"", startIndex + 1);
            }
            eventId = historyPath.substring(++startIndex, endIndex).trim();
            eventId = new TaskID(eventId).getID();
        }
        catch (RuntimeException e) {
            try {
                eventId = new TaskID(historyPath).getID();
            }
            catch (RuntimeException e1) {
                eventId = null;
            }
        }
        return eventId;
    }

    public static void main(String[] args) {
        String[] trials = new String[]{"//history[@eventID = '0AC1087201F258DD0112DC3871B6808200112dc42326a']", "//history[@eventID='0AC108720019F8F0010F15E50D60805F0010f15ef31d8']", "//history[@eventId='0AC108720019F8F0010F15E50D60805F0010f15ef31d8']", "//report[@name='eventID']", "0AC108720019F8F0010F15E50D60805F0010f15ef31d8", "eventID='0AC108720019F8F0010F15E50D60805F0010f15ef31d8'", "//history[@eventID=\"0AC108720019F8F0010F15E50D60805F0010f15ef31d8\"]", "//history[@eventID=\"0AC108720019F8F0010F15E50D60805F0010f15ef31d8y\"]", "//history[@eventID=\"0AC108720019F8F0010F15E50D60805F0010f15ef31d\"]"};
        for (int i = 0; i < trials.length; ++i) {
            System.out.println(ObjectModelUtil.findEventIdFromHistoryPath(trials[i]));
        }
    }

    static {
        m_severity_integer.put(SeverityEnum.debug, new Integer(0));
        m_severity_integer.put(SeverityEnum.info, new Integer(1));
        m_severity_integer.put(SeverityEnum.warn, new Integer(2));
        m_severity_integer.put(SeverityEnum.error, new Integer(3));
        m_severity_integer.put(SeverityEnum.fatal, new Integer(4));
    }
}

