/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.ArchiveDescriptor;
import com.cognos.developer.schemas.bibus._3.AsynchOption;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.DeploymentImportRule;
import com.cognos.developer.schemas.bibus._3.DeploymentObjectInformation;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionSearchPathSingleObjectArray;
import com.cognos.developer.schemas.bibus._3.GenericOptionBoolean;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.IndexTerm;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MultilingualString;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.NameValue;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.PowerPlay8OptionAnyURI;
import com.cognos.developer.schemas.bibus._3.PowerPlay8OptionEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.developer.schemas.bibus._3.RunOption;
import com.cognos.developer.schemas.bibus._3.RunOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionLanguageArray;
import com.cognos.developer.schemas.bibus._3.RunOptionSaveAs;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;

public class OptionUtils {
    private static String RUN_OPTIONS_SEPARATOR_NAME = "http://developer.cognos.com/ceba/constants/jsmOptionEnum#runOptionsSeparator";
    private static GenericOptionBoolean runOptionsSeparatorOption = null;
    public static OptionUtils m_instance = new OptionUtils();
    private static final String COMMA = ",";
    private static final String QUOTE = "\"";
    private static final String SEMI = ";";

    private OptionUtils() {
        runOptionsSeparatorOption = new GenericOptionBoolean();
        runOptionsSeparatorOption.setName(RUN_OPTIONS_SEPARATOR_NAME);
    }

    public static Option getRunOptionsSeparatorOption() {
        return runOptionsSeparatorOption;
    }

    public static Option[] addPrimaryWaitThreshhold(Option[] options, int value) {
        if (options == null) {
            options = new Option[]{};
        }
        ArrayList<Object> optionList = new ArrayList<Object>();
        boolean foundWaitThreshhold = false;
        for (int i = 0; i < options.length; ++i) {
            if (!(options[i] instanceof AsynchOption)) continue;
            AsynchOption aOption = (AsynchOption)options[i];
            if (aOption.getName().equals((Object)AsynchOptionEnum.primaryWaitThreshold)) {
                foundWaitThreshhold = true;
            }
            optionList.add(options[i]);
        }
        if (!foundWaitThreshhold) {
            AsynchOptionInt intOption = new AsynchOptionInt();
            intOption.setValue(value);
            intOption.setName(AsynchOptionEnum.primaryWaitThreshold);
            optionList.add(intOption);
        }
        return optionList.toArray(new Option[optionList.size()]);
    }

    public static RunOption[] findRunOptions(Option[] options) {
        ArrayList<Option> rOptions = new ArrayList<Option>();
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                if (!(options[i] instanceof RunOption)) continue;
                rOptions.add(options[i]);
            }
        }
        return rOptions.toArray(new RunOption[rOptions.size()]);
    }

    public static Option[] findOptionsByType(Option[] options, Class typeClass) {
        Option[] ret_value = new Option[]{};
        if (options != null) {
            ArrayList<Option> foundOptions = new ArrayList<Option>();
            int isz = options.length;
            for (int i = 0; i < isz; ++i) {
                if (options[i] == null || !typeClass.isAssignableFrom(options[i].getClass())) continue;
                foundOptions.add(options[i]);
            }
            ret_value = foundOptions.toArray(new Option[foundOptions.size()]);
        }
        return ret_value;
    }

    public static Option[] findAllOptionsWithNameEnum(Option[] options, Object optionEnumName) {
        Option[] ret_value = new Option[]{};
        if (options != null) {
            ArrayList<Option> foundOptions = new ArrayList<Option>();
            int isz = options.length;
            for (int i = 0; i < isz; ++i) {
                if (!OptionUtils.checkOptionWithNameEnum(options[i], optionEnumName)) continue;
                foundOptions.add(options[i]);
            }
            ret_value = foundOptions.toArray(new Option[foundOptions.size()]);
        }
        return ret_value;
    }

    public static Option[] removeOptionsWithNameEnum(Option[] options, Object optionEnumName) {
        Option[] ret_value = options;
        if (options != null) {
            ArrayList<Option> foundOptions = new ArrayList<Option>();
            int isz = options.length;
            for (int i = 0; i < isz; ++i) {
                if (OptionUtils.checkOptionWithNameEnum(options[i], optionEnumName)) continue;
                foundOptions.add(options[i]);
            }
            ret_value = foundOptions.toArray(new Option[foundOptions.size()]);
        }
        return ret_value;
    }

    public static Option findFirstOptionWithNameEnum(Option[] options, Object optionEnumName) {
        Option ret_value = null;
        if (options != null) {
            int isz = options.length;
            for (int i = 0; i < isz && ret_value == null; ++i) {
                if (!OptionUtils.checkOptionWithNameEnum(options[i], optionEnumName)) continue;
                ret_value = options[i];
            }
        }
        return ret_value;
    }

    private static boolean checkOptionWithNameEnum(Option option, Object optionEnumName) {
        if (option == null || optionEnumName == null) {
            return false;
        }
        boolean ret_value = false;
        Method setMethod = null;
        Method getMethod = null;
        try {
            setMethod = option.getClass().getMethod("setName", optionEnumName.getClass());
            getMethod = option.getClass().getMethod("getName", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (setMethod != null && getMethod != null) {
            try {
                Object foundOptionEnumName = getMethod.invoke((Object)option, null);
                if (foundOptionEnumName != null && foundOptionEnumName.equals(optionEnumName)) {
                    ret_value = true;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return ret_value;
    }

    public static String getOptionNameWithClass(Option option) {
        return option.getClass().getName() + OptionUtils.getOptionName(option);
    }

    public static String getOptionName(Option option) {
        String name = "";
        if (option != null) {
            try {
                Method getName = option.getClass().getMethod("getName", null);
                Object nameEnum = getName.invoke((Object)option, null);
                name = nameEnum != null ? nameEnum.toString() : name;
            }
            catch (NoSuchMethodException nsme) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_NO_SUCH_METHOD_EXCEPTION);
            }
            catch (Exception e) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.MSG_EXCEPTION_OCCURRED, new String[]{e.getMessage()});
            }
        }
        return name;
    }

    public static Option[] concatenateOptions(Option[] options1, Option[] options2) {
        ArrayList<Option> mergedOptions = new ArrayList<Option>();
        if (options1 != null) {
            mergedOptions.addAll(Arrays.asList(options1));
        }
        if (options2 != null) {
            mergedOptions.addAll(Arrays.asList(options2));
        }
        return mergedOptions.toArray(new Option[0]);
    }

    public static Option[] mergeOptions(Option[] lowOptions, Option[] highOptions) {
        return OptionUtils.mergeOptions(lowOptions, highOptions, false, false);
    }

    public static Option[] mergeOptions(Option[] lowOptions, Option[] highOptions, boolean check) {
        return OptionUtils.mergeOptions(lowOptions, highOptions, check, false);
    }

    public static Option[] mergeOptions(Option[] lowOptions, Option[] highOptions, boolean check, boolean joboptionFlag) {
        int idx;
        if (!joboptionFlag && highOptions != null && (idx = OptionUtils.idxRunOptionsSeparator(highOptions)) < highOptions.length) {
            return OptionUtils.mergeOptionsAfter(OptionUtils.concatenateOptions(highOptions, lowOptions), idx, null);
        }
        if (!joboptionFlag && lowOptions != null && (idx = OptionUtils.idxRunOptionsSeparator(lowOptions)) < lowOptions.length) {
            return OptionUtils.mergeOptionsAfter(lowOptions, idx, highOptions);
        }
        if (check) {
            return OptionUtils.mergeOptionsCheck(lowOptions, highOptions, joboptionFlag);
        }
        return OptionUtils.mergeOptionsNoCheck(lowOptions, highOptions);
    }

    private static Option[] mergeOptionsCheck(Option[] lowOptions, Option[] highOptions, boolean onlyHighOutputFormat) {
        String optionKeyName;
        String outputFormatKey = RunOptionStringArray.class.getName() + "outputFormat";
        boolean hasOutputSet = false;
        HashMap<String, Option> optionNameMap = new HashMap<String, Option>();
        if (highOptions != null) {
            for (Option option : highOptions) {
                if (option == null) continue;
                optionKeyName = OptionUtils.getOptionNameWithClass(option);
                if (outputFormatKey.equals(optionKeyName)) {
                    hasOutputSet = true;
                }
                if (optionNameMap.containsKey(optionKeyName)) continue;
                optionNameMap.put(optionKeyName, option);
            }
        }
        if (lowOptions != null) {
            for (Option option : lowOptions) {
                if (option == null) continue;
                optionKeyName = OptionUtils.getOptionNameWithClass(option);
                if (!onlyHighOutputFormat && hasOutputSet && outputFormatKey.equals(optionKeyName)) {
                    RunOptionStringArray outputFormatoption = (RunOptionStringArray)optionNameMap.get(optionKeyName);
                    String[] outputs = outputFormatoption.getValue();
                    String[] taskoptionValue = ((RunOptionStringArray)option).getValue();
                    String[] combinedOutputFormats = OptionUtils.combineArrays(outputs, taskoptionValue);
                    outputFormatoption.setValue(combinedOutputFormats);
                }
                if (optionNameMap.containsKey(optionKeyName)) continue;
                optionNameMap.put(optionKeyName, option);
            }
        }
        return optionNameMap.values().toArray(new Option[optionNameMap.size()]);
    }

    private static String[] combineArrays(String[] first, String[] second) {
        int i;
        int total = first.length + second.length;
        ArrayList<String> both = new ArrayList<String>(first.length + second.length);
        for (i = 0; i < second.length; ++i) {
            both.add(second[i]);
        }
        for (i = 0; i < first.length; ++i) {
            if (both.contains(first[i])) continue;
            both.add(first[i]);
        }
        return both.toArray(new String[both.size()]);
    }

    private static Option[] mergeOptionsNoCheck(Option[] lowOptions, Option[] highOptions) {
        String optionKeyName;
        HashMap<String, Option> optionNameMap = new HashMap<String, Option>();
        if (highOptions != null) {
            for (Option option : highOptions) {
                if (option == null || optionNameMap.containsKey(optionKeyName = OptionUtils.getOptionNameWithClass(option))) continue;
                optionNameMap.put(optionKeyName, option);
            }
        }
        if (lowOptions != null) {
            for (Option option : lowOptions) {
                if (option == null || optionNameMap.containsKey(optionKeyName = OptionUtils.getOptionNameWithClass(option))) continue;
                optionNameMap.put(optionKeyName, option);
            }
        }
        return optionNameMap.values().toArray(new Option[optionNameMap.size()]);
    }

    private static Option[] mergeOptionsAfter(Option[] options, int idx, Option[] newOptions) {
        if (newOptions == null) {
            return options;
        }
        Option[] highOptions = Arrays.copyOfRange(options, 0, idx + 1);
        Option[] lowOptions = null;
        if (idx + 1 < options.length) {
            lowOptions = Arrays.copyOfRange(options, idx + 1, options.length);
        }
        return OptionUtils.concatenateOptions(highOptions, OptionUtils.mergeOptionsNoCheck(lowOptions, newOptions));
    }

    public static int idxRunOptionsSeparator(Option[] options) {
        for (int i = 0; i < options.length; ++i) {
            if (!(options[i] instanceof GenericOptionBoolean) || !((GenericOptionBoolean)options[i]).getName().equals(RUN_OPTIONS_SEPARATOR_NAME)) continue;
            return i;
        }
        return options.length;
    }

    public static Option[] cleanupRunOptionsSeparator(Option[] options) {
        options = OptionUtils.removeOption(options, (Option)runOptionsSeparatorOption);
        return OptionUtils.mergeOptionsNoCheck(null, options);
    }

    public static RunOption[] stripOptions(Option[] options) {
        ArrayList<Option> strippedOptions = new ArrayList<Option>();
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                if (!(options[i] instanceof RunOption)) continue;
                strippedOptions.add(options[i]);
            }
        }
        return strippedOptions.toArray(new RunOption[0]);
    }

    public static Option[] removeOption(Option[] options, Option optionToRemove) {
        if (optionToRemove == null) {
            return options;
        }
        ArrayList<Option> amendedOptions = new ArrayList<Option>();
        String name = OptionUtils.getOptionNameWithClass(optionToRemove);
        for (Option option : options) {
            if (name.equals(OptionUtils.getOptionNameWithClass(option))) continue;
            amendedOptions.add(option);
        }
        return amendedOptions.toArray(new Option[amendedOptions.size()]);
    }

    public static Option[] removeOption(Option[] options, String name) {
        for (int i = 0; i < options.length; ++i) {
            if (!OptionUtils.getOptionName(options[i]).equals(name)) continue;
            ArrayList<Option> opts = new ArrayList<Option>(Arrays.asList(options));
            opts.remove(i);
            return opts.toArray(new Option[opts.size()]);
        }
        return options;
    }

    public static String extractEventIDfromOptions(Option[] options) {
        AsynchOptionStringArray aosa;
        String[] ids;
        String eventID = null;
        Option o = OptionUtils.findFirstOptionWithNameEnum(options, AsynchOptionEnum.runContext);
        if (o != null && o instanceof AsynchOptionStringArray && (ids = (aosa = (AsynchOptionStringArray)o).getValue()) != null && ids.length > 0) {
            eventID = ids[ids.length - 1];
        }
        return eventID;
    }

    public static String getOptionValue(Option option) {
        if (option == null) {
            throw new IllegalArgumentException("Option may not be null.");
        }
        try {
            try {
                Method method = option.getClass().getMethod("isValue", null);
                Boolean b = (Boolean)method.invoke((Object)option, null);
                return b.toString();
            }
            catch (NoSuchMethodException b) {
                try {
                    Method method = option.getClass().getMethod("getValue", null);
                    Object value = method.invoke((Object)option, null);
                    if (method.getReturnType().isArray()) {
                        return OptionUtils.processOptionArrray(value);
                    }
                    return OptionUtils.processOption(method, value);
                }
                catch (NoSuchMethodException value) {
                    if (option instanceof RunOptionSaveAs) {
                        StringBuffer buffer = new StringBuffer();
                        RunOptionSaveAs rosa = (RunOptionSaveAs)option;
                        if (rosa.getParentSearchPath() != null) {
                            buffer.append(rosa.getParentSearchPath());
                        }
                        if (rosa.getObjectClass() != null) {
                            buffer.append(COMMA);
                            buffer.append(rosa.getObjectClass());
                        }
                        MultilingualToken[] names = rosa.getObjectName();
                        for (int j = 0; names != null && j < names.length; ++j) {
                            buffer.append(COMMA).append(QUOTE).append(names[j].getLocale()).append(COMMA).append(names[j].getValue()).append(QUOTE);
                        }
                        return buffer.toString();
                    }
                }
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("[" + e.getClass() + "] Error resolving option value for class [" + option.getClass() + "] : " + e.getMessage());
        }
        return "";
    }

    private static String processOptionArrray(Object option) {
        StringBuffer buffer = new StringBuffer();
        for (int j = 0; j < Array.getLength(option); ++j) {
            DeploymentObjectInformation doi;
            int k;
            Object item;
            if (j != 0) {
                buffer.append(COMMA);
            }
            if ((item = Array.get(option, j)).getClass().equals(RefProp.class)) {
                RefProp rProp = (RefProp)item;
                buffer.append(QUOTE).append(rProp.getRefPropName()).append(SEMI);
                PropEnum[] props = rProp.getProperties();
                for (k = 0; k < props.length; ++k) {
                    if (k != 0) {
                        buffer.append(COMMA);
                    }
                    buffer.append(props[k].toString());
                }
                buffer.append(QUOTE);
                continue;
            }
            if (item.getClass().equals(NameValue.class)) {
                NameValue nv = (NameValue)item;
                buffer.append(QUOTE).append(nv.getName()).append(COMMA).append(nv.getValue()).append(QUOTE);
                continue;
            }
            if (item.getClass().equals(MultilingualString.class)) {
                MultilingualString mString = (MultilingualString)item;
                buffer.append(QUOTE).append(mString.getLocale()).append(COMMA).append(mString.getValue()).append(QUOTE);
                continue;
            }
            if (item.getClass().equals(IndexTerm.class)) {
                IndexTerm term = (IndexTerm)item;
                MultilingualString[] terms = term.getValue();
                buffer.append(QUOTE);
                for (k = 0; k < terms.length; ++k) {
                    if (k != 0) {
                        buffer.append(SEMI);
                    }
                    buffer.append(terms[k].getLocale()).append(COMMA);
                    buffer.append(terms[k].getValue());
                }
                buffer.append(QUOTE);
                continue;
            }
            if (item.getClass().equals(DeploymentObjectInformation.class)) {
                doi = (DeploymentObjectInformation)item;
                buffer.append(QUOTE).append(doi.getDefaultName()).append(COMMA);
                buffer.append(doi.getObjectClass()).append(COMMA);
                buffer.append(doi.getSearchPath()).append(QUOTE);
                continue;
            }
            if (item.getClass().equals(DeploymentOptionSearchPathSingleObjectArray.class)) {
                doi = (DeploymentOptionSearchPathSingleObjectArray)item;
                buffer.append(QUOTE).append(doi.getName()).append(COMMA);
                SearchPathSingleObject[] sp = doi.getValue();
                for (int i = 0; i < sp.length; ++i) {
                    buffer.append(sp[i].get_value()).append(COMMA);
                }
                continue;
            }
            if (item.getClass().equals(DeploymentImportRule.class)) {
                doi = (DeploymentImportRule)item;
                buffer.append(QUOTE).append(doi.getName()).append(COMMA);
                buffer.append(doi.getArchiveSearchPath()).append(QUOTE);
                continue;
            }
            buffer.append(item.toString());
        }
        return buffer.toString();
    }

    private static String processOption(Method method, Object option) {
        StringBuffer buffer = new StringBuffer();
        if (option == null) {
            return buffer.toString();
        }
        if (option instanceof Calendar) {
            buffer.append(((Calendar)option).getTime().toString());
        } else if (option instanceof Guid) {
            buffer.append(((Guid)option).get_value());
        } else if (option instanceof ArchiveDescriptor) {
            ArchiveDescriptor ad = (ArchiveDescriptor)option;
            buffer.append(QUOTE).append("burstKey").append(COMMA).append(ad.getBurstKey()).append(QUOTE).append(COMMA);
            buffer.append(QUOTE).append("filename").append(COMMA).append(ad.getFilename()).append(QUOTE);
        } else if (option instanceof MemoPartComposite) {
            MemoPartComposite mpc = (MemoPartComposite)option;
            buffer.append(mpc.getContentDisposition()).append(COMMA);
            buffer.append(mpc.getContentType()).append(COMMA);
            MemoPart[] parts = mpc.getParts();
            buffer.append(QUOTE);
            for (int i = 0; i < parts.length; ++i) {
                if (i != 0) {
                    buffer.append(COMMA);
                }
                buffer.append(parts[i].toString());
            }
            buffer.append(QUOTE);
        } else if (option != null) {
            buffer.append(option.toString());
        }
        return buffer.toString();
    }

    public static Option[] addTemporaryObjectLocationRunOption(Option[] options, String tempObjectLocation) {
        Option[] newOptions = options;
        if (tempObjectLocation != null) {
            RunOptionAnyURI tempObjectLocationOption = new RunOptionAnyURI();
            tempObjectLocationOption.setName(RunOptionEnum.outputLocation);
            tempObjectLocationOption.setValue(tempObjectLocation);
            if (newOptions == null) {
                newOptions = new Option[]{tempObjectLocationOption};
            } else if (null == OptionUtils.findFirstOptionWithNameEnum(options, RunOptionEnum.outputLocation)) {
                newOptions = OptionUtils.concatenateOptions(options, new Option[]{tempObjectLocationOption});
            }
        }
        return newOptions;
    }

    public static Option[] addTemporaryObjectLocationPPESRunOption(Option[] options, String tempObjectLocation) {
        Option[] newOptions = options;
        if (tempObjectLocation != null) {
            PowerPlay8OptionAnyURI tempObjectLocationOption = new PowerPlay8OptionAnyURI();
            tempObjectLocationOption.setName(PowerPlay8OptionEnum.outputLocation);
            tempObjectLocationOption.setValue(tempObjectLocation);
            if (newOptions == null) {
                newOptions = new Option[]{tempObjectLocationOption};
            } else if (null == OptionUtils.findFirstOptionWithNameEnum(options, PowerPlay8OptionEnum.outputLocation)) {
                newOptions = OptionUtils.concatenateOptions(options, new Option[]{tempObjectLocationOption});
            }
        }
        return newOptions;
    }

    public static Option[] addTemporaryObjectLanguageRunOption(Option[] options, String[] tempObjectLocale) {
        Option[] newOptions = options;
        if (tempObjectLocale != null) {
            RunOptionLanguageArray tempObjectLanguageOption = new RunOptionLanguageArray();
            tempObjectLanguageOption.setName(RunOptionEnum.outputLocale);
            tempObjectLanguageOption.setValue(tempObjectLocale);
            if (newOptions == null) {
                newOptions = new Option[]{tempObjectLanguageOption};
            } else if (null == OptionUtils.findFirstOptionWithNameEnum(options, RunOptionEnum.outputLocale)) {
                newOptions = OptionUtils.concatenateOptions(options, new Option[]{tempObjectLanguageOption});
            }
        }
        return newOptions;
    }

    public static String[] removeDuplicatedLocale(String[] origLocale) {
        if (origLocale == null) {
            return null;
        }
        HashSet<String> tempLocale = new HashSet<String>();
        for (String locale : origLocale) {
            if (tempLocale.contains(locale)) continue;
            tempLocale.add(locale);
        }
        return tempLocale.toArray(new String[tempLocale.size()]);
    }

    public static Option[] checkLanguageArrayRunOption(Option[] options) {
        String[] tempLocale;
        String outputLocale;
        String[] origLocale;
        Option languageRunOption = OptionUtils.findFirstOptionWithNameEnum(options, RunOptionEnum.outputLocale);
        if (languageRunOption != null && (origLocale = (outputLocale = OptionUtils.getOptionValue(languageRunOption)).split(COMMA)).length != (tempLocale = OptionUtils.removeDuplicatedLocale(origLocale)).length) {
            options = OptionUtils.removeOption(options, languageRunOption);
            options = OptionUtils.addTemporaryObjectLanguageRunOption(options, tempLocale);
        }
        return options;
    }

    public static boolean isTrue(Option option, String name) {
        GenericOptionBoolean boolOption = option instanceof GenericOptionBoolean ? (GenericOptionBoolean)option : null;
        return boolOption != null && name.equals(boolOption.getName()) && boolOption.isValue();
    }
}

