/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.AgentOptionBoolean;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.AsynchOptionSearchPathSingleObjectArray;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.GenericOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.MonitorOptionBoolean;
import com.cognos.developer.schemas.bibus._3.MonitorOptionEnum;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.ValidateOptionEnum;
import com.cognos.developer.schemas.bibus._3.ValidateOptionValidateSeverity;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.axis.AxisFault;

public class RunOptionsInformation
implements Serializable {
    private String parentHistoryEventID = null;
    private int runContextOptionIndex = -1;
    private int historyLocationIndex = -1;
    private SearchPathSingleObject historySearchPath = null;
    private boolean background = false;
    private int priority = 3;
    private SeverityEnum m_severity = SeverityEnum.error;
    private String restartPath = null;
    private String[] skipPaths = null;
    private boolean agentTaskPrompt;
    private static final String GENERICOPTION_PRIORITY = "http://developer.cognos.com/ceba/constants/monitorOptionEnum#priority";

    public RunOptionsInformation(Option[] options) throws RemoteException {
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                ValidateOptionValidateSeverity severity;
                AsynchOptionStringArray asynchOption;
                if (options[i] instanceof AsynchOptionStringArray) {
                    asynchOption = (AsynchOptionStringArray)options[i];
                    if (!asynchOption.getName().equals((Object)AsynchOptionEnum.runContext)) continue;
                    if (this.runContextOptionIndex == -1) {
                        this.runContextOptionIndex = i;
                        String[] contextEventIDs = asynchOption.getValue();
                        this.parentHistoryEventID = contextEventIDs[contextEventIDs.length - 1];
                        continue;
                    }
                    throw new AxisFault("More than one runContext option sent to the monitor!");
                }
                if (options[i] instanceof AsynchOptionSearchPathSingleObjectArray) {
                    AsynchOptionSearchPathSingleObjectArray aospsoa = (AsynchOptionSearchPathSingleObjectArray)options[i];
                    if (!aospsoa.getName().equals((Object)AsynchOptionEnum.skipTaskHistoryLocations)) continue;
                    if (this.skipPaths == null) {
                        this.skipPaths = ObjectModelUtil.getSearchPaths(aospsoa.getValue());
                        continue;
                    }
                    throw new AxisFault("More than one set of skipEventIDs option sent to the monitor!");
                }
                if (options[i] instanceof AsynchOptionSearchPathSingleObject) {
                    asynchOption = (AsynchOptionSearchPathSingleObject)options[i];
                    if (asynchOption.getName().equals((Object)AsynchOptionEnum.historyLocation)) {
                        if (this.historyLocationIndex == -1) {
                            this.historyLocationIndex = i;
                            this.historySearchPath = asynchOption.getValue();
                            continue;
                        }
                        throw new AxisFault("More than one historyLocation option sent to the monitor!");
                    }
                    if (!asynchOption.getName().equals((Object)AsynchOptionEnum.restartHistoryLocation)) continue;
                    if (this.restartPath == null) {
                        this.restartPath = asynchOption.getValue().get_value();
                        continue;
                    }
                    throw new AxisFault("More than one restartEventID option sent to the monitor!");
                }
                if (options[i] instanceof MonitorOptionBoolean) {
                    asynchOption = (MonitorOptionBoolean)options[i];
                    if (!asynchOption.getName().equals((Object)MonitorOptionEnum.background)) continue;
                    this.background = asynchOption.isValue();
                    continue;
                }
                if (options[i] instanceof GenericOptionAnyURI) {
                    String priorityVal;
                    asynchOption = (GenericOptionAnyURI)options[i];
                    if (!asynchOption.getName().equals(GENERICOPTION_PRIORITY) || (priorityVal = asynchOption.getValue()) == null) continue;
                    try {
                        this.priority = Integer.parseInt(priorityVal);
                        continue;
                    }
                    catch (Exception e) {
                        throw new AxisFault("Invalid value for Priority found. " + priorityVal);
                    }
                }
                if (options[i] instanceof AgentOptionBoolean) {
                    asynchOption = (AgentOptionBoolean)options[i];
                    continue;
                }
                if (!(options[i] instanceof ValidateOptionValidateSeverity) || !ValidateOptionEnum.severity.equals((Object)(severity = (ValidateOptionValidateSeverity)options[i]).getName())) continue;
                this.m_severity = ObjectModelUtil.convert(severity.getValue());
            }
        }
    }

    public String getParentHistoryEventID() {
        return this.parentHistoryEventID;
    }

    public int getHistoryLocationIndex() {
        return this.historyLocationIndex;
    }

    public SearchPathSingleObject getHistorySearchPath() {
        return this.historySearchPath;
    }

    public int getRunContextOptionIndex() {
        return this.runContextOptionIndex;
    }

    public boolean isBackground() {
        return this.background;
    }

    public int getPriority() {
        return this.priority;
    }

    public SeverityEnum getValidationSeverity() {
        return this.m_severity;
    }

    public String getRestartHistoryPath() {
        return this.restartPath;
    }

    public String[] getSkipHistoryPaths() {
        return this.skipPaths;
    }

    public boolean isAgentTaskPrompt() {
        return this.agentTaskPrompt;
    }
}

