/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

public class SQLParserUtils {
    public static final char[] TERMINATORS = new char[]{',', ' ', '.', '=', ')', '('};
    public static final String COMMA = new String(new char[]{TERMINATORS[0]});
    public static final String SPACE = new String(new char[]{TERMINATORS[1]});
    public static final String DOT = new String(new char[]{TERMINATORS[2]});
    public static final String EQUALS = new String(new char[]{TERMINATORS[3]});
    public static final String OPEN = new String(new char[]{TERMINATORS[5]});
    public static final String CLOSE = new String(new char[]{TERMINATORS[4]});
    public static final String QUERY = "?";
    public static final String GT = ">";
    public static final String LT = "<";
    public static final char QUOTE = '\'';
    private static final int MAX_INTEGERS = 1000;

    protected static boolean areBracketsMatched(String string) {
        return SQLParserUtils.getNumberOfSubStrings("(", string) == SQLParserUtils.getNumberOfSubStrings(")", string);
    }

    protected static boolean areQuotesEven(String string) {
        return SQLParserUtils.getNumberOfSubStrings("\"", string) % 2 == 0;
    }

    public static String[] createInClauses(String[] sourceStrings, boolean quoteStrings) {
        int full_loops = sourceStrings.length / 1000;
        int remaining = sourceStrings.length % 1000;
        String[] clauses = new String[remaining == 0 ? full_loops : full_loops + 1];
        for (int i = 0; i < full_loops; ++i) {
            String[] full_loop = new String[1000];
            System.arraycopy(sourceStrings, 1000 * i, full_loop, 0, 1000);
            clauses[i] = SQLParserUtils.createSingleClause(full_loop, quoteStrings);
        }
        if (remaining != 0) {
            String[] partial_loop = new String[remaining];
            System.arraycopy(sourceStrings, (clauses.length - 1) * 1000, partial_loop, 0, remaining);
            clauses[clauses.length - 1] = SQLParserUtils.createSingleClause(partial_loop, quoteStrings);
        }
        return clauses;
    }

    public static String[] createInClauses(String fieldName, String[] sourceStrings, boolean quoteStrings) {
        int full_loops = sourceStrings.length / 1000;
        int remaining = sourceStrings.length % 1000;
        String[] clauses = new String[remaining == 0 ? full_loops : full_loops + 1];
        for (int i = 0; i < full_loops; ++i) {
            String[] full_loop = new String[1000];
            System.arraycopy(sourceStrings, 1000 * i, full_loop, 0, 1000);
            clauses[i] = " " + fieldName + " " + SQLParserUtils.createSingleClause(full_loop, quoteStrings);
        }
        if (remaining != 0) {
            String[] partial_loop = new String[remaining];
            System.arraycopy(sourceStrings, (clauses.length - 1) * 1000, partial_loop, 0, remaining);
            clauses[clauses.length - 1] = " " + fieldName + " " + SQLParserUtils.createSingleClause(partial_loop, quoteStrings);
        }
        return clauses;
    }

    public static String getSeparatedList(String[] list_contents, String separator, boolean quoteStrings) {
        StringBuffer buffer = new StringBuffer();
        for (int x = 0; x < list_contents.length; ++x) {
            if (x != 0) {
                buffer.append(separator);
            }
            if (quoteStrings) {
                buffer.append('\'');
                buffer.append(list_contents[x]);
                buffer.append('\'');
                continue;
            }
            buffer.append(list_contents[x]);
        }
        return buffer.toString();
    }

    public static String bracket(String to_bracket) {
        if (to_bracket == null || to_bracket.trim().equals("")) {
            return to_bracket;
        }
        StringBuffer buffy = new StringBuffer();
        buffy.append(OPEN);
        buffy.append(to_bracket);
        buffy.append(CLOSE);
        return buffy.toString();
    }

    private static int getNumberOfSubStrings(String sub_string, String main_string) {
        int number_matches = 0;
        int position = main_string.indexOf(sub_string);
        while (position != -1) {
            position = main_string.indexOf(sub_string, position + sub_string.length());
            ++number_matches;
        }
        return number_matches;
    }

    private static String createSingleClause(String[] source, boolean quoteStrings) {
        String list = SQLParserUtils.getSeparatedList(source, ", ", quoteStrings);
        list = SQLParserUtils.bracket(list);
        return "IN" + list;
    }
}

