/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.SystemProtectionSession;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TempFilesUtil {
    private static final byte[] UNENCRYPTED = new byte[]{-57, 94, -57, 17};
    private static final byte[] ENCRYPTED = new byte[]{-113, 7, -57, 17};
    private static SystemProtectionSession m_encryptor;
    private static boolean m_encrypt;
    private static final String m_NOTICECAST_SERVER_DIR = "noticecast.server_dir";
    private static final String m_PROPS_TEMP_DIR = "temp";
    private static final String m_SYSTEM_TEMP_DIR = "java.io.tmpdir";
    private static final String m_SUB_FOLDER;
    private static Map m_storage_dirs;

    public static File[] getTempFiles(String folder_name) {
        File root = TempFilesUtil.getStorageRootDir(folder_name);
        return root.listFiles();
    }

    public static File createTempFile(String id, String folder_name) throws IOException {
        return File.createTempFile(id + "_", ".ncd", TempFilesUtil.getStorageRootDir(folder_name));
    }

    public static File getStorageRootDir(String folder_name) {
        File storage_dir = (File)m_storage_dirs.get(folder_name);
        if (storage_dir == null) {
            storage_dir = TempFilesUtil.getStorageDir(folder_name);
            m_storage_dirs.put(folder_name, storage_dir);
        }
        if (storage_dir == null || !storage_dir.exists()) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.INFO, I18NCode.MSG_UNABLE_LOAD_QUEUE, new String[]{folder_name, storage_dir.toString()});
        }
        return storage_dir;
    }

    public static boolean deleteTempFile(String folder_name, String file_name) {
        File temp_dir = TempFilesUtil.getStorageDir(folder_name);
        File temp_file = new File(temp_dir, file_name);
        return temp_file.delete();
    }

    public static File writeObjectToFolder(String folder_name, String file_name, Object object) {
        File temp_dir = TempFilesUtil.getStorageDir(folder_name);
        File temp_file = new File(temp_dir, file_name);
        try {
            TempFilesUtil.writeObjectToFile(temp_file, object);
        }
        catch (IOException e) {
            String s = "failed to save temp file " + file_name + " " + e.getMessage();
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.GEN_THROWABLE_ERROR, new String[]{s});
            temp_file.delete();
            temp_file = null;
        }
        catch (CAMCryptoException e) {
            String s = "failed to save temp file " + file_name + " " + e.getMessage();
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.SEC_ENCRYPTION_ERROR);
            temp_file.delete();
            temp_file = null;
        }
        return temp_file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectToFile(File file, Object object) throws IOException, CAMCryptoException {
        if (m_encryptor == null && m_encrypt) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            byte[] bytes;
            oos.writeObject(object);
            byte[] byArray = bytes = m_encrypt ? m_encryptor.encryptData(baos.toByteArray()) : baos.toByteArray();
            if (m_encrypt) {
                fos.write(ENCRYPTED);
            } else {
                fos.write(UNENCRYPTED);
            }
            fos.write(bytes);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (baos != null) {
                baos.close();
            }
            if (oos != null) {
                oos.close();
            }
        }
    }

    public static Object readObjectfromFolder(String folder_name, String file_name) throws Exception {
        File temp_dir = TempFilesUtil.getStorageDir(folder_name);
        File temp_file = new File(temp_dir, file_name);
        Object object = null;
        object = TempFilesUtil.readObjectFromFile(temp_file);
        return object;
    }

    public static Object readObjectFromFile(File file) throws Exception {
        Object read_object = null;
        if (m_encrypt && m_encryptor == null) {
            throw new Exception();
        }
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = null;
        ObjectInputStream input = null;
        try {
            int buffer_size = 1024;
            byte[] read_buffer = new byte[buffer_size];
            int bytes_read = -1;
            byte[] header = new byte[ENCRYPTED.length];
            fis.read(header);
            boolean encrypted = Arrays.equals(header, ENCRYPTED);
            while ((bytes_read = fis.read(read_buffer)) != -1) {
                baos.write(read_buffer, 0, bytes_read);
            }
            byte[] decrypted = encrypted ? m_encryptor.decryptData(baos.toByteArray()) : baos.toByteArray();
            bais = new ByteArrayInputStream(decrypted);
            input = new ObjectInputStream(bais);
            read_object = input.readObject();
        }
        catch (InvalidClassException ice) {
            file.delete();
            throw ice;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (baos != null) {
                baos.close();
            }
            if (bais != null) {
                bais.close();
            }
            if (input != null) {
                input.close();
            }
        }
        return read_object;
    }

    private static File getStorageDir(String folder_name) {
        String user_temp_dir = null;
        File storage_dir = null;
        CRNProperties theProperties = CRNProperties.getInstance();
        try {
            user_temp_dir = theProperties.getProperty(m_PROPS_TEMP_DIR);
            storage_dir = new File(user_temp_dir + m_SUB_FOLDER);
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
        storage_dir = new File(storage_dir.getAbsolutePath(), folder_name);
        if (!storage_dir.exists()) {
            storage_dir.mkdirs();
            try {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.INFO, I18NCode.MSG_MAKING_DIRECTORY, new String[]{storage_dir.toString()});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return storage_dir;
    }

    static {
        m_encrypt = true;
        try {
            String encrypt = CRNProperties.getInstance().getProperty("encryptTemporaryFiles");
            m_encrypt = Boolean.valueOf(encrypt);
            if (m_encrypt) {
                m_encryptor = new SystemProtectionSession();
            }
        }
        catch (CAMCryptoException cAMCryptoException) {
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        m_SUB_FOLDER = File.separator + "sds";
        m_storage_dirs = new HashMap();
    }
}

