/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.i18n.DateTimeFormat;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtils {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long MONTH = 2628288000L;
    public static final long YEAR = 31539456000L;
    private static final String m_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final DateTimeFormat utcDateFormatter = new DateTimeFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static String dateToString(com.cognos.i18n.Calendar cal) {
        if (cal == null) {
            return null;
        }
        DateTimeFormat dateFormatter = new DateTimeFormat(m_DATE_FORMAT);
        dateFormatter.setTimeZone(cal.getTimeZone());
        return dateFormatter.format(cal.getTime());
    }

    public static String dateToString(Date date, com.cognos.i18n.TimeZone tz) {
        DateTimeFormat dateFormatter = new DateTimeFormat(m_DATE_FORMAT);
        dateFormatter.setTimeZone(tz);
        return dateFormatter.format(date);
    }

    public static Date stringToDate(String dateString, com.cognos.i18n.TimeZone tz) {
        DateTimeFormat dateFormatter = new DateTimeFormat(m_DATE_FORMAT);
        if (tz == null) {
            dateFormatter.setTimeZone(com.cognos.i18n.TimeZone.getDefault());
        } else {
            dateFormatter.setTimeZone(tz);
        }
        Date date = null;
        try {
            date = dateFormatter.parse(dateString.trim()).getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Date stringToUTCDate(String dateString) {
        try {
            return utcDateFormatter.parse(dateString.trim()).getTime();
        }
        catch (Exception parseException) {
            return null;
        }
    }

    public static String dateToUTCString(com.cognos.i18n.Calendar cal) {
        if (cal == null) {
            return null;
        }
        return utcDateFormatter.format(cal.getTime());
    }

    public static String dateToUTCString(Date date) {
        if (date == null) {
            return null;
        }
        return utcDateFormatter.format(date);
    }

    public static com.cognos.i18n.Calendar dateToUTCCalendar(Date date) {
        com.cognos.i18n.Calendar cal = com.cognos.i18n.Calendar.getInstance((com.cognos.i18n.TimeZone)com.cognos.i18n.TimeZone.getTimeZone((String)"UTC"));
        cal.setTime(date);
        return cal;
    }

    public static Calendar dateToUTCJavaCalendar(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(date);
        return cal;
    }

    public String getDefaultDateFormat() {
        return m_DATE_FORMAT;
    }

    public static com.cognos.i18n.TimeZone getServerTimeZone() {
        String serverTimeZoneId = null;
        try {
            serverTimeZoneId = CRNProperties.getInstance().getProperty("serverTimeZoneID");
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        if (serverTimeZoneId == null || serverTimeZoneId.equals("")) {
            serverTimeZoneId = "UTC";
        }
        com.cognos.i18n.TimeZone tz = com.cognos.i18n.TimeZone.getTimeZone((String)serverTimeZoneId);
        return tz;
    }

    public static String getXsDuration(long durationInMillis) {
        boolean isThereTime;
        short year = (short)(durationInMillis / 31539456000L);
        short month = (short)((durationInMillis %= 31539456000L) / 2628288000L);
        short day = (short)((durationInMillis %= 2628288000L) / 86400000L);
        short hour = (short)((durationInMillis %= 86400000L) / 3600000L);
        short minute = (short)((durationInMillis %= 3600000L) / 60000L);
        short seconds = (short)((durationInMillis %= 60000L) / 1000L);
        short milliseconds = (short)(durationInMillis %= 1000L);
        StringBuffer result = new StringBuffer();
        result.append('P');
        if (year != 0) {
            result.append(year);
            result.append('Y');
        }
        if (month != 0) {
            result.append(month);
            result.append('M');
        }
        if (day != 0) {
            result.append(day);
            result.append('D');
        }
        boolean bl = isThereTime = hour != 0 || minute != 0 || seconds != 0 || milliseconds != 0;
        if (isThereTime) {
            result.append('T');
            if (hour != 0) {
                result.append(hour);
                result.append('H');
            }
            if (minute != 0) {
                result.append(minute);
                result.append('M');
            }
            if (seconds != 0 || milliseconds != 0) {
                result.append(seconds);
                if (milliseconds != 0) {
                    result.append('.');
                    if (milliseconds < 100) {
                        result.append('0');
                        if (milliseconds < 10) {
                            result.append('0');
                        }
                    }
                    result.append(milliseconds);
                }
                result.append('S');
            }
        }
        return result.toString();
    }

    public static String getPerfLogStamp(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return df.format(date);
    }

    static {
        utcDateFormatter.setTimeZone(com.cognos.i18n.TimeZone.getTimeZone((String)"UTC"));
    }
}

