/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.jsmcommon.util.ITimeZoneDisplayName;
import com.cognos.jsmcommon.util.TimeZoneData;
import com.cognos.jsmcommon.util.UnsupportedTimeZoneException;
import java.util.TimeZone;

public class TimeZoneFactory {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final String GMT_JAVA_TIMEZONE_ID = "GMT";
    private static final TimeZoneFactory instance = new TimeZoneFactory();

    private TimeZoneFactory() {
    }

    public static TimeZoneFactory getInstance() {
        return instance;
    }

    public static TimeZone getTimeZone(String id) throws UnsupportedTimeZoneException {
        if (id == null) {
            throw new UnsupportedTimeZoneException(id);
        }
        TimeZone zone = null;
        zone = TimeZoneData.get(id);
        if (zone == null) {
            zone = TimeZone.getTimeZone(id);
            if (TimeZone.getTimeZone(GMT_JAVA_TIMEZONE_ID).equals(zone) && !GMT_JAVA_TIMEZONE_ID.equals(id)) {
                String errMsg = "The following TimeZone is not supported: " + id;
                throw new UnsupportedTimeZoneException(id);
            }
        }
        return zone;
    }

    public static final TimeZone getDefaultTimeZone() {
        return TimeZoneData.get("GMT Standard Time");
    }

    public String[] getSupportedTimeZoneIds() {
        ITimeZoneDisplayName[] nameObjects = TimeZoneData.getSupportedTimeZoneNameObjects();
        String[] ids = new String[nameObjects.length];
        for (int i = 0; i < nameObjects.length; ++i) {
            ids[i] = nameObjects[i].getId();
        }
        return ids;
    }

    public ITimeZoneDisplayName[] getSupportedTimeZoneDisplayNames() {
        return TimeZoneData.getSupportedTimeZoneNameObjects();
    }
}

