/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.Namespace;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.Serializable;
import java.util.Locale;

public class UserAccountUtil
implements Serializable {
    private Account m_account;

    public UserAccountUtil(JobBiBusHeaders headers) {
        this(headers, new PropEnum[]{PropEnum.userName, PropEnum.defaultName, PropEnum.searchPath, PropEnum.email, PropEnum.givenName, PropEnum.surname, PropEnum.parent, PropEnum.storeID, PropEnum.notificationEMail});
    }

    public UserAccountUtil(JobBiBusHeaders headers, int dummyTenantIDflag) {
        this(headers, new PropEnum[]{PropEnum.userName, PropEnum.defaultName, PropEnum.searchPath, PropEnum.email, PropEnum.givenName, PropEnum.surname, PropEnum.parent, PropEnum.storeID, PropEnum.notificationEMail, PropEnum.tenantID});
    }

    public UserAccountUtil(JobBiBusHeaders headers, boolean throwExceptions) throws EMFSecurityException, SDKClientException {
        this(headers, new PropEnum[]{PropEnum.userName, PropEnum.defaultName, PropEnum.searchPath, PropEnum.email, PropEnum.givenName, PropEnum.surname, PropEnum.parent, PropEnum.storeID, PropEnum.notificationEMail}, throwExceptions);
    }

    private UserAccountUtil(JobBiBusHeaders headers, PropEnum[] props, boolean throwExceptions) throws EMFSecurityException, SDKClientException {
        block6: {
            try {
                this.m_account = this.getUserAccount(headers, props);
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                if (throwExceptions) {
                    throw e;
                }
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                if (throwExceptions) {
                    throw e;
                }
            }
            catch (Exception e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                if (!throwExceptions) break block6;
                throw new SDKClientException(e);
            }
        }
    }

    private UserAccountUtil(JobBiBusHeaders headers, PropEnum[] props) {
        try {
            this.m_account = this.getUserAccount(headers, props);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
    }

    public Account getUserAccount(JobBiBusHeaders headers, PropEnum[] props) throws Exception {
        Account userAccount = null;
        ContentManagerServiceClientPort cm = null;
        try {
            cm = Client.instance().getContentManagerServiceClient(headers);
            QueryOptions queryOptions = new QueryOptions();
            queryOptions.setSchemaInfo(true);
            BaseClass[] classes = cm.query(new SearchPathMultipleObject("~"), props, new Sort[0], queryOptions);
            if (classes != null && classes.length >= 1) {
                userAccount = (Account)classes[0];
            }
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            throw e;
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            throw e;
        }
        finally {
            if (cm != null) {
                cm.close();
            }
        }
        return userAccount;
    }

    public UserAccountUtil(Account account) {
        this.m_account = account;
    }

    public boolean equals(Object account) {
        boolean matches = account instanceof UserAccountUtil;
        return matches && this.equals((UserAccountUtil)account);
    }

    public boolean equals(UserAccountUtil account) {
        boolean matches = account != null;
        Guid storeID = this.getStoreID();
        if (storeID != null) {
            matches = matches && this.optimisticComparison(account.getStoreID(), storeID);
        } else {
            matches = matches && this.optimisticComparison(account.getUserSearchPath(), account.getUserSearchPath());
            matches = matches && this.optimisticComparison(account.getFullName(), this.getFullName());
            matches = matches && this.optimisticComparison(account.getNameSpaceId(), this.getNameSpaceId());
        }
        return matches;
    }

    public boolean optimisticComparison(Object obj1, Object obj2) {
        return obj1 == null && obj2 == null || obj1 != null && obj1.equals(obj2);
    }

    public Account getUserAccount() {
        return this.m_account;
    }

    public String getNameSpaceId() {
        BaseClassArrayProp bcap;
        String result = null;
        if (this.m_account != null && (bcap = this.m_account.getParent()) != null && bcap.getValue() != null) {
            BaseClass[] parents = bcap.getValue();
            for (int i = 0; i < parents.length; ++i) {
                if (!(parents[i] instanceof Namespace)) continue;
                result = this.resolveProp(parents[i].getSearchPath());
                int start = result.indexOf("\"");
                int end = result.lastIndexOf("\"");
                if (start == -1 || end == -1) continue;
                result = result.substring(start + 1, end);
            }
        }
        return result;
    }

    public String getUserName() {
        if (this.m_account == null) {
            return I18NUtil.getMessage(I18NCode.KEY_UNKNOWN, Locale.getDefault());
        }
        return this.getUserName(this.m_account);
    }

    public Guid getStoreID() {
        if (this.m_account != null && this.m_account.getStoreID() != null) {
            return this.m_account.getStoreID().getValue();
        }
        return null;
    }

    public String getFullName() {
        if (this.m_account == null) {
            return I18NUtil.getMessage(I18NCode.KEY_UNKNOWN, Locale.getDefault());
        }
        String givenName = this.resolveProp(this.m_account.getGivenName());
        String surname = this.resolveProp(this.m_account.getSurname());
        String fullName = this.getUserName();
        if (givenName.length() > 0 && surname.length() > 0) {
            fullName = surname + ", " + givenName + " (" + this.getUserName() + ")";
        }
        return fullName;
    }

    public String getUserSearchPath() {
        if (this.m_account != null) {
            return this.m_account.getSearchPath().getValue();
        }
        return null;
    }

    private String getUserName(Account account) {
        String temp;
        String username = I18NUtil.getMessage(I18NCode.KEY_UNKNOWN, SDSLogger.getLocale());
        StringProp user_prop = account != null ? account.getUserName() : null;
        TokenProp name_prop = account != null ? account.getDefaultName() : null;
        String string = temp = user_prop != null ? user_prop.getValue() : null;
        temp = temp != null ? temp : (name_prop != null ? name_prop.getValue() : null);
        return temp != null ? temp : username;
    }

    private String resolveProp(StringProp prop) {
        String result = "";
        if (null != prop && prop.getValue() != null) {
            result = prop.getValue();
        }
        return result;
    }
}

