/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.api.APIException;
import com.cognos.jsmcommon.api.ChainedServiceException;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.I18NMessageUtil;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.apache.axis.AxisFault;

public class ValidationResultHandler {
    private SeverityEnum m_severity;
    private I18NMessageUtil m_messages = new I18NMessageUtil();
    private JobBiBusHeaders m_headers = null;

    public ValidationResultHandler(SeverityEnum severity) {
        this.m_severity = severity == null ? SeverityEnum.error : severity;
    }

    public ValidationResultHandler(JobBiBusHeaders headers, SeverityEnum severity) {
        this.m_severity = severity == null ? SeverityEnum.error : (severity == SeverityEnum.warn ? SeverityEnum.info : severity);
        this.m_headers = headers;
    }

    public void addValidationMessage(LocalizableException le) {
        this.m_messages.addMessage(new I18NMessage(le));
    }

    public void addValidationMessage(I18NMessage message) {
        this.m_messages.addMessage(message);
    }

    public void addValidationMessages(I18NMessage[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            this.addValidationMessage(messages[i]);
        }
    }

    public I18NMessage[] getMessages() {
        return this.m_messages.getMessages();
    }

    public JobBiBusHeaders getHeaders() {
        return this.m_headers;
    }

    public I18NMessage[] getMessages(SeverityEnum severity) {
        return this.m_messages.getMessages(severity);
    }

    public void validate() throws AxisFault {
        ChainedServiceException exp;
        ArrayList<ChainedServiceException> chains = new ArrayList<ChainedServiceException>();
        if (ObjectModelUtil.compareSeverity(this.m_severity, SeverityEnum.error) <= 0 && (exp = this.getExceptions(new I18NMessage(I18NCode.MSG_VALIDATION_ERRORS, new Object[0], SeverityEnum.error), SeverityEnum.error)).getFaultList().size() > 0) {
            chains.add(exp);
        }
        if (ObjectModelUtil.compareSeverity(this.m_severity, SeverityEnum.warn) <= 0 && (exp = this.getExceptions(new I18NMessage(I18NCode.MSG_VALIDATION_WARNINGS, new Object[0], SeverityEnum.warn), SeverityEnum.warn)).getFaultList().size() > 0) {
            chains.add(exp);
        }
        if (ObjectModelUtil.compareSeverity(this.m_severity, SeverityEnum.info) <= 0 && (exp = this.getExceptions(new I18NMessage(I18NCode.MSG_VALIDATION_INFO, new Object[0], SeverityEnum.info), SeverityEnum.info)).getFaultList().size() > 0) {
            chains.add(exp);
        }
        this.throwValidationFault(chains.toArray(new ChainedServiceException[0]));
    }

    public SeverityEnum getValidationSeverity() {
        return this.m_severity;
    }

    private void throwValidationFault(ChainedServiceException[] exceptions) throws AxisFault {
        if (exceptions == null || exceptions.length == 0) {
            return;
        }
        Locale locale = LocaleUtil.getRequestProductLocale(BiBusUtilities.extractBiBusHeader());
        APIException apie = new APIException(exceptions, locale, false);
        AxisFault fault = AxisFault.makeFault((Exception)apie);
        fault.setFaultCodeAsString(apie.getFaultCode(locale));
        fault.setFaultString(apie.getFaultString(locale));
        fault.setFaultDetail(apie.getDetails(locale));
        throw fault;
    }

    private ChainedServiceException getExceptions(I18NMessage message, SeverityEnum severity) {
        return new ChainedServiceException(message, Arrays.asList(this.getServiceExceptions(severity)), severity);
    }

    private SDSServiceException[] getServiceExceptions(SeverityEnum severity) {
        I18NMessage[] messages = this.m_messages.getMessages(severity);
        SDSServiceException[] exceptions = new SDSServiceException[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            exceptions[i] = new SDSServiceException(messages[i].getCode(), messages[i].getParams(), messages[i].getSeverity());
        }
        return exceptions;
    }
}

