/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import java.util.HashMap;
import java.util.Map;

public class XMLUtils {
    private static final Map m_UNKNOWN_ENCODINGS = new HashMap();
    private static final char[] CHARS_TO_ENCODE;
    private static final String[] STRINGS_TO_ENCODE;
    private static final String[] ESCAPE_SEQUENCES;

    public static String validateEscapeSequences(String data) {
        if (data != null) {
            int position = data.indexOf(CHARS_TO_ENCODE[0]);
            while (position != -1) {
                boolean match = false;
                for (int i = 0; i < ESCAPE_SEQUENCES.length && !match; ++i) {
                    if (!data.regionMatches(position, ESCAPE_SEQUENCES[i], 0, ESCAPE_SEQUENCES[i].length())) continue;
                    match = true;
                }
                if (!match) {
                    data = new StringBuffer(data).replace(position, position + 1, ESCAPE_SEQUENCES[0]).toString();
                }
                position = data.indexOf(CHARS_TO_ENCODE[0], position + 1);
            }
        }
        for (int i = 1; i < CHARS_TO_ENCODE.length; ++i) {
            int position = data.indexOf(CHARS_TO_ENCODE[i]);
            while (position != -1) {
                if (!data.regionMatches(position, ESCAPE_SEQUENCES[i], 0, ESCAPE_SEQUENCES[i].length())) {
                    data = new StringBuffer(data).replace(position, position + 1, ESCAPE_SEQUENCES[i]).toString();
                }
                position = data.indexOf(CHARS_TO_ENCODE[i], position + 1);
            }
        }
        return data;
    }

    public static String forceEscape(String data) {
        if (data != null) {
            for (int i = 0; i < CHARS_TO_ENCODE.length; ++i) {
                int position = data.indexOf(CHARS_TO_ENCODE[i]);
                while (position != -1) {
                    data = new StringBuffer(data).replace(position, position + 1, ESCAPE_SEQUENCES[i]).toString();
                    position = data.indexOf(CHARS_TO_ENCODE[i], position + 1);
                }
            }
        }
        return data;
    }

    public static String unEscape(String xmlEscapedString) {
        for (int i = 0; i < ESCAPE_SEQUENCES.length; ++i) {
            int position = xmlEscapedString.indexOf(ESCAPE_SEQUENCES[i]);
            while (position != -1) {
                xmlEscapedString = new StringBuffer(xmlEscapedString).replace(position, position + ESCAPE_SEQUENCES[i].length(), STRINGS_TO_ENCODE[i]).toString();
                position = xmlEscapedString.indexOf(ESCAPE_SEQUENCES[i], position + 1);
            }
        }
        return xmlEscapedString;
    }

    public static String escapeOnce(String string) {
        if (string != null) {
            for (int i = ESCAPE_SEQUENCES.length - 1; i >= 0; --i) {
                int position = string.indexOf(ESCAPE_SEQUENCES[i]);
                while (position != -1) {
                    string = new StringBuffer(string).replace(position, position + ESCAPE_SEQUENCES[i].length(), STRINGS_TO_ENCODE[i]).toString();
                    position = string.indexOf(ESCAPE_SEQUENCES[i], position + 1);
                }
            }
        }
        return string;
    }

    public static String checkEncoding(String encoding) {
        return m_UNKNOWN_ENCODINGS.containsKey(encoding.toUpperCase()) ? (String)m_UNKNOWN_ENCODINGS.get(encoding.toUpperCase()) : encoding;
    }

    static {
        m_UNKNOWN_ENCODINGS.put("ISO-8859-6-I", "ISO-8859-6");
        m_UNKNOWN_ENCODINGS.put("ISO-8859-8-I", "ISO-8859-8");
        m_UNKNOWN_ENCODINGS.put("SHIFT-JIS", "SHIFT_JIS");
        CHARS_TO_ENCODE = new char[]{'&', '<', '>', '\"', '\''};
        STRINGS_TO_ENCODE = new String[]{"&", "<", ">", "\"", "'"};
        ESCAPE_SEQUENCES = new String[]{"&amp;", "&lt;", "&gt;", "&quot;", "&apos;"};
    }
}

