/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.jsmcommon.objectid.GuidIdGenerator;
import com.cognos.jsmcommon.util.TempFilesUtil;
import com.cognos.jsmcommon.util.io.LimitedBufferedOutputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class ZipToFileUtil {
    private static String ATTACHMENT_ZIP_TEMP = "ATTACHMENT_ZIP_TEMP";
    public File tempFile = TempFilesUtil.createTempFile(GuidIdGenerator.createNew().toString(), ATTACHMENT_ZIP_TEMP);
    private ZipOutputStream out;
    private LimitedBufferedOutputStream lesbos;
    private FileOutputStream dest;

    public ZipToFileUtil(long maxZippedSize, String fileName) throws IOException {
        this.tempFile.mkdirs();
        this.dest = new FileOutputStream(this.tempFile);
        this.lesbos = new LimitedBufferedOutputStream(this.dest, maxZippedSize);
        this.out = new ZipOutputStream(this.lesbos);
        ZipEntry entry = new ZipEntry(fileName);
        this.out.putNextEntry(entry);
    }

    public void writeToFile(byte[] bytes) throws IOException {
        this.out.write(bytes, 0, bytes.length);
    }

    public void writeToFile(InputStream bytes) throws IOException {
        IOUtils.copy((InputStream)bytes, (OutputStream)this.out);
    }

    public void close() throws IOException {
        IOException e = null;
        try {
            this.out.close();
            this.lesbos.flush();
            this.dest.flush();
        }
        catch (IOException ex) {
            e = ex;
        }
        try {
            this.lesbos.close();
        }
        catch (IOException e1) {
            e = e1;
        }
        this.dest.close();
        if (e != null) {
            throw e;
        }
    }

    public byte[] getZippedBytes() throws IOException {
        FileInputStream fis = new FileInputStream(this.tempFile);
        byte[] bytes = IOUtils.toByteArray((InputStream)new BufferedInputStream(fis));
        try {
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bytes;
    }

    public void cleanup() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.tempFile != null) {
                this.tempFile.delete();
                this.tempFile = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

