/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util;

import com.cognos.jsmcommon.util.DataSizeChecker;
import com.cognos.jsmcommon.util.io.LimitedBufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public final class ZipUtils {
    private static long m_test_zipLimit = 0L;

    public static InputStream getUnzippingInputStream(byte[] zippedBytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(zippedBytes);
        return new GZIPInputStream(bais);
    }

    public static byte[] gunzip(byte[] zipped_bytes) throws IOException {
        byte[] unzippedBytes = new byte[]{};
        InputStream is = ZipUtils.getUnzippingInputStream(zipped_bytes);
        unzippedBytes = IOUtils.toByteArray((InputStream)is);
        return unzippedBytes;
    }

    public static byte[] gzip(InputStream stream) throws IOException {
        if (stream == null) {
            return new byte[0];
        }
        byte[] zipped = new byte[]{};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        IOUtils.copy((InputStream)stream, (OutputStream)gzos);
        gzos.finish();
        stream.close();
        zipped = baos.toByteArray();
        gzos.close();
        baos.close();
        return zipped;
    }

    public static byte[] gzip(String content) throws IOException {
        if (content == null) {
            return new byte[0];
        }
        return ZipUtils.gzip(content.getBytes("UTF-8"));
    }

    public static byte[] gzip(byte[] bytes) throws IOException {
        if (bytes == null) {
            return new byte[0];
        }
        byte[] zipped = new byte[]{};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        gzos.write(bytes);
        gzos.finish();
        zipped = baos.toByteArray();
        gzos.close();
        baos.close();
        return zipped;
    }

    public static byte[] gzip(Object object) throws IOException {
        byte[] bytes = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        GZIPOutputStream gzip = null;
        baos = new ByteArrayOutputStream();
        gzip = new GZIPOutputStream(baos);
        oos = new ObjectOutputStream(gzip);
        oos.writeObject(object);
        gzip.finish();
        bytes = baos.toByteArray();
        oos.close();
        baos.close();
        gzip.close();
        return bytes;
    }

    public static Object gunzipObject(byte[] zippedObject) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(zippedObject);
        ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(bais));
        Object obj = ois.readObject();
        ois.close();
        return obj;
    }

    public static Object gunzip(InputStream is) throws ClassNotFoundException, IOException {
        ObjectInputStream ois = null;
        Object obj = null;
        ois = new ObjectInputStream(new GZIPInputStream(is));
        obj = ois.readObject();
        return obj;
    }

    public static byte[] writeObjectToBytes(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.flush();
        byte[] bytes = baos.toByteArray();
        oos.close();
        return bytes;
    }

    public static byte[] zip(byte[] bytes, String fileName) throws IOException {
        if (bytes == null) {
            return new byte[0];
        }
        ByteArrayOutputStream dest = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(dest);
        ZipEntry entry = new ZipEntry(fileName);
        out.putNextEntry(entry);
        out.write(bytes, 0, bytes.length);
        out.close();
        return dest.toByteArray();
    }

    public static byte[] zip(byte[] bytes, String fileName, long maxZippedSize) throws IOException {
        if (bytes == null) {
            return new byte[0];
        }
        ByteArrayOutputStream dest = new ByteArrayOutputStream();
        LimitedBufferedOutputStream lesbos = new LimitedBufferedOutputStream(dest, maxZippedSize);
        ZipOutputStream out = new ZipOutputStream(lesbos);
        ZipEntry entry = new ZipEntry(fileName);
        out.putNextEntry(entry);
        out.write(bytes, 0, bytes.length);
        lesbos.flush();
        out.close();
        return dest.toByteArray();
    }

    public static long estimateZippedSize(long size, String dataFormat) {
        long zippedEstimate = size;
        if (size < 300L) {
            return size;
        }
        if (dataFormat.equals("image/jpeg") || dataFormat.equals("image/png") || dataFormat.startsWith("image/")) {
            zippedEstimate = Math.round(0.9 * (double)size);
        } else if (dataFormat.equals("application/pdf") || dataFormat.contains("pdf")) {
            zippedEstimate = Math.round(0.8 * (double)size);
        } else if (dataFormat.startsWith("text/")) {
            zippedEstimate = Math.round(0.05 * (double)size);
        } else if (dataFormat.contains("application/vnd.ms-excel")) {
            zippedEstimate = Math.round(0.09 * (double)size);
        } else if (dataFormat.contains("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet") || dataFormat.contains("application/vnd.ms-powerpoint") || dataFormat.contains("application/vnd.openxmlformats-officedocument.presentationml.presentation") || dataFormat.contains("application/msword")) {
            zippedEstimate = Math.round(0.3 * (double)size);
        }
        return zippedEstimate;
    }

    public static boolean exceedsZipLimit(byte[] value) {
        return value != null && ZipUtils.isOverZipLimit(value.length);
    }

    public static boolean exceedsZipLimit(String value) {
        return value != null && ZipUtils.isOverZipLimit(Math.round((double)value.length() * 2.5));
    }

    public static boolean isOverZipLimit(long size) {
        return !DataSizeChecker.checkSize(size, ZipUtils.getZipLimit());
    }

    public static void setZipLimit(long zipLimit) {
        m_test_zipLimit = zipLimit;
    }

    private static long getZipLimit() {
        if (m_test_zipLimit > 0L) {
            return m_test_zipLimit;
        }
        double limit = DataSizeChecker.getPropertySizeLimitValue("dsCompressAttachmentLimit");
        return Math.round(limit * 1048576.0);
    }
}

