/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util.datasource;

import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.IMimeHeaderConstants;
import com.cognos.jsmcommon.util.ZipUtils;
import com.cognos.jsmcommon.util.datasource.ByteArrayDataSource;
import com.cognos.jsmcommon.util.datasource.NCDataSource;
import com.cognos.jsmcommon.util.datasource.NCFileDataSource;
import com.cognos.jsmcommon.util.datasource.NCUrlDataSource;
import com.cognos.jsmcommon.util.datasource.PngByteArrayDataSource;
import com.cognos.jsmcommon.util.datasource.ZipUnZipByteArrayDataSource;
import com.cognos.jsmcommon.util.datasource.ZippedByteArrayDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class DataSourceFactory
implements IMimeHeaderConstants {
    private static final String PNG_IMAGE = "png";

    public static NCDataSource getDataSource(InputStream is, String contentType, String contentEncoding) throws IOException {
        if ("zip".equals(contentEncoding)) {
            throw new IOException("wrong content encoding zip");
        }
        if ("gzip".equals(contentEncoding)) {
            return new ZipUnZipByteArrayDataSource(IOUtils.toByteArray((InputStream)is), contentType);
        }
        byte[] zipped = new byte[]{};
        if (DataSourceFactory.fixExcel2007() && null != contentType && contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
            byte[] contents = IOUtils.toByteArray((InputStream)is);
            is.close();
            byte[] loppedContents = new byte[contents.length - 2];
            System.arraycopy(contents, 0, loppedContents, 0, loppedContents.length);
            zipped = ZipUtils.gzip(loppedContents);
        } else {
            zipped = ZipUtils.gzip(is);
        }
        return new ZipUnZipByteArrayDataSource(zipped, contentType);
    }

    private static boolean fixExcel2007() {
        boolean result = false;
        try {
            String fix = CRNProperties.getInstance().getProperty("fixexcel2007");
            result = fix == null ? false : Boolean.valueOf(fix);
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        return result;
    }

    public static NCDataSource getDataSource(byte[] content, String contentType) throws IOException {
        return DataSourceFactory.getDataSource(content, contentType, "identity");
    }

    public static NCDataSource getDataSource(File file, String contentType) throws IOException {
        return new NCFileDataSource(file);
    }

    public static NCDataSource getDataSource(URL url, String contentType) throws IOException {
        return new NCUrlDataSource(url);
    }

    public static NCDataSource getGZippedDataSource(byte[] content, String contentType, String contentEncoding) throws IOException {
        return DataSourceFactory.getGZippedDataSource(content, contentType, contentEncoding, null);
    }

    public static NCDataSource getGZippedDataSource(byte[] content, String contentType, String contentEncoding, String filename) throws IOException {
        ByteArrayDataSource dataSource = null;
        if ("zip".equals(contentEncoding)) {
            throw new IOException("please use the getZippedDatasource method with the zip encoding");
        }
        dataSource = "gzip".equals(contentEncoding) ? new ByteArrayDataSource(content, contentType, DataSourceFactory.getGzipFileName(filename)) : (ZipUtils.exceedsZipLimit(content) ? new ByteArrayDataSource(ZipUtils.gzip(content), contentType, DataSourceFactory.getGzipFileName(filename)) : new ByteArrayDataSource(content, contentType, filename));
        return dataSource;
    }

    private static String getGzipFileName(String name) {
        if (name == null || name.endsWith(".gz")) {
            return name;
        }
        name = name + ".gz";
        return name;
    }

    public static NCDataSource getPreZippedDataSource(byte[] content, String contentType, String fileName) throws IOException {
        NCDataSource dataSource = null;
        dataSource = contentType != null && contentType.equals("application/x-zip-compressed") ? new ZippedByteArrayDataSource(content, fileName) : DataSourceFactory.getSimpleDataSource(content, contentType);
        return dataSource;
    }

    public static NCDataSource getZippedDataSource(byte[] content, String contentType, String contentEncoding, String fileName) throws IOException {
        NCDataSource dataSource = null;
        dataSource = "gzip".equals(contentEncoding) ? DataSourceFactory.getGZippedDataSource(content, contentType, contentEncoding, fileName) : (!"zip".equals(contentEncoding) ? (ZipUtils.exceedsZipLimit(content) ? new ZippedByteArrayDataSource(ZipUtils.zip(content, fileName), fileName) : new ByteArrayDataSource(content, contentType, fileName)) : new ZippedByteArrayDataSource(content, fileName));
        return dataSource;
    }

    public static NCDataSource getDataSource(byte[] content, String contentType, String contentEncoding) throws IOException {
        NCDataSource ds = null;
        ds = DataSourceFactory.getPngDataSource(content, contentType);
        if (ds == null) {
            if ("zip".equals(contentEncoding)) {
                throw new IOException("wrong encoding " + contentEncoding);
            }
            ds = "gzip".equals(contentEncoding) ? new ZipUnZipByteArrayDataSource(content, contentType) : (ZipUtils.isOverZipLimit(content.length) ? new ZipUnZipByteArrayDataSource(ZipUtils.gzip(content), contentType) : new ByteArrayDataSource(content, contentType));
        }
        return ds;
    }

    public static NCDataSource getSimpleDataSource(byte[] content, String contentType) throws IOException {
        NCDataSource ds = null;
        ds = DataSourceFactory.getPngDataSource(content, contentType);
        if (ds != null) {
            return ds;
        }
        return new ByteArrayDataSource(content, contentType);
    }

    private static NCDataSource getPngDataSource(byte[] content, String contentType) throws IOException {
        boolean isLotus = false;
        try {
            String isLotusString = CRNProperties.getInstance().getProperty("lotus.compatibility.mode");
            isLotus = Boolean.valueOf(isLotusString);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (isLotus && contentType != null && contentType.indexOf(PNG_IMAGE) != -1) {
            return new PngByteArrayDataSource(content, contentType);
        }
        return null;
    }
}

