/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util.datasource;

import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.datasource.NCDataSource;
import java.io.IOException;
import java.io.OutputStream;

public abstract class DataSourceImpl
implements NCDataSource {
    static final long serialVersionUID = 70009003L;
    private String m_contentType = "text/plain";
    private String m_name;
    private static boolean log = true;

    DataSourceImpl(String content_type, String name) {
        this.m_contentType = content_type != null ? content_type : this.m_contentType;
        this.m_name = name;
    }

    @Override
    public String getContentEncoding() {
        return "identity";
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public String getName() {
        return this.m_name;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("no output stream available");
    }

    protected void debug(String message) {
        if (log) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(SDSLevel.DEBUG, message);
        } else {
            System.out.println(message);
        }
    }

    public static void setLog(boolean doLog) {
        log = doLog;
    }

    void setContentType(String type) {
        this.m_contentType = type;
    }
}

